/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.MobSpawnFilter;
import com.github.elenterius.biomancy.world.mound.MoundChamber;
import com.github.elenterius.biomancy.world.mound.MoundGenerator;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.geometry.ShapeHierarchy;
import com.github.elenterius.biomancy.world.spatial.type.ShapeSerializers;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MoundShape
implements Shape,
MobSpawnFilter {
    private final ProcGenValues procGenValues;
    BlockPos origin;
    ShapeHierarchy<Shape> boundingShapes;
    ShapeHierarchy<MoundChamber> chamberShapes;

    MoundShape(BlockPos origin, List<Shape> boundingShapes, List<MoundChamber> chamberShapes, ProcGenValues procGenValues) {
        this.boundingShapes = new ShapeHierarchy<Shape>(boundingShapes);
        this.chamberShapes = new ShapeHierarchy<MoundChamber>(chamberShapes);
        this.origin = origin;
        this.procGenValues = procGenValues;
    }

    public BlockPos getOrigin() {
        return this.origin;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.boundingShapes.contains(x, y, z);
    }

    @Override
    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.boundingShapes.intersectsCuboid(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public Vec3 center() {
        return this.boundingShapes.getCenter();
    }

    @Override
    public double distanceToSqr(double x, double y, double z) {
        return this.boundingShapes.distanceToSqr(x, y, z);
    }

    @Override
    public AABB getAABB() {
        return this.boundingShapes.getAABB();
    }

    public boolean hasChamberAt(BlockPos pos) {
        return this.chamberShapes.contains((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    public MoundChamber getChamberAt(BlockPos pos) {
        return this.getChamberAt((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    public MoundChamber getChamberAt(double x, double y, double z) {
        return this.chamberShapes.getClosestShapeContaining(x, y, z);
    }

    @Nullable
    public List<MoundChamber> getChambersAt(BlockPos pos) {
        return this.getChambersAt((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    public List<MoundChamber> getChambersAt(double x, double y, double z) {
        return this.chamberShapes.getShapesContaining(x, y, z);
    }

    @Nullable
    public Shape getBoundingShapeAt(BlockPos pos) {
        return this.getBoundingShapeAt((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    public Shape getBoundingShapeAt(double x, double y, double z) {
        return this.boundingShapes.getClosestShapeContaining(x, y, z);
    }

    public ProcGenValues getProcGenValues() {
        return this.procGenValues;
    }

    @Override
    public NBTSerializer<Shape> getNBTSerializer() {
        return ShapeSerializers.MOUND_SERIALIZER;
    }

    @Override
    public boolean isMobAllowedToSpawn(Mob mob, MobSpawnType spawnReason, LevelAccessor level, double x, double y, double z) {
        return false;
    }

    public record ProcGenValues(long seed, byte extraRadius, byte extraHeight, byte subSpires, int maxBuildHeight, int seaLevel, float biomeTemperature, float biomeHumidity) {
        public float heightMultiplier() {
            return (float)this.extraHeight / 100.0f;
        }

        public float radiusMultiplier() {
            return (float)this.extraRadius / 100.0f;
        }

        public void writeTo(CompoundTag tag) {
            tag.m_128356_("Seed", this.seed);
            tag.m_128344_("Radius", this.extraRadius);
            tag.m_128344_("Height", this.extraHeight);
            tag.m_128344_("SubSpires", this.subSpires);
            tag.m_128405_("MaxBuildHeight", this.maxBuildHeight);
            tag.m_128405_("SeaLevel", this.seaLevel);
            tag.m_128350_("BiomeTemperature", this.biomeTemperature);
            tag.m_128350_("BiomeHumidity", this.biomeHumidity);
        }

        public static ProcGenValues readFrom(CompoundTag tag) {
            long seed = tag.m_128454_("Seed");
            byte extraRadius = tag.m_128445_("Radius");
            byte height = tag.m_128445_("Height");
            byte subSpires = tag.m_128445_("SubSpires");
            int maxBuildHeight = tag.m_128451_("MaxBuildHeight");
            int seaLevel = tag.m_128451_("SeaLevel");
            float biomeTemperature = tag.m_128457_("BiomeTemperature");
            float biomeHumidity = tag.m_128457_("BiomeHumidity");
            return new ProcGenValues(seed, extraRadius, height, subSpires, maxBuildHeight, seaLevel, biomeTemperature, biomeHumidity);
        }
    }

    public record Serializer(String id) implements NBTSerializer<MoundShape>
    {
        @Override
        public CompoundTag write(MoundShape shape) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("Origin", shape.origin.m_121878_());
            shape.procGenValues.writeTo(tag);
            return tag;
        }

        @Override
        public MoundShape read(CompoundTag tag) {
            BlockPos origin = BlockPos.m_122022_((long)tag.m_128454_("Origin"));
            ProcGenValues procGenValues = ProcGenValues.readFrom(tag);
            return MoundGenerator.constructShape(origin, procGenValues);
        }
    }
}

