/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.permission;

import net.minecraft.nbt.CompoundTag;

public enum UserType {
    NONE(0),
    DEFAULT(1),
    ADMIN(2),
    OWNER(3);

    static final UserType[] SORTED_LEVELS;
    private final byte level;

    private UserType(int accessLevel) {
        this.level = (byte)accessLevel;
    }

    public static UserType fromId(byte level) {
        if (level < 0 || level > SORTED_LEVELS.length - 1) {
            return NONE;
        }
        return SORTED_LEVELS[level];
    }

    public static UserType deserialize(CompoundTag nbt) {
        return UserType.fromId(nbt.m_128445_("AccessLevel"));
    }

    public boolean isUserLevel() {
        return this.level > UserType.NONE.level;
    }

    public boolean isAdminLevel() {
        return this.level >= UserType.ADMIN.level;
    }

    public void serialize(CompoundTag nbt) {
        nbt.m_128344_("AccessLevel", this.level);
    }

    public byte getAccessLevel() {
        return this.level;
    }

    static {
        SORTED_LEVELS = new UserType[]{NONE, DEFAULT, ADMIN, OWNER};
    }
}

