/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util.animation;

import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.model.data.EntityModelData;

public final class MobAnimations {
    public static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenPlay("walk");
    public static final RawAnimation BABY_TRANSFORM_ANIMATION = RawAnimation.begin().thenPlay("baby_transform");

    private MobAnimations() {
    }

    public static <T extends GeoEntity> AnimationController<T> walkController(T geoEntity) {
        return new AnimationController(geoEntity, "walk", state -> {
            if (state.isMoving()) {
                return state.setAndContinue(WALK_ANIMATION);
            }
            return PlayState.STOP;
        });
    }

    public static <T extends GeoEntity> AnimationController<T> babyTransformController(T geoEntity) {
        return new AnimationController(geoEntity, "baby_transform", state -> {
            if (((EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA)).isChild()) {
                return state.setAndContinue(BABY_TRANSFORM_ANIMATION);
            }
            return PlayState.STOP;
        });
    }
}

