/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackCounter {
    private final Object2IntMap<HashKey> countedItemStacks = new Object2IntOpenHashMap();
    private List<CountedItem> countedItems = null;

    public List<CountedItem> getItemCounts() {
        if (this.countedItems != null) {
            return this.countedItems;
        }
        this.countedItems = this.countedItemStacks.object2IntEntrySet().stream().sorted((a, b) -> IntComparators.OPPOSITE_COMPARATOR.compare(a.getIntValue(), b.getIntValue())).map(entry -> new CountedItem(((HashKey)entry.getKey()).stack(), entry.getIntValue())).toList();
        return this.countedItems;
    }

    public List<CountedItem> getItemCountSorted(int limit, boolean ascending) {
        IntComparator comparator = ascending ? IntComparators.NATURAL_COMPARATOR : IntComparators.OPPOSITE_COMPARATOR;
        return this.countedItemStacks.object2IntEntrySet().stream().sorted((a, b) -> comparator.compare(a.getIntValue(), b.getIntValue())).limit(limit).map(entry -> new CountedItem(((HashKey)entry.getKey()).stack(), entry.getIntValue())).toList();
    }

    public void accountSimpleStack(ItemStack stack) {
        if (!(stack.m_41768_() || stack.m_41793_() || stack.m_41788_())) {
            this.accountStack(stack);
        }
    }

    public void accountStack(ItemStack stack) {
        this.accountStack(stack, stack.m_41613_());
    }

    public void accountStacks(NonNullList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            this.accountStack(stack);
        }
    }

    public void accountStacks(Container container) {
        for (int i = 0; i < container.m_6643_(); ++i) {
            this.accountStack(container.m_8020_(i));
        }
    }

    public void accountStacks(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.accountStack(handler.getStackInSlot(i));
        }
    }

    public void accountStack(ItemStack stack, int amount) {
        if (stack.m_41619_()) {
            return;
        }
        this.put(stack, amount);
    }

    private void put(ItemStack template, int amount) {
        HashKey key = HashKey.forQuery(template);
        if (this.countedItemStacks.containsKey((Object)key)) {
            this.countedItemStacks.mergeInt((Object)key, amount, Integer::sum);
        } else {
            HashKey.EntryKey entryKey = new HashKey.EntryKey(key.hash(), template);
            this.countedItemStacks.put((Object)entryKey, amount);
        }
        this.countedItems = null;
    }

    public boolean has(ItemStack template) {
        return this.countedItemStacks.getInt((Object)HashKey.forQuery(template)) > 0;
    }

    public int getCount(ItemStack template) {
        return this.countedItemStacks.getInt((Object)HashKey.forQuery(template));
    }

    public void clear() {
        this.countedItemStacks.clear();
        this.countedItems = null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static interface HashKey {
        public ItemStack stack();

        public int hash();

        public static HashKey forQuery(ItemStack stack) {
            return new DummyKey(stack);
        }

        public static HashKey forModification(ItemStack stack) {
            return new EntryKey(stack);
        }

        public record DummyKey(int hash) implements HashKey
        {
            DummyKey(ItemStack stack) {
                this(Objects.hash(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), stack.m_41783_()));
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof HashKey) {
                    HashKey that = (HashKey)obj;
                    return this.hash == that.hash();
                }
                return false;
            }

            @Override
            public ItemStack stack() {
                return ItemStack.f_41583_;
            }

            @Override
            public int hashCode() {
                return this.hash;
            }
        }

        public record EntryKey(int hash, ItemStack stack) implements HashKey
        {
            public EntryKey(int hash, ItemStack stack) {
                this.hash = hash;
                this.stack = stack.m_255036_(1);
            }

            EntryKey(ItemStack stack) {
                this(Objects.hash(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), stack.m_41783_()), stack);
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj instanceof HashKey) {
                    HashKey that = (HashKey)obj;
                    return this.hash == that.hash();
                }
                return false;
            }

            @Override
            public int hashCode() {
                return this.hash;
            }
        }
    }

    public record CountedItem(ItemStack stack, int amount) {
    }
}

