/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.network;

import com.github.elenterius.biomancy.menu.BioLabMenu;
import com.github.elenterius.biomancy.util.ItemStackFilter;
import com.github.elenterius.biomancy.util.ItemStackFilterList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class BioLabFilterMessage {
    public final int containerId;
    private final List<ItemStack> filters;

    public BioLabFilterMessage(int containerId, ItemStackFilterList filters) {
        this.containerId = containerId;
        this.filters = filters.stream().map(ItemStackFilter::getItemStack).collect(Collectors.toCollection(ArrayList::new));
    }

    private BioLabFilterMessage(int containerId, List<ItemStack> filters) {
        this.containerId = containerId;
        this.filters = filters;
    }

    public static BioLabFilterMessage decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        List filterItems = (List)buffer.m_236838_(ArrayList::new, BioLabFilterMessage::decodeNullableItemStack);
        return new BioLabFilterMessage(containerId, filterItems);
    }

    private static void encodeNullableItemStack(FriendlyByteBuf buffer, @Nullable ItemStack stack) {
        buffer.writeBoolean(stack != null);
        if (stack != null) {
            buffer.m_130055_(stack);
        }
    }

    @Nullable
    private static ItemStack decodeNullableItemStack(FriendlyByteBuf buffer) {
        return !buffer.readBoolean() ? null : buffer.m_130267_();
    }

    public static void handle(BioLabFilterMessage packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                AbstractContainerMenu patt2099$temp;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && (patt2099$temp = player.f_36096_) instanceof BioLabMenu) {
                    BioLabMenu menu = (BioLabMenu)patt2099$temp;
                    if (menu.f_38840_ == packet.containerId) {
                        menu.setFilters(packet.filters);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.containerId);
        buffer.m_236828_(this.filters, BioLabFilterMessage::encodeNullableItemStack);
    }
}

