/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.decomposer.DecomposerBlockEntity;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class DecomposerMenu
extends PlayerContainerMenu {
    protected final Level level;
    private final DecomposerBlockEntity decomposer;

    protected DecomposerMenu(int id, Inventory playerInventory, @Nullable DecomposerBlockEntity decomposer) {
        super((MenuType)ModMenuTypes.DECOMPOSER.get(), id, playerInventory, 111, 169);
        this.level = playerInventory.f_35978_.m_9236_();
        this.decomposer = decomposer;
        if (decomposer != null) {
            this.m_38897_((Slot)new SlotItemHandler(decomposer.getFuelInventory(), 0, 39, 66));
            this.m_38897_((Slot)new SlotItemHandler(decomposer.getInputInventory(), 0, 66, 26));
            int posY = 48;
            int posX = 88;
            InventoryHandler<?> itemHandler = decomposer.getOutputInventory();
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 0, posX, posY));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 1, posX, posY + 18));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 2, posX + 18, posY));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 3, posX + 18, posY + 18));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 4, posX + 36, posY));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 5, posX + 36, posY + 18));
            this.m_38884_(decomposer.getStateData());
        }
    }

    public static DecomposerMenu createServerMenu(int screenId, Inventory playerInventory, DecomposerBlockEntity decomposer) {
        return new DecomposerMenu(screenId, playerInventory, decomposer);
    }

    public static DecomposerMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        DecomposerBlockEntity be;
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        DecomposerBlockEntity decomposer = blockEntity instanceof DecomposerBlockEntity ? (be = (DecomposerBlockEntity)blockEntity) : null;
        return new DecomposerMenu(screenId, playerInventory, decomposer);
    }

    public boolean m_6875_(Player player) {
        return this.decomposer != null && this.decomposer.canPlayerInteract(player);
    }

    public float getCraftingProgressNormalized() {
        if (this.decomposer.getStateData().timeForCompletion == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.decomposer.getStateData().timeElapsed / (float)this.decomposer.getStateData().timeForCompletion), (float)0.0f, (float)1.0f);
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.decomposer.getStateData().fuelHandler.getFuelAmount() / (float)this.decomposer.getStateData().fuelHandler.getMaxFuelAmount()), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.decomposer.getStateData().fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return this.decomposer.getStateData().fuelHandler.getMaxFuelAmount();
    }

    public int getFuelCost() {
        return this.decomposer.getStateData().getFuelCost();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case INPUT_ZONE: 
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoInputZone(stackInSlot) || this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"DecomposerMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoInputZone(ItemStack stackInSlot) {
        if (((SimpleRecipeType.ItemStackRecipeType)DecomposerBlockEntity.RECIPE_TYPE.get()).getRecipeForIngredient(this.level, stackInSlot).isPresent()) {
            return this.mergeInto(SlotZone.INPUT_ZONE, stackInSlot, false);
        }
        return false;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(PLAYER_HOTBAR, 27),
        FUEL_ZONE(PLAYER_MAIN_INVENTORY, 1),
        INPUT_ZONE(FUEL_ZONE, 1),
        OUTPUT_ZONE(INPUT_ZONE, 6);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(SlotZone slotZone, int numberOfSlots) {
            this(slotZone.lastIndexPlus1, numberOfSlots);
        }

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

