/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.biolab.BioLabBlockEntity;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.inventory.BehavioralItemHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import com.github.elenterius.biomancy.network.ModNetworkHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class BioLabMenu
extends PlayerContainerMenu {
    protected final Level level;
    private final Player player;
    private final BioLabBlockEntity bioLab;
    private final List<Slot> inputSlots;

    protected BioLabMenu(int id, Inventory playerInventory, @Nullable BioLabBlockEntity bioLab) {
        super((MenuType)ModMenuTypes.BIO_LAB.get(), id, playerInventory, 137, 195);
        this.level = playerInventory.f_35978_.m_9236_();
        this.player = playerInventory.f_35978_;
        this.bioLab = bioLab;
        if (bioLab != null) {
            this.m_38897_((Slot)new SlotItemHandler(bioLab.getFuelInventory(), 0, 31, 88));
            InventoryHandler<BehavioralItemHandler.LockableItemStackFilterInput> itemHandler = bioLab.getInputInventory();
            this.inputSlots = List.of(this.m_38897_((Slot)new SlotItemHandler(itemHandler, 0, 50, 28)), this.m_38897_((Slot)new SlotItemHandler(itemHandler, 1, 70, 28)), this.m_38897_((Slot)new SlotItemHandler(itemHandler, 2, 90, 28)), this.m_38897_((Slot)new SlotItemHandler(itemHandler, 3, 110, 28)), this.m_38897_((Slot)new SlotItemHandler(itemHandler, 4, 80, 62)));
            this.m_38897_((Slot)new SlotItemHandler(bioLab.getOutputInventory(), 0, 80, 88));
            this.m_38884_(bioLab.getStateData());
        } else {
            this.inputSlots = List.of();
        }
    }

    public static BioLabMenu createServerMenu(int containerId, Inventory playerInventory, BioLabBlockEntity biolab) {
        return new BioLabMenu(containerId, playerInventory, biolab);
    }

    public static BioLabMenu createClientMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        BioLabBlockEntity bioLab;
        BlockPos blockPos = extraData.m_130135_();
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(blockPos);
        return new BioLabMenu(containerId, playerInventory, blockEntity instanceof BioLabBlockEntity ? (bioLab = (BioLabBlockEntity)blockEntity) : null);
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0 && !this.level.f_46443_) {
            this.bioLab.getInputInventory().get().toggleLock();
            return true;
        }
        return false;
    }

    public void m_150429_() {
        super.m_150429_();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetworkHandler.sendBioLabFilterToClient(serverPlayer, this.f_38840_, this.bioLab.getInputInventory().get().getFilters());
        }
    }

    public void setFilters(List<ItemStack> filters) {
        this.bioLab.getInputInventory().get().setFilters(filters);
    }

    public void renderFilters(GuiGraphics guiGraphics, Minecraft minecraft, int leftPos, int topPos) {
        for (Slot slot : this.inputSlots) {
            if (!slot.m_7993_().m_41619_()) continue;
            int slotIndex = slot.getSlotIndex();
            ItemStack filter = this.bioLab.getInputInventory().get().getFilterItemStack(slotIndex);
            if (filter == null || filter.m_41619_()) continue;
            this.renderFilter(guiGraphics, minecraft, filter, leftPos + slot.f_40220_, topPos + slot.f_40221_);
        }
    }

    private void renderFilter(GuiGraphics guiGraphics, Minecraft minecraft, ItemStack stack, int x, int y) {
        guiGraphics.m_280509_(x, y, x + 16, y + 16, 0x30FF0000);
        guiGraphics.m_280203_(stack, x, y);
        guiGraphics.m_285944_(RenderType.m_285811_(), x, y, x + 16, y + 16, 0x30FFFFFF);
        guiGraphics.m_280370_(minecraft.f_91062_, stack, x, y);
    }

    public boolean m_6875_(Player player) {
        return this.bioLab != null && this.bioLab.canPlayerInteract(player);
    }

    public float getCraftingProgressNormalized() {
        if (this.bioLab.getStateData().timeForCompletion == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)((float)this.bioLab.getStateData().timeElapsed / (float)this.bioLab.getStateData().timeForCompletion), (float)0.0f, (float)1.0f);
    }

    public int getFuelCost() {
        return this.bioLab.getStateData().getFuelCost();
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.bioLab.getStateData().fuelHandler.getFuelAmount() / (float)this.bioLab.getStateData().fuelHandler.getMaxFuelAmount()), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.bioLab.getStateData().fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return this.bioLab.getStateData().fuelHandler.getMaxFuelAmount();
    }

    public boolean isFilterLocked() {
        return this.bioLab.getStateData().isFilterLocked();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_HOTBAR, SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, true);
                break;
            }
            case INPUT_ZONE: 
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoInputZone(stackInSlot) || this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"DecomposerMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoInputZone(ItemStack stackInSlot) {
        if (((SimpleRecipeType.ItemStackRecipeType)BioLabBlockEntity.RECIPE_TYPE.get()).getRecipeForIngredient(this.level, stackInSlot).isPresent()) {
            return this.mergeInto(SlotZone.INPUT_ZONE, stackInSlot, false);
        }
        return false;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(PLAYER_HOTBAR, 27),
        FUEL_ZONE(PLAYER_MAIN_INVENTORY, 1),
        INPUT_ZONE(FUEL_ZONE, 5),
        OUTPUT_ZONE(INPUT_ZONE, 1);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(SlotZone prevSlotZone, int numberOfSlots) {
            this(prevSlotZone.lastIndexPlus1, numberOfSlots);
        }

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

