/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.menu;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.bioforge.BioForgeBlockEntity;
import com.github.elenterius.biomancy.block.bioforge.BioForgeStateData;
import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.recipe.BioForgingRecipe;
import com.github.elenterius.biomancy.init.ModMenuTypes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.menu.ISlotZone;
import com.github.elenterius.biomancy.menu.PlayerContainerMenu;
import com.github.elenterius.biomancy.util.ItemStackCounter;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class BioForgeMenu
extends PlayerContainerMenu {
    final ResultContainer resultContainer = new ResultContainer();
    private final BioForgeBlockEntity bioforge;
    private int playerInvChanges;
    private final ItemStackCounter itemCounter = new ItemStackCounter();
    @Nullable
    private BioForgingRecipe selectedRecipe;
    private long prevSoundTime;

    protected BioForgeMenu(int id, final Inventory playerInventory, @Nullable BioForgeBlockEntity bioforge) {
        super((MenuType)ModMenuTypes.BIO_FORGE.get(), id, playerInventory, 124, 137, 195);
        this.bioforge = bioforge;
        if (bioforge != null) {
            bioforge.startOpen(playerInventory.f_35978_);
            this.m_38897_((Slot)new SlotItemHandler(bioforge.getFuelInventory(), 0, 139, 53));
            this.m_38897_(new CustomResultSlot(playerInventory.f_35978_, this.resultContainer, 0, 196, 35));
            this.m_38884_(bioforge.getStateData());
            this.m_38893_(new ContainerListener(){
                int fuel = 0;

                public void m_7934_(AbstractContainerMenu container, int slot, ItemStack stack) {
                }

                public void m_142153_(AbstractContainerMenu container, int index, int value) {
                    Player player;
                    if (index == 0 && (player = playerInventory.f_35978_) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        BioForgingRecipe recipe = BioForgeMenu.this.getSelectedRecipe();
                        if (recipe != null && recipe.getCraftingCostNutrients() > this.fuel && recipe.getCraftingCostNutrients() <= value) {
                            BioForgeMenu.this.updateResultSlot(serverPlayer);
                        }
                        this.fuel = value;
                    }
                }
            });
        }
    }

    public BioForgeStateData getStateData() {
        return this.bioforge.getStateData();
    }

    public static BioForgeMenu createClientMenu(int screenId, Inventory playerInventory, FriendlyByteBuf extraData) {
        BioForgeBlockEntity be;
        BlockEntity blockEntity = playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        BioForgeBlockEntity bioforge = blockEntity instanceof BioForgeBlockEntity ? (be = (BioForgeBlockEntity)blockEntity) : null;
        return new BioForgeMenu(screenId, playerInventory, bioforge);
    }

    @Override
    protected void onPlayerMainInventoryChanged(Inventory inventory) {
        Player player;
        if (!inventory.f_35978_.m_9236_().f_46443_ && (player = inventory.f_35978_) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trackPlayerInvChanges(serverPlayer, inventory);
        }
    }

    private void trackPlayerInvChanges(ServerPlayer serverPlayer, Inventory inventory) {
        if (this.playerInvChanges != inventory.m_36072_()) {
            this.countPlayerInvItems(serverPlayer, inventory);
            this.updateResultSlot(serverPlayer);
            this.playerInvChanges = inventory.m_36072_();
        }
    }

    private void countPlayerInvItems(ServerPlayer serverPlayer, Inventory inventory) {
        this.itemCounter.clear();
        this.itemCounter.accountStacks((NonNullList<ItemStack>)inventory.f_35974_);
    }

    private void updateResultSlot(ServerPlayer serverPlayer) {
        ItemStack resultStack = ItemStack.f_41583_;
        BioForgingRecipe recipe = this.getSelectedRecipe();
        if (recipe != null && this.resultContainer.m_40135_(serverPlayer.m_9236_(), serverPlayer, (Recipe)recipe) && this.canCraft(recipe)) {
            resultStack = recipe.m_8043_(serverPlayer.m_9236_().m_9598_()).m_41777_();
        }
        this.resultContainer.m_6836_(0, resultStack);
        this.m_150404_(0, resultStack);
        this.m_38946_();
    }

    @Nullable
    public BioForgingRecipe getSelectedRecipe() {
        return this.selectedRecipe;
    }

    public void setSelectedRecipe(@Nullable BioForgingRecipe recipe, ServerPlayer serverPlayer) {
        this.selectedRecipe = recipe;
        this.countPlayerInvItems(serverPlayer, serverPlayer.m_150109_());
        this.updateResultSlot(serverPlayer);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_6211_();
        if (this.bioforge != null) {
            this.bioforge.stopOpen(player);
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.resultContainer && super.m_5882_(stack, slot);
    }

    public boolean m_6875_(Player player) {
        return this.bioforge != null && this.bioforge.canPlayerInteract(player);
    }

    public float getFuelAmountNormalized() {
        return Mth.m_14036_((float)((float)this.getFuelAmount() / 1000.0f), (float)0.0f, (float)1.0f);
    }

    public int getFuelAmount() {
        return this.bioforge.getStateData().fuelHandler.getFuelAmount();
    }

    public int getMaxFuelAmount() {
        return 1000;
    }

    public boolean isResultEmpty() {
        return this.resultContainer.m_7983_();
    }

    public ItemStack m_7648_(Player player, int index) {
        boolean successfulTransfer;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
        ItemStack copyOfStack = stackInSlot.m_41777_();
        SlotZone slotZone = SlotZone.getZoneFromIndex(index);
        switch (slotZone) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OUTPUT_ZONE: {
                boolean bl = this.mergeIntoPlayerMainInventory(stackInSlot);
                break;
            }
            case FUEL_ZONE: {
                boolean bl = this.mergeIntoEither(SlotZone.PLAYER_MAIN_INVENTORY, SlotZone.PLAYER_HOTBAR, stackInSlot, false);
                break;
            }
            case PLAYER_HOTBAR: 
            case PLAYER_MAIN_INVENTORY: {
                boolean bl = successfulTransfer = this.mergeIntoFuelZone(stackInSlot) || this.mergeIntoPlayerZone(slotZone, stackInSlot);
            }
        }
        if (!successfulTransfer) {
            return ItemStack.f_41583_;
        }
        if (slotZone == SlotZone.OUTPUT_ZONE) {
            stackInSlot.m_41720_().m_7836_(stackInSlot, player.m_9236_(), player);
            slot.m_40234_(stackInSlot, copyOfStack);
        }
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stackInSlot.m_41613_() == copyOfStack.m_41613_()) {
            BiomancyMod.LOGGER.warn(MarkerManager.getMarker((String)"BioForgeMenu"), "Stack transfer failed in an unexpected way!");
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stackInSlot);
        return copyOfStack;
    }

    private boolean mergeIntoFuelZone(ItemStack stackInSlot) {
        if (Nutrients.isValidFuel(stackInSlot)) {
            return this.mergeInto(SlotZone.FUEL_ZONE, stackInSlot, true);
        }
        return false;
    }

    private boolean mergeIntoPlayerZone(SlotZone slotZone, ItemStack stackInSlot) {
        if (slotZone == SlotZone.PLAYER_HOTBAR) {
            return this.mergeInto(SlotZone.PLAYER_MAIN_INVENTORY, stackInSlot, false);
        }
        return this.mergeInto(SlotZone.PLAYER_HOTBAR, stackInSlot, false);
    }

    private boolean mergeIntoPlayerMainInventory(ItemStack stackInSlot) {
        return this.m_38903_(stackInSlot, SlotZone.PLAYER_HOTBAR.getFirstIndex(), SlotZone.PLAYER_MAIN_INVENTORY.getLastIndexPlusOne(), true);
    }

    public static BioForgeMenu createServerMenu(int screenId, Inventory playerInventory, BioForgeBlockEntity bioforge) {
        return new BioForgeMenu(screenId, playerInventory, bioforge);
    }

    private boolean canCraft(@Nullable BioForgingRecipe recipe) {
        return recipe != null && this.getFuelAmount() >= recipe.getCraftingCostNutrients() && recipe.isCraftable(this.itemCounter);
    }

    private void consumeCraftingIngredients(Inventory inventory, BioForgingRecipe recipe) {
        List<IngredientStack> ingredients = recipe.getIngredientQuantities();
        int[] ingredientCost = new int[ingredients.size()];
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientCost[i] = ingredients.get(i).count();
        }
        block1: for (int idx = 0; idx < inventory.f_35974_.size(); ++idx) {
            ItemStack foundStack = (ItemStack)inventory.f_35974_.get(idx);
            if (foundStack.m_41619_()) continue;
            for (int i = 0; i < ingredients.size(); ++i) {
                int remainingCost = ingredientCost[i];
                if (remainingCost <= 0 || !ingredients.get(i).testItem(foundStack)) continue;
                int amount = Math.min(remainingCost, foundStack.m_41613_());
                foundStack.m_41774_(amount);
                int n = i;
                ingredientCost[n] = ingredientCost[n] - amount;
                continue block1;
            }
        }
        inventory.m_6596_();
        this.bioforge.getStateData().fuelHandler.addFuelAmount(-recipe.getCraftingCostNutrients());
    }

    private class CustomResultSlot
    extends Slot {
        private final Player player;
        private int removeCount;

        public CustomResultSlot(Player player, ResultContainer container, int index, int x, int y) {
            super((Container)container, index, x, y);
            this.player = player;
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }

        public ItemStack m_6201_(int amount) {
            if (this.m_6657_()) {
                this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
            }
            return super.m_6201_(amount);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.m_5845_(stack);
        }

        protected void m_6405_(int craftedItems) {
            this.removeCount += craftedItems;
        }

        protected void m_5845_(ItemStack stack) {
            if (this.removeCount > 0) {
                stack.m_41678_(this.player.m_9236_(), this.player, this.removeCount);
            }
            this.removeCount = 0;
        }

        public void m_142406_(Player player, ItemStack stack) {
            ServerLevel serverLevel;
            long time;
            Level level;
            if (player.m_9236_().f_46443_) {
                this.m_6654_();
                return;
            }
            BioForgingRecipe recipe = BioForgeMenu.this.getSelectedRecipe();
            if (recipe != null) {
                BioForgeMenu.this.consumeCraftingIngredients(player.m_150109_(), recipe);
                BioForgeMenu.this.m_38946_();
            }
            this.m_6654_();
            this.m_5845_(stack);
            BioForgeMenu.this.onPlayerMainInventoryChanged(player.m_150109_());
            if (BioForgeMenu.this.bioforge != null && (level = BioForgeMenu.this.bioforge.m_58904_()) instanceof ServerLevel && BioForgeMenu.this.prevSoundTime != (time = (serverLevel = (ServerLevel)level).m_46467_())) {
                SoundUtil.broadcastBlockSound(serverLevel, BioForgeMenu.this.bioforge.m_58899_(), ModSoundEvents.UI_BIO_FORGE_TAKE_RESULT);
                BioForgeMenu.this.prevSoundTime = time;
            }
        }
    }

    public static enum SlotZone implements ISlotZone
    {
        PLAYER_HOTBAR(0, 9),
        PLAYER_MAIN_INVENTORY(SlotZone.PLAYER_HOTBAR.lastIndexPlus1, 27),
        FUEL_ZONE(SlotZone.PLAYER_MAIN_INVENTORY.lastIndexPlus1, 1),
        OUTPUT_ZONE(SlotZone.FUEL_ZONE.lastIndexPlus1, 1);

        public final int firstIndex;
        public final int slotCount;
        public final int lastIndexPlus1;

        private SlotZone(int firstIndex, int numberOfSlots) {
            this.firstIndex = firstIndex;
            this.slotCount = numberOfSlots;
            this.lastIndexPlus1 = firstIndex + numberOfSlots;
        }

        public static SlotZone getZoneFromIndex(int slotIndex) {
            for (SlotZone slotZone : SlotZone.values()) {
                if (slotIndex < slotZone.firstIndex || slotIndex >= slotZone.lastIndexPlus1) continue;
                return slotZone;
            }
            throw new IndexOutOfBoundsException("Unexpected slotIndex");
        }

        @Override
        public int getFirstIndex() {
            return this.firstIndex;
        }

        @Override
        public int getLastIndexPlusOne() {
            return this.lastIndexPlus1;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }
    }
}

