/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon.gun;

import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.item.weapon.BladeProperties;
import com.github.elenterius.biomancy.item.weapon.gun.Gun;
import com.github.elenterius.biomancy.item.weapon.gun.GunItem;
import com.github.elenterius.biomancy.item.weapon.gun.GunProperties;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public abstract class GunbladeItem
extends GunItem
implements Vanishable {
    protected final Multimap<Attribute, AttributeModifier> defaultBladeModifiers;
    protected final Multimap<Attribute, AttributeModifier> defaultGunModifiers;

    protected GunbladeItem(Item.Properties itemProperties, BladeProperties bladeProperties, GunProperties gunProperties, ModProjectiles.ConfiguredProjectile<?> projectile) {
        super(itemProperties, gunProperties, projectile);
        this.defaultBladeModifiers = this.createDefaultBladeModifiers(bladeProperties);
        this.defaultGunModifiers = this.createDefaultGunModifiers(bladeProperties);
    }

    public static GunbladeMode getMode(ItemStack stack) {
        return GunbladeMode.from(stack);
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        return InteractionResultHolder.m_19090_((Object)flags);
    }

    @Override
    public void onServerReceiveKeyPress(ItemStack stack, ServerLevel level, Player player, byte flags) {
        Gun.GunState gunState = this.getGunState(stack);
        if (gunState == Gun.GunState.RELOADING) {
            this.cancelReload(stack, level, (LivingEntity)player);
        }
        GunbladeMode.set(stack, GunbladeMode.from(stack) == GunbladeMode.RANGED ? GunbladeMode.MELEE : GunbladeMode.RANGED);
        this.onChangeGunbladeMode(level, (LivingEntity)player, stack);
    }

    public void onChangeGunbladeMode(ServerLevel level, LivingEntity shooter, ItemStack stack) {
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (GunbladeMode.from(stack) == GunbladeMode.RANGED) {
            return this.useInRangedMode(level, player, usedHand, stack);
        }
        return this.useInMeleeMode(level, player, usedHand, stack);
    }

    public InteractionResultHolder<ItemStack> useInRangedMode(Level level, Player player, InteractionHand usedHand, ItemStack stack) {
        return super.m_7203_(level, player, usedHand);
    }

    public InteractionResultHolder<ItemStack> useInMeleeMode(Level level, Player player, InteractionHand usedHand, ItemStack stack) {
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    public void m_5929_(Level level, LivingEntity shooter, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.getGunState(stack) != Gun.GunState.SHOOTING) {
            return;
        }
        if (GunbladeMode.from(stack) != GunbladeMode.RANGED) {
            shooter.m_21253_();
            this.stopShooting(stack, serverLevel, shooter);
        } else {
            super.m_5929_(level, shooter, stack, remainingUseDuration);
        }
    }

    protected Multimap<Attribute, AttributeModifier> createDefaultBladeModifiers(BladeProperties bladeProperties) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)bladeProperties.attackDamageModifier(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)bladeProperties.attackSpeedModifier(), AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    protected Multimap<Attribute, AttributeModifier> createDefaultGunModifiers(BladeProperties bladeProperties) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Math.max((double)bladeProperties.attackDamageModifier() - 2.0, 0.5), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Math.max((double)bladeProperties.attackSpeedModifier() - 0.2, -3.8), AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return GunbladeMode.from(stack).isBlade() ? this.defaultBladeModifiers : this.defaultGunModifiers;
        }
        return ImmutableMultimap.of();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return GunbladeMode.from(stack).isBlade() && toolAction != ToolActions.SWORD_SWEEP && ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (GunbladeMode.from(stack).isGun()) {
            return 0.5f;
        }
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return state.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(2, attacker, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, miningEntity, livingEntity -> livingEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState state) {
        return state.m_60713_(Blocks.f_50033_);
    }

    public static enum GunbladeMode {
        MELEE,
        RANGED;

        static final String KEY = "biomancy:gunblade_mode";

        public static GunbladeMode from(ItemStack stack) {
            CompoundTag tag = stack.m_41737_(KEY);
            if (tag == null) {
                return MELEE;
            }
            return GunbladeMode.values()[tag.m_128445_("ordinal")];
        }

        public static void set(ItemStack stack, GunbladeMode mode) {
            CompoundTag tag = stack.m_41698_(KEY);
            tag.m_128344_("ordinal", (byte)mode.ordinal());
        }

        public boolean isBlade() {
            return this == MELEE;
        }

        public boolean isGun() {
            return this == RANGED;
        }
    }
}

