/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.weapon;

import com.github.elenterius.biomancy.api.livingtool.LivingToolState;
import com.github.elenterius.biomancy.client.render.item.ravenousclaws.RavenousClawsRenderer;
import com.github.elenterius.biomancy.client.util.ClientTextUtil;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.ItemAttackDamageSourceProvider;
import com.github.elenterius.biomancy.item.ItemCharge;
import com.github.elenterius.biomancy.item.weapon.LivingClawsItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.CombatUtil;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.MobUtil;
import com.github.elenterius.biomancy.util.SoundUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RavenousClawsItem
extends LivingClawsItem
implements GeoItem,
ItemCharge,
ItemAttackDamageSourceProvider {
    protected static final UUID BASE_ATTACK_KNOCKBACK_UUID = UUID.fromString("6175525b-56dd-4f87-b035-86b892afe7b3");
    private final Lazy<Multimap<Attribute, AttributeModifier>> brokenAttributes;
    private final Lazy<Multimap<Attribute, AttributeModifier>> dormantAttributes;
    private final Lazy<Multimap<Attribute, AttributeModifier>> awakenedAttributes;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RavenousClawsItem(Tier tier, float attackDamage, float attackSpeed, int maxNutrients, Item.Properties properties) {
        super(tier, 0.0f, 0.0f, 0.0f, maxNutrients, properties);
        float attackSpeedModifier = (float)((double)attackSpeed - Attributes.f_22283_.m_22082_());
        this.brokenAttributes = Lazy.of(() -> this.createDefaultAttributeModifiers(0.0f, 0.0f, -0.5f).build());
        this.dormantAttributes = Lazy.of(() -> this.createDefaultAttributeModifiers(-1.0f + attackDamage, attackSpeedModifier, 0.0f).build());
        this.awakenedAttributes = Lazy.of(() -> this.createDefaultAttributeModifiers(-1.0f + attackDamage + 2.5f, attackSpeedModifier, 0.5f).build());
    }

    private static void playClawSwipeFX(LivingEntity attacker) {
        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)ModSoundEvents.CLAWS_ATTACK_STRONG.get(), attacker.m_5720_(), 1.0f, 1.0f + attacker.m_217043_().m_188501_() * 0.5f);
        Level level = attacker.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double xOffset = -Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
            double zOffset = Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)));
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BLOODY_CLAWS_ATTACK.get()), attacker.m_20185_() + xOffset, attacker.m_20227_((double)0.52f), attacker.m_20189_() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
        }
    }

    private static void playBloodExplosionFX(LivingEntity target) {
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float w = target.m_20205_() * 0.45f;
            double x = serverLevel.m_213780_().m_188583_() * (double)w;
            double y = serverLevel.m_213780_().m_188583_() * 0.2;
            double z = serverLevel.m_213780_().m_188583_() * (double)w;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.FALLING_BLOOD.get()), target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), 20, x, y, z, 0.25);
        }
    }

    @Override
    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> createDefaultAttributeModifiers(float attackDamageModifier, float attackSpeedModifier, float attackRangeModifier) {
        ImmutableMultimap.Builder<Attribute, AttributeModifier> builder = super.createDefaultAttributeModifiers(attackDamageModifier, attackSpeedModifier, attackRangeModifier);
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(BASE_ATTACK_KNOCKBACK_UUID, "Weapon modifier", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return builder;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? (Multimap)this.dormantAttributes.get() : ImmutableMultimap.of();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return switch (this.getLivingToolState(stack)) {
                default -> throw new IncompatibleClassChangeError();
                case LivingToolState.BROKEN -> (Multimap)this.brokenAttributes.get();
                case LivingToolState.DORMANT -> (Multimap)this.dormantAttributes.get();
                case LivingToolState.AWAKENED -> (Multimap)this.awakenedAttributes.get();
            };
        }
        return ImmutableMultimap.of();
    }

    @Override
    public boolean hasNutrients(ItemStack container) {
        return this.getNutrients(container) > this.getLivingToolActionCost(container, LivingToolState.AWAKENED, null);
    }

    @Override
    public InteractionResultHolder<Byte> onClientKeyPress(ItemStack stack, Level level, Player player, EquipmentSlot slot, byte flags) {
        if (!this.hasCharge(stack)) {
            player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_blood_charge"), true);
            player.m_5496_((SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), 1.0f, 1.0f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            return InteractionResultHolder.m_19100_((Object)flags);
        }
        return InteractionResultHolder.m_19090_((Object)flags);
    }

    @Override
    public int getMaxCharge(ItemStack container) {
        return 50;
    }

    @Override
    public void onChargeChanged(ItemStack livingTool, int oldValue, int newValue) {
        if (newValue <= 0 && this.getLivingToolState(livingTool) == LivingToolState.AWAKENED) {
            this.setLivingToolState(livingTool, LivingToolState.DORMANT);
        }
    }

    @Override
    public void onNutrientsChanged(ItemStack livingTool, int oldValue, int newValue) {
        int maxCost;
        LivingToolState prevState;
        LivingToolState state = prevState = this.getLivingToolState(livingTool);
        if (newValue <= 0) {
            if (state != LivingToolState.BROKEN) {
                this.setLivingToolState(livingTool, LivingToolState.BROKEN);
            }
            return;
        }
        if (state == LivingToolState.BROKEN) {
            state = LivingToolState.DORMANT;
        }
        if (newValue < (maxCost = this.getLivingToolMaxActionCost(livingTool, state)) && state == LivingToolState.DORMANT) {
            state = LivingToolState.BROKEN;
        }
        if (state != prevState) {
            this.setLivingToolState(livingTool, state);
        }
    }

    @Override
    public void updateLivingToolState(ItemStack livingTool, ServerLevel level, Player player) {
        GeoItem.getOrAssignId((ItemStack)livingTool, (ServerLevel)level);
        LivingToolState state = this.getLivingToolState(livingTool);
        boolean hasNutrients = this.hasNutrients(livingTool);
        if (!hasNutrients) {
            if (state != LivingToolState.BROKEN) {
                this.setLivingToolState(livingTool, LivingToolState.BROKEN);
                SoundUtil.broadcastItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.FLESHKIN_BREAK.get());
            }
            return;
        }
        switch (state) {
            case BROKEN: 
            case AWAKENED: {
                this.setLivingToolState(livingTool, LivingToolState.DORMANT);
                SoundUtil.broadcastItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.FLESHKIN_BECOME_DORMANT.get());
                break;
            }
            case DORMANT: {
                if (!this.hasCharge(livingTool)) break;
                this.setLivingToolState(livingTool, LivingToolState.AWAKENED);
                SoundUtil.broadcastItemSound(level, (LivingEntity)player, (SoundEvent)ModSoundEvents.FLESHKIN_BECOME_AWAKENED.get());
            }
        }
    }

    @Override
    public boolean m_142207_(ItemStack livingTool, Slot slot, ClickAction action, Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)livingTool, (ServerLevel)serverLevel);
        }
        return super.m_142207_(livingTool, slot, action, player);
    }

    @Override
    public boolean m_142305_(ItemStack livingTool, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)livingTool, (ServerLevel)serverLevel);
        }
        return super.m_142305_(livingTool, other, slot, action, player, access);
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (toolAction == ToolActions.SWORD_SWEEP) {
            return false;
        }
        return super.canPerformAction(stack, toolAction);
    }

    @Override
    @Nullable
    public DamageSource getDamageSource(ItemStack stack, Entity target, LivingEntity attacker, float attackStrengthScale) {
        if (attackStrengthScale <= 0.9f) {
            return null;
        }
        return switch (this.getLivingToolState(stack)) {
            default -> throw new IncompatibleClassChangeError();
            case LivingToolState.BROKEN -> null;
            case LivingToolState.DORMANT, LivingToolState.AWAKENED -> ModDamageSources.slash(attacker.m_9236_(), (Entity)attacker);
        };
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Player player;
        if (attacker.m_9236_().f_46443_) {
            return true;
        }
        LivingToolState livingToolState = this.getLivingToolState(stack);
        boolean isFullAttackStrength = !(attacker instanceof Player) || (player = (Player)attacker).m_36403_(0.5f) >= 0.9f;
        boolean isNotCreativePlayer = !MobUtil.isCreativePlayer(attacker);
        switch (livingToolState) {
            case BROKEN: {
                break;
            }
            case DORMANT: {
                if (isNotCreativePlayer) {
                    this.consumeNutrients(stack, 1);
                }
                if (isFullAttackStrength) {
                    RavenousClawsItem.playClawSwipeFX(attacker);
                    if (attacker.m_217043_().m_188503_(12) == 0) {
                        attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)ModSoundEvents.CLAWS_ATTACK_BLEED_PROC.get(), attacker.m_5720_(), 1.0f, 1.0f);
                        CombatUtil.applyBleedEffect(target, 20);
                        if (isNotCreativePlayer) {
                            this.consumeNutrients(stack, 1);
                        }
                    }
                    target.f_19802_ = 0;
                }
                if (!target.m_21224_()) break;
                this.addCharge(stack, 5);
                break;
            }
            case AWAKENED: {
                if (isNotCreativePlayer) {
                    this.consumeCharge(stack, 1);
                }
                if (!isFullAttackStrength) break;
                RavenousClawsItem.playClawSwipeFX(attacker);
                if (attacker.m_217043_().m_188503_(5) == 0) {
                    attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), (SoundEvent)ModSoundEvents.CLAWS_ATTACK_BLEED_PROC.get(), attacker.m_5720_(), 1.0f, 1.0f);
                    if (CombatUtil.getBleedEffectLevel(target) < 2) {
                        RavenousClawsItem.playBloodExplosionFX(target);
                        CombatUtil.hurtWithBleed(target, 0.1f * target.m_21233_());
                        if (isNotCreativePlayer) {
                            this.consumeCharge(stack, 4);
                        }
                    }
                    CombatUtil.applyBleedEffect(target, 20);
                    if (isNotCreativePlayer) {
                        this.consumeCharge(stack, 1);
                    }
                }
                target.f_19802_ = 0;
            }
        }
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        tooltip.addAll(ClientTextUtil.getItemInfoTooltip(stack));
        tooltip.add(ComponentUtil.emptyLine());
        this.appendLivingToolTooltip(stack, tooltip);
        if (stack.m_41793_()) {
            tooltip.add(ComponentUtil.emptyLine());
        }
    }

    @Override
    public void appendLivingToolTooltip(ItemStack stack, List<Component> tooltip) {
        LivingToolState livingToolState = this.getLivingToolState(stack);
        switch (livingToolState) {
            case BROKEN: {
                break;
            }
            case DORMANT: {
                tooltip.add((Component)TextComponentUtil.getAbilityText("bleed_proc").m_130946_(" (8% chance)").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("bleed_proc.desc")).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add(ComponentUtil.emptyLine());
                break;
            }
            case AWAKENED: {
                tooltip.add((Component)TextComponentUtil.getAbilityText("bleed_proc").m_130946_(" (20% chance)").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("bleed_proc.desc")).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)TextComponentUtil.getAbilityText("blood_explosion").m_130946_(" (20% chance)").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("blood_explosion.desc")).m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add(ComponentUtil.emptyLine());
            }
        }
        DecimalFormat df = ClientTextUtil.getDecimalFormatter("#,###,###");
        tooltip.add((Component)TextComponentUtil.getTooltipText("nutrients_fuel").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" %s/%s".formatted(df.format(this.getNutrients(stack)), df.format(this.getMaxNutrients(stack)))).m_130948_(TextStyles.NUTRIENTS));
        tooltip.add((Component)TextComponentUtil.getTooltipText("blood_charge").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" %s/%s".formatted(df.format(this.getCharge(stack)), df.format(this.getMaxCharge(stack)))).m_130948_(TextStyles.ERROR));
        switch (livingToolState) {
            case BROKEN: {
                tooltip.add(ComponentUtil.emptyLine());
                tooltip.add((Component)livingToolState.getTooltip());
                break;
            }
            case DORMANT: {
                tooltip.add(ComponentUtil.emptyLine());
                tooltip.add((Component)livingToolState.getTooltip().m_130948_(TextStyles.ITALIC_GRAY));
                tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.enable_awakened_mode")));
                break;
            }
            case AWAKENED: {
                tooltip.add(ComponentUtil.emptyLine());
                tooltip.add((Component)livingToolState.getTooltip().m_130948_(TextStyles.ITALIC_GRAY));
                tooltip.add((Component)ClientTextUtil.pressButtonTo(ClientTextUtil.getDefaultKey(), TextComponentUtil.getTooltipText("action.disable_awakened_mode")));
            }
        }
    }

    @Override
    public int getLivingToolActionCost(ItemStack livingTool, LivingToolState state, ToolAction toolAction) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case LivingToolState.DORMANT, LivingToolState.AWAKENED -> 1;
            case LivingToolState.BROKEN -> 0;
        };
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final RavenousClawsRenderer renderer = new RavenousClawsRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    private PlayState handleAnimationState(AnimationState<RavenousClawsItem> animationState) {
        ItemStack stack = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        LivingToolState toolState = stack != null ? this.getLivingToolState(stack) : LivingToolState.BROKEN;
        AnimationController controller = animationState.getController();
        switch (toolState) {
            case DORMANT: {
                Animations.setDormant(controller);
                break;
            }
            case AWAKENED: {
                Animations.setAwakened(controller);
                break;
            }
            case BROKEN: {
                Animations.setBroken((AnimationController<RavenousClawsItem>)controller);
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 1, this::handleAnimationState)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static class Animations {
        public static final String MAIN_CONTROLLER = "main";
        protected static final RawAnimation DORMANT = RawAnimation.begin().thenLoop("ravenous_claws.dormant");
        protected static final RawAnimation TO_SLEEP_TRANSITION = RawAnimation.begin().thenPlay("ravenous_claws.tosleep").thenLoop("ravenous_claws.dormant");
        protected static final RawAnimation BROKEN = RawAnimation.begin().thenLoop("ravenous_claws.broken");
        protected static final RawAnimation WAKEUP_TRANSITION = RawAnimation.begin().thenPlay("ravenous_claws.wakeup").thenLoop("ravenous_claws.awakened");
        protected static final RawAnimation AWAKENED = RawAnimation.begin().thenLoop("ravenous_claws.awakened");

        private Animations() {
        }

        protected static void setDormant(AnimationController<?> controller) {
            AnimationProcessor.QueuedAnimation queued = controller.getCurrentAnimation();
            if (queued == null) {
                controller.setAnimation(DORMANT);
                return;
            }
            if (!queued.animation().name().equals("ravenous_claws.dormant")) {
                controller.setAnimation(TO_SLEEP_TRANSITION);
                return;
            }
            controller.setAnimation(DORMANT);
        }

        protected static void setAwakened(AnimationController<?> controller) {
            AnimationProcessor.QueuedAnimation queued = controller.getCurrentAnimation();
            if (queued == null) {
                controller.setAnimation(AWAKENED);
                return;
            }
            if (!queued.animation().name().equals("ravenous_claws.awakened")) {
                controller.setAnimation(WAKEUP_TRANSITION);
                return;
            }
            controller.setAnimation(AWAKENED);
        }

        public static void setBroken(AnimationController<RavenousClawsItem> controller) {
            controller.setAnimation(BROKEN);
        }
    }
}

