/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.shield;

import com.github.elenterius.biomancy.client.render.item.shield.ThornShieldRenderer;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.ShieldBlockingListener;
import com.github.elenterius.biomancy.item.shield.LivingShieldItem;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ThornShieldItem
extends LivingShieldItem
implements Equipable,
ShieldBlockingListener,
GeoItem {
    public static final String BLOCKING_TAG_KEY = "blocking";
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ThornShieldItem(int maxNutrients, Item.Properties properties) {
        super(maxNutrients, properties);
    }

    @Override
    public void appendLivingToolTooltip(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)TextComponentUtil.getAbilityText("thorny_hide").m_130948_(TextStyles.GRAY));
        tooltip.add((Component)ComponentUtil.literal(" ").m_7220_((Component)TextComponentUtil.getAbilityText("thorny_hide.desc")).m_130948_(TextStyles.DARK_GRAY));
        super.appendLivingToolTooltip(stack, tooltip);
    }

    @Override
    public void onShieldBlocking(ItemStack shield, LivingEntity user, LivingEntity attacker) {
        attacker.m_6469_(user.m_269291_().m_269374_((Entity)user), 1.5f + (float)user.m_217043_().m_188503_(4));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.hasNutrients(stack)) {
            if (level.m_5776_()) {
                player.m_5661_((Component)TextComponentUtil.getFailureMsgText("not_enough_nutrients"), true);
                player.m_5496_((SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), 0.8f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (player.m_6117_() && player.m_21211_() == stack) {
                GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
                stack.m_41784_().m_128379_(BLOCKING_TAG_KEY, true);
            }
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void onStopUsing(ItemStack stack, LivingEntity livingEntity, int timeUsed) {
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
            stack.m_41784_().m_128379_(BLOCKING_TAG_KEY, false);
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        boolean isBlocking;
        LivingEntity livingEntity;
        if (!isSelected) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21211_() != stack && (isBlocking = stack.m_41784_().m_128471_(BLOCKING_TAG_KEY))) {
            GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)level));
            stack.m_41784_().m_128379_(BLOCKING_TAG_KEY, false);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final ThornShieldRenderer renderer = new ThornShieldRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "main", state -> {
            ItemStack stack = (ItemStack)state.getData(DataTickets.ITEMSTACK);
            boolean isBlocking = stack.m_41784_().m_128471_(BLOCKING_TAG_KEY);
            if (isBlocking) {
                return state.setAndContinue(Animations.TRANSITION_TO_EXTENDED);
            }
            if (!state.isCurrentAnimationStage("retracted")) {
                return state.setAndContinue(Animations.TRANSITION_TO_RETRACTED);
            }
            return state.setAndContinue(Animations.RETRACTED);
        });
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected static final class Animations {
        public static final RawAnimation RETRACTED = RawAnimation.begin().thenPlay("retracted");
        public static final RawAnimation TRANSITION_TO_RETRACTED = RawAnimation.begin().thenPlay("retract").thenPlay("retracted");
        public static final RawAnimation TRANSITION_TO_EXTENDED = RawAnimation.begin().thenPlay("extend").thenPlay("extended");

        private Animations() {
        }
    }
}

