/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item.injector;

import com.github.elenterius.biomancy.api.serum.Serum;
import com.github.elenterius.biomancy.init.ModEnchantments;
import com.github.elenterius.biomancy.item.armor.AcolyteArmorItem;
import com.github.elenterius.biomancy.item.injector.InjectorItem;
import com.github.elenterius.biomancy.util.CombatUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

final class InjectionScheduler {
    public static final String DELAY_KEY = "DelayInTicks";
    public static final String TIMESTAMP_KEY = "ScheduleTimestamp";

    private InjectionScheduler() {
    }

    public static void schedule(InjectorItem injector, ItemStack stack, Player player, LivingEntity target, int delayInTicks) {
        if (stack.m_41619_() || player.m_9236_().f_46443_ || injector.getSerum(stack).isEmpty()) {
            return;
        }
        injector.setEntityHost(stack, (Entity)player);
        injector.setEntityVictim(stack, (Entity)target);
        injector.setInjectionSuccess(stack, CombatUtil.canPierceThroughArmor(stack, target, (LivingEntity)player));
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(DELAY_KEY, delayInTicks);
        tag.m_128356_(TIMESTAMP_KEY, player.m_9236_().m_46467_());
    }

    public static void tick(ServerLevel level, InjectorItem injector, ItemStack stack, ServerPlayer player) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TIMESTAMP_KEY)) {
            return;
        }
        long delayInTicks = tag.m_128454_(DELAY_KEY);
        long starTimestamp = tag.m_128454_(TIMESTAMP_KEY);
        if (player.m_9236_().m_46467_() - starTimestamp > delayInTicks) {
            InjectionScheduler.performScheduledSerumInjection(level, injector, stack, player);
            tag.m_128473_(DELAY_KEY);
            tag.m_128473_(TIMESTAMP_KEY);
        }
    }

    public static void performScheduledSerumInjection(ServerLevel level, InjectorItem injector, ItemStack stack, ServerPlayer player) {
        Serum serum = injector.getSerum(stack);
        if (serum.isEmpty()) {
            return;
        }
        Entity victim = injector.getEntityVictim(stack, (Level)level);
        Entity host = injector.getEntityHost(stack, (Level)level);
        boolean injectionSuccess = injector.getInjectionSuccess(stack);
        if (victim instanceof LivingEntity) {
            float damage;
            LivingEntity target = (LivingEntity)victim;
            if (!injectionSuccess) {
                stack.m_41622_(2, (LivingEntity)player, p -> {});
                player.m_21166_(EquipmentSlot.MAINHAND);
                injector.broadcastAnimation(level, (Player)player, stack, InjectorItem.InjectorAnimation.REGROW_NEEDLE);
                player.m_36335_().m_41524_(stack.m_41720_(), 50);
                return;
            }
            float damagePct = 1.0f;
            for (ItemStack itemStack : target.m_6168_()) {
                AcolyteArmorItem armor;
                Item item = itemStack.m_41720_();
                if (!(item instanceof AcolyteArmorItem) || !(armor = (AcolyteArmorItem)item).hasNutrients(itemStack)) continue;
                damagePct -= 0.25f;
            }
            if (stack.getEnchantmentLevel((Enchantment)ModEnchantments.ANESTHETIC.get()) <= 0 && (damage = 0.5f * damagePct) > 0.0f) {
                target.m_6469_(level.m_269111_().m_269396_((LivingEntity)player), damage);
            }
            if (host == victim) {
                serum.affectPlayerSelf(Serum.getDataTag(stack), player);
            } else {
                serum.affectEntity(level, Serum.getDataTag(stack), (LivingEntity)player, target);
            }
            injector.consumeSerum(stack, (Player)player);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        }
    }
}

