/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.item;

import com.github.elenterius.biomancy.item.SimpleItem;
import com.github.elenterius.biomancy.mixin.accessor.CreeperAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class UnstableCompoundItem
extends SimpleItem {
    public UnstableCompoundItem(Item.Properties properties) {
        super(properties);
    }

    public static void explode(ItemEntity itemEntity, boolean isBurning) {
        if (itemEntity.m_9236_().f_46443_) {
            return;
        }
        if (itemEntity.f_19789_ <= 1.0f) {
            return;
        }
        float explosionRadius = 0.5f + (float)itemEntity.m_32055_().m_41613_() / 64.0f * 1.5f;
        float multiplier = isBurning ? 2.0f : 1.0f;
        UnstableExplosion.explode(itemEntity.m_9236_(), (Entity)itemEntity, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), explosionRadius * multiplier, Level.ExplosionInteraction.TNT);
        itemEntity.m_146870_();
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
        super.onDestroyed(itemEntity, damageSource);
        if (damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            UnstableCompoundItem.explode(itemEntity, true);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos = context.m_8083_());
        Block block = state.m_60734_();
        if (block instanceof TntBlock) {
            TntBlock tnt = (TntBlock)block;
            if (!level.f_46443_) {
                context.m_43722_().m_41774_(1);
                tnt.onCaughtFire(state, level, pos, context.m_43719_(), (LivingEntity)context.m_43723_());
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (block instanceof MagmaBlock) {
            if (!level.f_46443_) {
                context.m_43722_().m_41774_(1);
                level.m_7731_(pos, Blocks.f_49991_.m_49966_(), 11);
            }
            level.m_5594_(context.m_43723_(), pos, SoundEvents.f_11913_, SoundSource.BLOCKS, 2.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        if (target instanceof Creeper) {
            Creeper creeper = (Creeper)target;
            if (!player.m_9236_().f_46443_) {
                stack.m_41774_(1);
            }
            ((CreeperAccessor)creeper).biomancy$explodeCreeper();
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static class UnstableExplosion
    extends Explosion {
        public UnstableExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction) {
            super(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction);
        }

        public static void explode(Level level, @Nullable Entity source, double x, double y, double z, float radius, Level.ExplosionInteraction explosionInteraction) {
            UnstableExplosion.explode(level, source, null, null, x, y, z, radius, true, explosionInteraction, true);
        }

        public static void explode(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean spawnParticles) {
            Explosion.BlockInteraction blockInteraction = switch (explosionInteraction) {
                default -> throw new IncompatibleClassChangeError();
                case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
                case Level.ExplosionInteraction.BLOCK -> UnstableExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254629_);
                case Level.ExplosionInteraction.MOB -> {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)source)) {
                        yield UnstableExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254692_);
                    }
                    yield Explosion.BlockInteraction.KEEP;
                }
                case Level.ExplosionInteraction.TNT -> UnstableExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254705_);
            };
            UnstableExplosion explosion = new UnstableExplosion(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction);
            if (ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
                return;
            }
            explosion.m_46061_();
            explosion.m_46075_(spawnParticles);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UnstableExplosion.sendToClients(serverLevel, x, y, z, radius, explosion);
            }
        }

        private static void sendToClients(ServerLevel level, double x, double y, double z, float radius, UnstableExplosion explosion) {
            if (!explosion.m_254884_()) {
                explosion.m_46080_();
            }
            for (ServerPlayer player : level.m_6907_()) {
                if (!(player.m_20275_(x, y, z) < 4096.0)) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
            }
        }

        private static Explosion.BlockInteraction getDestroyType(Level level, GameRules.Key<GameRules.BooleanValue> gameRule) {
            return level.m_46469_().m_46207_(gameRule) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
        }
    }
}

