/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.inventory.BehavioralItemHandler;
import com.github.elenterius.biomancy.inventory.SerializableItemHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public final class InventoryHandler<T extends SerializableItemHandler>
implements SerializableItemHandler {
    private final T itemHandler;
    private LazyOptional<IItemHandler> optionalItemHandler;
    private final RecipeWrapper recipeWrapper;

    public InventoryHandler(T itemHandler) {
        this.itemHandler = itemHandler;
        this.recipeWrapper = new RecipeWrapper(itemHandler);
        this.optionalItemHandler = LazyOptional.of(() -> itemHandler);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag serializeNBT() {
        return (CompoundTag)this.itemHandler.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemHandler.deserializeNBT((Tag)nbt);
    }

    public T get() {
        return this.itemHandler;
    }

    public IItemHandler getRaw() {
        Object object;
        T t = this.itemHandler;
        if (t instanceof BehavioralItemHandler) {
            BehavioralItemHandler handler = (BehavioralItemHandler)t;
            object = handler.withoutBehavior();
        } else {
            object = this.itemHandler;
        }
        return object;
    }

    public LazyOptional<IItemHandler> getLazyOptional() {
        return this.optionalItemHandler;
    }

    public RecipeWrapper getRecipeWrapper() {
        return this.recipeWrapper;
    }

    public void invalidate() {
        this.optionalItemHandler.invalidate();
    }

    public void revive() {
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.itemHandler.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.itemHandler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }
}

