/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.inventory;

import com.github.elenterius.biomancy.api.serum.SerumContainer;
import com.github.elenterius.biomancy.inventory.LargeSingleItemStackHandler;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class InjectorItemInventory {
    private final ItemStack cachedInventoryHost;
    private final LargeSingleItemStackHandler itemHandler;
    private final LazyOptional<IItemHandler> optionalItemHandler;

    private InjectorItemInventory(short maxSlotSize, ItemStack inventoryHost) {
        this.itemHandler = new LargeSingleItemStackHandler(maxSlotSize){

            @Override
            public boolean isItemValid(ItemStack stack) {
                return stack.m_41720_() instanceof SerumContainer;
            }

            @Override
            protected void onContentsChanged() {
                InjectorItemInventory.this.serializeToHost();
            }
        };
        this.optionalItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.cachedInventoryHost = inventoryHost;
    }

    public static InjectorItemInventory create(short maxSlotSize, ItemStack inventoryHost) {
        InjectorItemInventory inventory = new InjectorItemInventory(maxSlotSize, inventoryHost);
        inventory.deserializeFromHost();
        return inventory;
    }

    private void serializeToHost() {
        this.cachedInventoryHost.m_41784_().m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    private void deserializeFromHost() {
        this.itemHandler.deserializeNBT(this.cachedInventoryHost.m_41784_().m_128469_("inventory"));
    }

    public boolean stillValid() {
        return !this.cachedInventoryHost.m_41619_();
    }

    public LargeSingleItemStackHandler getItemHandler() {
        this.deserializeFromHost();
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getLazyOptional() {
        this.deserializeFromHost();
        return this.optionalItemHandler;
    }
}

