/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.integration.jei;

import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.FoodDigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.StaticDigestingRecipe;
import com.github.elenterius.biomancy.init.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public final class DigestingRecipes {
    private DigestingRecipes() {
    }

    public static List<DigestingRecipe> getRecipes(ClientLevel level) {
        List allRecipes = level.m_7465_().m_44013_((RecipeType)ModRecipes.DIGESTING_RECIPE_TYPE.get());
        ArrayList<DigestingRecipe> resolvedRecipes = new ArrayList<DigestingRecipe>();
        for (DigestingRecipe recipe : allRecipes) {
            if (recipe instanceof FoodDigestingRecipe) {
                FoodDigestingRecipe dynamicRecipe = (FoodDigestingRecipe)recipe;
                List<DigestingRecipe> staticRecipes = DigestingRecipes.convertToStaticRecipes(level, dynamicRecipe);
                resolvedRecipes.addAll(staticRecipes);
                continue;
            }
            resolvedRecipes.add(recipe);
        }
        return resolvedRecipes;
    }

    private static List<DigestingRecipe> convertToStaticRecipes(ClientLevel level, FoodDigestingRecipe dynamicRecipe) {
        ArrayList<DigestingRecipe> staticRecipes = new ArrayList<DigestingRecipe>();
        RecipeWrapper inputInventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        for (ItemStack ingredientItem : dynamicRecipe.getIngredient().m_43908_()) {
            inputInventory.m_6836_(0, ingredientItem);
            ItemStack result = dynamicRecipe.m_5874_((Container)inputInventory, level.m_9598_());
            int craftingTimeTicks = dynamicRecipe.getCraftingTimeTicks((Container)inputInventory);
            int craftingCostNutrients = dynamicRecipe.getCraftingCostNutrients((Container)inputInventory);
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredientItem});
            String suffix = ForgeRegistries.ITEMS.getKey((Object)ingredientItem.m_41720_()).m_214298_();
            StaticDigestingRecipe recipe = new StaticDigestingRecipe(dynamicRecipe.m_6423_().m_266382_("_jei_" + suffix), result, craftingTimeTicks, craftingCostNutrients, ingredient);
            staticRecipes.add(recipe);
        }
        return staticRecipes;
    }
}

