/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.block.DirectionalPillarSlabBlock;
import com.github.elenterius.biomancy.block.DirectionalSlabBlock;
import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.FleshChainBlock;
import com.github.elenterius.biomancy.block.FleshDoorBlock;
import com.github.elenterius.biomancy.block.FleshFenceBlock;
import com.github.elenterius.biomancy.block.FleshFenceGateBlock;
import com.github.elenterius.biomancy.block.FleshLanternBlock;
import com.github.elenterius.biomancy.block.FullFleshDoorBlock;
import com.github.elenterius.biomancy.block.IrisDoorBlock;
import com.github.elenterius.biomancy.block.bioforge.BioForgeBlock;
import com.github.elenterius.biomancy.block.biolab.BioLabBlock;
import com.github.elenterius.biomancy.block.bloom.BloomBlock;
import com.github.elenterius.biomancy.block.cauldron.AcidCauldron;
import com.github.elenterius.biomancy.block.chrysalis.ChrysalisBlock;
import com.github.elenterius.biomancy.block.cradle.PrimordialCradleBlock;
import com.github.elenterius.biomancy.block.decomposer.DecomposerBlock;
import com.github.elenterius.biomancy.block.digester.DigesterBlock;
import com.github.elenterius.biomancy.block.fleshkinchest.FleshkinChestBlock;
import com.github.elenterius.biomancy.block.fleshspike.FleshSpikeBlock;
import com.github.elenterius.biomancy.block.mawhopper.MawHopperBlock;
import com.github.elenterius.biomancy.block.membrane.BiometricMembraneBlock;
import com.github.elenterius.biomancy.block.membrane.IgnoreEntityCollisionPredicate;
import com.github.elenterius.biomancy.block.membrane.MembraneBlock;
import com.github.elenterius.biomancy.block.membrane.MembranePaneBlock;
import com.github.elenterius.biomancy.block.membrane.SpreadingMembraneBlock;
import com.github.elenterius.biomancy.block.modularlarynx.ModularLarynxBlock;
import com.github.elenterius.biomancy.block.orifice.OrificeBlock;
import com.github.elenterius.biomancy.block.ownable.OwnablePressurePlateBlock;
import com.github.elenterius.biomancy.block.storagesac.StorageSacBlock;
import com.github.elenterius.biomancy.block.tongue.TongueBlock;
import com.github.elenterius.biomancy.block.veins.FleshVeinsBlock;
import com.github.elenterius.biomancy.block.vialholder.VialHolderBlock;
import com.github.elenterius.biomancy.init.ModBlockSetTypes;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModPlantTypes;
import com.github.elenterius.biomancy.init.ModSoundTypes;
import com.github.elenterius.biomancy.init.tags.ModEntityTags;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class ModBlocks {
    private static final float FLESH_DESTROY_SPEED = 3.0f;
    private static final float FLESH_EXPLOSION_RESISTANCE = 3.0f;
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"biomancy");
    public static final RegistryObject<PrimordialCradleBlock> PRIMORDIAL_CRADLE = ModBlocks.register("primordial_cradle", PrimordialCradleBlock::new);
    public static final RegistryObject<BioForgeBlock> BIO_FORGE = ModBlocks.register("bio_forge", BioForgeBlock::new);
    public static final RegistryObject<DecomposerBlock> DECOMPOSER = ModBlocks.register("decomposer", (BlockBehaviour.Properties properties) -> new DecomposerBlock(properties.m_60955_()));
    public static final RegistryObject<BioLabBlock> BIO_LAB = ModBlocks.register("bio_lab", BioLabBlock::new);
    public static final RegistryObject<DigesterBlock> DIGESTER = ModBlocks.register("digester", DigesterBlock::new);
    public static final RegistryObject<StorageSacBlock> STORAGE_SAC = ModBlocks.register("storage_sac", StorageSacBlock::new);
    public static final RegistryObject<TongueBlock> TONGUE = ModBlocks.register("tongue", TongueBlock::new);
    public static final RegistryObject<MawHopperBlock> MAW_HOPPER = ModBlocks.register("maw_hopper", MawHopperBlock::new);
    public static final RegistryObject<FleshkinChestBlock> FLESHKIN_CHEST = ModBlocks.register("fleshkin_chest", (BlockBehaviour.Properties properties) -> new FleshkinChestBlock((BlockBehaviour.Properties)properties, 3.0f));
    public static final RegistryObject<OwnablePressurePlateBlock> FLESHKIN_PRESSURE_PLATE = ModBlocks.register("fleshkin_pressure_plate", (BlockBehaviour.Properties properties) -> new OwnablePressurePlateBlock((BlockBehaviour.Properties)properties, ModBlockSetTypes.FLESH_SET_TYPE.get()));
    public static final RegistryObject<ChrysalisBlock> CHRYSALIS = ModBlocks.register("chrysalis", ChrysalisBlock::new);
    public static final RegistryObject<FleshBlock> FLESH = ModBlocks.register("flesh", FleshBlock::new);
    public static final RegistryObject<StairBlock> FLESH_STAIRS = ModBlocks.registerStairs(FLESH, StairBlock::new);
    public static final RegistryObject<WallBlock> FLESH_WALL = ModBlocks.registerWall(FLESH, WallBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> FLESH_SLAB = ModBlocks.registerSlab(FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<FleshBlock> PACKED_FLESH = ModBlocks.register("packed_flesh", () -> new FleshBlock(ModBlocks.createToughFleshProperties()));
    public static final RegistryObject<StairBlock> PACKED_FLESH_STAIRS = ModBlocks.registerStairs(PACKED_FLESH, StairBlock::new);
    public static final RegistryObject<WallBlock> PACKED_FLESH_WALL = ModBlocks.registerWall(PACKED_FLESH, WallBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> PACKED_FLESH_SLAB = ModBlocks.registerSlab(PACKED_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<FleshBlock> FIBROUS_FLESH = ModBlocks.register("fibrous_flesh", FleshBlock::new);
    public static final RegistryObject<StairBlock> FIBROUS_FLESH_STAIRS = ModBlocks.registerStairs(FIBROUS_FLESH, StairBlock::new);
    public static final RegistryObject<WallBlock> FIBROUS_FLESH_WALL = ModBlocks.registerWall(FIBROUS_FLESH, WallBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> FIBROUS_FLESH_SLAB = ModBlocks.registerSlab(FIBROUS_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<RotatedPillarBlock> TUBULAR_FLESH_BLOCK = ModBlocks.register("tubular_flesh", RotatedPillarBlock::new);
    public static final RegistryObject<RotatedPillarBlock> FLESH_PILLAR = ModBlocks.register("flesh_pillar", () -> new RotatedPillarBlock(ModBlocks.createBonyFleshProperties()));
    public static final RegistryObject<FleshBlock> CHISELED_FLESH = ModBlocks.register("chiseled_flesh", () -> new FleshBlock(ModBlocks.createBonyFleshProperties()));
    public static final RegistryObject<RotatedPillarBlock> ORNATE_FLESH = ModBlocks.register("ornate_flesh", () -> new RotatedPillarBlock(ModBlocks.createBonyFleshProperties()));
    public static final RegistryObject<DirectionalPillarSlabBlock> ORNATE_FLESH_SLAB = ModBlocks.registerSlab(ORNATE_FLESH, DirectionalPillarSlabBlock::new);
    public static final RegistryObject<FleshBlock> PRIMAL_FLESH = ModBlocks.register("primal_flesh", (BlockBehaviour.Properties properties) -> new FleshBlock((BlockBehaviour.Properties)properties, ModPlantTypes.PRIMAL_FLESH));
    public static final RegistryObject<StairBlock> PRIMAL_FLESH_STAIRS = ModBlocks.registerStairs(PRIMAL_FLESH, StairBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> PRIMAL_FLESH_SLAB = ModBlocks.registerSlab(PRIMAL_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<WallBlock> PRIMAL_FLESH_WALL = ModBlocks.registerWall(PRIMAL_FLESH, WallBlock::new);
    public static final RegistryObject<FleshBlock> SMOOTH_PRIMAL_FLESH = ModBlocks.register("smooth_primal_flesh", (BlockBehaviour.Properties properties) -> new FleshBlock((BlockBehaviour.Properties)properties, ModPlantTypes.PRIMAL_FLESH));
    public static final RegistryObject<StairBlock> SMOOTH_PRIMAL_FLESH_STAIRS = ModBlocks.registerStairs(SMOOTH_PRIMAL_FLESH, StairBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> SMOOTH_PRIMAL_FLESH_SLAB = ModBlocks.registerSlab(SMOOTH_PRIMAL_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<WallBlock> SMOOTH_PRIMAL_FLESH_WALL = ModBlocks.registerWall(SMOOTH_PRIMAL_FLESH, WallBlock::new);
    public static final RegistryObject<FleshBlock> POROUS_PRIMAL_FLESH = ModBlocks.register("porous_primal_flesh", (BlockBehaviour.Properties properties) -> new FleshBlock((BlockBehaviour.Properties)properties, ModPlantTypes.PRIMAL_FLESH));
    public static final RegistryObject<StairBlock> POROUS_PRIMAL_FLESH_STAIRS = ModBlocks.registerStairs(POROUS_PRIMAL_FLESH, StairBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> POROUS_PRIMAL_FLESH_SLAB = ModBlocks.registerSlab(POROUS_PRIMAL_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<WallBlock> POROUS_PRIMAL_FLESH_WALL = ModBlocks.registerWall(POROUS_PRIMAL_FLESH, WallBlock::new);
    public static final RegistryObject<FleshBlock> MALIGNANT_FLESH = ModBlocks.register("malignant_flesh", (BlockBehaviour.Properties properties) -> new FleshBlock((BlockBehaviour.Properties)properties, ModPlantTypes.PRIMAL_FLESH));
    public static final RegistryObject<StairBlock> MALIGNANT_FLESH_STAIRS = ModBlocks.registerStairs(MALIGNANT_FLESH, StairBlock::new);
    public static final RegistryObject<DirectionalSlabBlock> MALIGNANT_FLESH_SLAB = ModBlocks.registerSlab(MALIGNANT_FLESH, DirectionalSlabBlock::new);
    public static final RegistryObject<WallBlock> MALIGNANT_FLESH_WALL = ModBlocks.registerWall(MALIGNANT_FLESH, WallBlock::new);
    public static final RegistryObject<FleshVeinsBlock> MALIGNANT_FLESH_VEINS = ModBlocks.register("malignant_flesh_veins", () -> new FleshVeinsBlock(ModBlocks.createFleshVeinsProperties().m_60910_().m_60955_()));
    public static final RegistryObject<BloomBlock> PRIMAL_BLOOM = ModBlocks.register("primal_bloom", (BlockBehaviour.Properties properties) -> new BloomBlock(properties.m_60977_().m_60955_().m_60953_(BloomBlock::getLightEmission)));
    public static final RegistryObject<Block> BLOOMLIGHT = ModBlocks.register("bloomlight", (BlockBehaviour.Properties properties) -> new Block(properties.m_60918_(SoundType.f_56713_).m_60953_(x -> 15)));
    public static final RegistryObject<OrificeBlock> PRIMAL_ORIFICE = ModBlocks.register("primal_orifice", (BlockBehaviour.Properties properties) -> new OrificeBlock(properties.m_60977_()));
    public static final RegistryObject<ModularLarynxBlock> MODULAR_LARYNX = ModBlocks.register("modular_larynx", ModularLarynxBlock::new);
    public static final RegistryObject<FleshSpikeBlock> FLESH_SPIKE = ModBlocks.register("flesh_spike", () -> new FleshSpikeBlock(ModBlocks.createBonyFleshProperties().m_60955_()));
    public static final RegistryObject<VialHolderBlock> VIAL_HOLDER = ModBlocks.register("vial_holder", VialHolderBlock::new);
    public static final RegistryObject<MembraneBlock> IMPERMEABLE_MEMBRANE = ModBlocks.registerMembrane("impermeable_membrane", IgnoreEntityCollisionPredicate.NEVER);
    public static final RegistryObject<MembranePaneBlock> IMPERMEABLE_MEMBRANE_PANE = ModBlocks.registerMembranePane("impermeable_membrane_pane", IgnoreEntityCollisionPredicate.NEVER);
    public static final RegistryObject<MembraneBlock> BABY_PERMEABLE_MEMBRANE = ModBlocks.registerMembrane("baby_permeable_membrane", IgnoreEntityCollisionPredicate.IS_BABY_MOB);
    public static final RegistryObject<MembranePaneBlock> BABY_PERMEABLE_MEMBRANE_PANE = ModBlocks.registerMembranePane("baby_permeable_membrane_pane", IgnoreEntityCollisionPredicate.IS_BABY_MOB);
    public static final RegistryObject<MembraneBlock> ADULT_PERMEABLE_MEMBRANE = ModBlocks.registerMembrane("adult_permeable_membrane", IgnoreEntityCollisionPredicate.IS_ADULT_MOB);
    public static final RegistryObject<MembranePaneBlock> ADULT_PERMEABLE_MEMBRANE_PANE = ModBlocks.registerMembranePane("adult_permeable_membrane_pane", IgnoreEntityCollisionPredicate.IS_ADULT_MOB);
    public static final RegistryObject<MembraneBlock> PRIMAL_PERMEABLE_MEMBRANE = ModBlocks.registerMembrane("primal_permeable_membrane", IgnoreEntityCollisionPredicate.IS_ALIVE_MOB, SpreadingMembraneBlock::new);
    public static final RegistryObject<MembranePaneBlock> PRIMAL_PERMEABLE_MEMBRANE_PANE = ModBlocks.registerMembranePane("primal_permeable_membrane_pane", IgnoreEntityCollisionPredicate.IS_ALIVE_MOB);
    public static final RegistryObject<MembraneBlock> UNDEAD_PERMEABLE_MEMBRANE = ModBlocks.registerMembrane("undead_permeable_membrane", IgnoreEntityCollisionPredicate.IS_UNDEAD_MOB);
    public static final RegistryObject<MembranePaneBlock> UNDEAD_PERMEABLE_MEMBRANE_PANE = ModBlocks.registerMembranePane("undead_permeable_membrane_pane", IgnoreEntityCollisionPredicate.IS_UNDEAD_MOB);
    public static final RegistryObject<BiometricMembraneBlock> BIOMETRIC_MEMBRANE = ModBlocks.registerMembrane("biometric_membrane", BiometricMembraneBlock::new);
    public static final RegistryObject<FleshLanternBlock> PRIMORDIAL_BIO_LANTERN = ModBlocks.register("primordial_bio_lantern", (BlockBehaviour.Properties properties) -> new FleshLanternBlock(properties.m_60918_(SoundType.f_56713_).m_60953_(x -> 15).m_60955_()));
    public static final RegistryObject<FleshLanternBlock> YELLOW_BIO_LANTERN = ModBlocks.register("bio_lantern_yellow", (BlockBehaviour.Properties properties) -> new FleshLanternBlock(properties.m_60918_(SoundType.f_56713_).m_60953_(x -> 15).m_60955_()));
    public static final RegistryObject<FleshLanternBlock> BLUE_BIO_LANTERN = ModBlocks.register("bio_lantern_blue", (BlockBehaviour.Properties properties) -> new FleshLanternBlock(properties.m_60918_(SoundType.f_56713_).m_60953_(x -> 15).m_60955_()));
    public static final RegistryObject<LiquidBlock> ACID_FLUID_BLOCK = ModBlocks.register("acid_fluid_block", () -> new LiquidBlock(ModFluids.ACID, ModBlocks.copyProperties((BlockBehaviour)Blocks.f_49990_)));
    public static final RegistryObject<LadderBlock> FLESH_LADDER = ModBlocks.register("flesh_ladder", () -> new LadderBlock(ModBlocks.createBonyFleshProperties().m_60955_()));
    public static final RegistryObject<FleshFenceBlock> FLESH_FENCE = ModBlocks.register("flesh_fence", FleshFenceBlock::new);
    public static final RegistryObject<FleshFenceGateBlock> FLESH_FENCE_GATE = ModBlocks.register("flesh_fence_gate", () -> new FleshFenceGateBlock(ModBlocks.createBonyFleshProperties().m_60955_()));
    public static final RegistryObject<IrisDoorBlock> FLESH_IRIS_DOOR = ModBlocks.register("flesh_iris_door", IrisDoorBlock::new);
    public static final RegistryObject<FleshDoorBlock> FLESH_DOOR = ModBlocks.register("flesh_door", FleshDoorBlock::new);
    public static final RegistryObject<FullFleshDoorBlock> FULL_FLESH_DOOR = ModBlocks.register("full_flesh_door", FullFleshDoorBlock::new);
    public static final RegistryObject<FleshChainBlock> TENDON_CHAIN = ModBlocks.register("tendon_chain", (BlockBehaviour.Properties properties) -> new FleshChainBlock(properties.m_60955_()));
    public static final RegistryObject<AcidCauldron> ACID_CAULDRON = ModBlocks.register("acid_cauldron", () -> new AcidCauldron(ModBlocks.copyProperties((BlockBehaviour)Blocks.f_50256_)));

    private ModBlocks() {
    }

    private static <T extends Block> RegistryObject<T> register(String name, Function<BlockBehaviour.Properties, T> factory) {
        return BLOCKS.register(name, () -> (Block)factory.apply(ModBlocks.createFleshProperties()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> factory) {
        return BLOCKS.register(name, factory);
    }

    private static <T extends StairBlock> RegistryObject<T> registerStairs(RegistryObject<? extends Block> parent, StairBlockFactory<T> factory) {
        return ModBlocks.registerStairs(parent.getId().m_135815_() + "_stairs", parent, factory);
    }

    private static <T extends StairBlock> RegistryObject<T> registerStairs(String name, RegistryObject<? extends Block> parent, StairBlockFactory<T> factory) {
        return BLOCKS.register(name, () -> factory.create(() -> ((Block)parent.get()).m_49966_(), ModBlocks.copyProperties((BlockBehaviour)parent.get())));
    }

    private static <T extends WallBlock> RegistryObject<T> registerWall(RegistryObject<? extends Block> parent, Function<BlockBehaviour.Properties, T> factory) {
        return ModBlocks.registerWall(parent.getId().m_135815_() + "_wall", parent, factory);
    }

    private static <T extends WallBlock> RegistryObject<T> registerWall(String name, RegistryObject<? extends Block> parent, Function<BlockBehaviour.Properties, T> factory) {
        return BLOCKS.register(name, () -> (WallBlock)factory.apply(ModBlocks.copyProperties((BlockBehaviour)parent.get())));
    }

    private static <T extends DirectionalSlabBlock> RegistryObject<T> registerSlab(RegistryObject<? extends Block> parent, Function<BlockBehaviour.Properties, T> factory) {
        return ModBlocks.registerSlab(parent.getId().m_135815_() + "_slab", parent, factory);
    }

    private static <T extends DirectionalSlabBlock> RegistryObject<T> registerSlab(String name, RegistryObject<? extends Block> parent, Function<BlockBehaviour.Properties, T> factory) {
        return BLOCKS.register(name, () -> (DirectionalSlabBlock)((Object)((Object)factory.apply(ModBlocks.copyProperties((BlockBehaviour)parent.get())))));
    }

    private static RegistryObject<MembraneBlock> registerMembrane(String name, IgnoreEntityCollisionPredicate predicate) {
        return ModBlocks.registerMembrane(name, predicate, MembraneBlock::new);
    }

    private static <T extends MembraneBlock> RegistryObject<T> registerMembrane(String name, IgnoreEntityCollisionPredicate predicate, MembraneBlockFactory<T> factory) {
        return ModBlocks.register(name, (BlockBehaviour.Properties props) -> {
            props = props.m_60955_().m_60924_(ModBlocks::neverValid).m_60960_(ModBlocks::neverValid).m_60971_(ModBlocks::neverValid);
            return factory.create((BlockBehaviour.Properties)props, predicate);
        });
    }

    private static <T extends MembraneBlock> RegistryObject<T> registerMembrane(String name, Function<BlockBehaviour.Properties, T> factory) {
        return ModBlocks.register(name, (BlockBehaviour.Properties properties) -> {
            properties = properties.m_60955_().m_60924_(ModBlocks::neverValid).m_60960_(ModBlocks::neverValid).m_60971_(ModBlocks::neverValid);
            return (MembraneBlock)factory.apply((BlockBehaviour.Properties)properties);
        });
    }

    private static RegistryObject<MembranePaneBlock> registerMembranePane(String name, IgnoreEntityCollisionPredicate predicate) {
        return ModBlocks.registerMembranePane(name, predicate, MembranePaneBlock::new);
    }

    private static <T extends MembranePaneBlock> RegistryObject<T> registerMembranePane(String name, IgnoreEntityCollisionPredicate predicate, MembranePaneBlockFactory<T> factory) {
        return ModBlocks.register(name, (BlockBehaviour.Properties props) -> {
            props = props.m_60955_().m_60924_(ModBlocks::neverValid).m_60960_(ModBlocks::neverValid).m_60971_(ModBlocks::neverValid);
            return factory.create((BlockBehaviour.Properties)props, predicate);
        });
    }

    private static <T extends MembranePaneBlock> RegistryObject<T> registerMembranePane(String name, Function<BlockBehaviour.Properties, T> factory) {
        return ModBlocks.register(name, (BlockBehaviour.Properties properties) -> {
            properties = properties.m_60955_().m_60924_(ModBlocks::neverValid).m_60960_(ModBlocks::neverValid).m_60971_(ModBlocks::neverValid);
            return (MembranePaneBlock)factory.apply((BlockBehaviour.Properties)properties);
        });
    }

    public static BlockBehaviour.Properties copyProperties(BlockBehaviour behaviour) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)behaviour);
    }

    public static BlockBehaviour.Properties createFleshProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60913_(3.0f, 3.0f).m_60918_((SoundType)ModSoundTypes.FLESH_BLOCK).m_60922_(ModBlocks::isValidFleshkinSpawn);
    }

    public static BlockBehaviour.Properties createFleshVeinsProperties() {
        return BlockBehaviour.Properties.m_284310_().m_60913_(3.0f, 3.0f).m_60910_().m_278166_(PushReaction.DESTROY).m_60918_((SoundType)ModSoundTypes.FLESH_BLOCK).m_60922_(ModBlocks::isValidFleshkinSpawn);
    }

    public static BlockBehaviour.Properties createToughFleshProperties() {
        return ModBlocks.createFleshProperties().m_60913_(6.0f, 12.0f);
    }

    public static BlockBehaviour.Properties createBonyFleshProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_).m_60913_(4.0f, 6.0f).m_60918_((SoundType)ModSoundTypes.BONY_FLESH_BLOCK).m_60922_(ModBlocks::isValidFleshkinSpawn);
    }

    public static boolean isValidFleshkinSpawn(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        return entityType.m_204039_(ModEntityTags.FLESHKIN) && state.m_60783_(level, pos, Direction.UP);
    }

    public static boolean neverValid(BlockState state, BlockGetter level, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public static boolean neverValid(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    static interface StairBlockFactory<T extends StairBlock> {
        public T create(Supplier<BlockState> var1, BlockBehaviour.Properties var2);
    }

    static interface MembraneBlockFactory<T extends MembraneBlock> {
        public T create(BlockBehaviour.Properties var1, IgnoreEntityCollisionPredicate var2);
    }

    static interface MembranePaneBlockFactory<T extends MembranePaneBlock> {
        public T create(BlockBehaviour.Properties var1, IgnoreEntityCollisionPredicate var2);
    }
}

