/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.init;

import com.github.elenterius.biomancy.api.nutrients.Nutrients;
import com.github.elenterius.biomancy.block.cauldron.AcidCauldron;
import com.github.elenterius.biomancy.block.digester.DigesterBlockEntity;
import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.fluid.TintedFluidType;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.ModPotions;
import com.github.elenterius.biomancy.init.tags.ModBlockTags;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import com.github.elenterius.biomancy.item.SimpleItem;
import com.github.elenterius.biomancy.util.CombatUtil;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public final class AcidInteractions {
    public static final Map<Item, CauldronInteraction> ACID_CAULDRON = CauldronInteraction.m_175617_();
    public static final Map<Block, BlockState> NORMAL_TO_ERODED_BLOCK_CONVERSION = Map.of(Blocks.f_50440_, Blocks.f_50493_.m_49966_(), Blocks.f_50652_, Blocks.f_49994_.m_49966_(), Blocks.f_50222_, Blocks.f_50224_.m_49966_(), Blocks.f_152589_, Blocks.f_152594_.m_49966_(), Blocks.f_152559_, Blocks.f_152595_.m_49966_(), Blocks.f_50735_, Blocks.f_50736_.m_49966_(), Blocks.f_50197_, Blocks.f_50713_.m_49966_());

    private AcidInteractions() {
    }

    static void register() {
        AcidInteractions.registerCauldronInteractions();
    }

    private static void registerCauldronInteractions() {
        CauldronInteraction fillWithAcid = (state, level, pos, player, hand, stack) -> {
            SoundEvent sound = Objects.requireNonNullElse(((TintedFluidType)((Object)((Object)ModFluids.ACID_TYPE.get()))).getSound(SoundActions.BUCKET_EMPTY), SoundEvents.f_11778_);
            return CauldronInteraction.m_175618_((Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (BlockState)((BlockState)((AcidCauldron)((Object)((Object)ModBlocks.ACID_CAULDRON.get()))).m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3))), (SoundEvent)sound);
        };
        CauldronInteraction.f_175606_.put((Item)ModItems.ACID_BUCKET.get(), fillWithAcid);
        CauldronInteraction originalPotionInteraction = Objects.requireNonNull((CauldronInteraction)CauldronInteraction.f_175606_.get(Items.f_42589_));
        CauldronInteraction.f_175606_.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if (PotionUtils.m_43579_((ItemStack)stack) != ModPotions.GASTRIC_JUICE.get()) {
                return originalPotionInteraction.m_175710_(state, level, pos, player, hand, stack);
            }
            if (!level.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_46597_(pos, ((AcidCauldron)((Object)((Object)ModBlocks.ACID_CAULDRON.get()))).m_49966_());
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        ACID_CAULDRON.put((Item)ModItems.ACID_BUCKET.get(), fillWithAcid);
        ACID_CAULDRON.put(Items.f_42446_, (state, level, pos, player, hand, stack) -> {
            SoundEvent sound = Objects.requireNonNullElse(((TintedFluidType)((Object)((Object)ModFluids.ACID_TYPE.get()))).getSound(SoundActions.BUCKET_FILL), SoundEvents.f_11781_);
            return CauldronInteraction.m_175635_((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)((BucketItem)ModItems.ACID_BUCKET.get()).m_7968_(), AcidInteractions::isCauldronFull, (SoundEvent)sound);
        });
        ACID_CAULDRON.put(Items.f_42590_, (state, level, pos, player, hand, stack) -> {
            if (!level.f_46443_) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ModPotions.GASTRIC_JUICE.get()))));
                player.m_36220_(Stats.f_12944_);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        });
        ACID_CAULDRON.put(Items.f_42589_, (state, level, pos, player, hand, stack) -> {
            if (!AcidInteractions.isCauldronFull(state) && PotionUtils.m_43579_((ItemStack)stack) == ModPotions.GASTRIC_JUICE.get()) {
                if (!level.f_46443_) {
                    player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42590_)));
                    player.m_36220_(Stats.f_12944_);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    level.m_46597_(pos, (BlockState)state.m_61122_((Property)LayeredCauldronBlock.f_153514_));
                    level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }

    private static boolean isCauldronFull(BlockState state) {
        return (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3;
    }

    @Nullable
    public static Block convertBlock(Block block) {
        if (block instanceof WeatheringCopper && WeatheringCopper.m_154904_((Block)block).isPresent()) {
            return (Block)WeatheringCopper.m_154904_((Block)block).get();
        }
        if (block.m_204297_().m_203656_(ModBlockTags.ACID_DESTRUCTIBLE)) {
            return Blocks.f_50016_;
        }
        if (NORMAL_TO_ERODED_BLOCK_CONVERSION.containsKey(block)) {
            return NORMAL_TO_ERODED_BLOCK_CONVERSION.get(block).m_60734_();
        }
        return null;
    }

    public static void handleEntityInsideAcidFluid(LivingEntity livingEntity) {
        if (livingEntity.m_5833_()) {
            return;
        }
        if (livingEntity.f_19797_ % 5 != 0) {
            return;
        }
        if (!livingEntity.isInFluidType((FluidType)ModFluids.ACID_TYPE.get())) {
            return;
        }
        AcidInteractions.handleEntityInsideAcid(livingEntity);
    }

    public static void handleEntityInsideAcid(LivingEntity livingEntity) {
        if (!livingEntity.m_9236_().f_46443_) {
            CombatUtil.applyAcidEffect(livingEntity, 4);
        } else if (livingEntity.f_19797_ % 10 == 0 && livingEntity.m_217043_().m_188501_() < 0.4f) {
            Level level = livingEntity.m_9236_();
            RandomSource random = livingEntity.m_217043_();
            Vec3 pos = livingEntity.m_20182_();
            double height = livingEntity.m_20191_().m_82376_() * 0.5;
            level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f, false);
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, pos.f_82479_ + random.m_188500_(), pos.f_82480_ + random.m_188500_() * height, pos.f_82481_ + random.m_188500_(), 0.0, 0.1, 0.0);
            }
        }
    }

    public static final class InWorldItemDigesting {
        public static final String BASE_DATA_KEY = "biomancy:acid_digestion";
        public static final String TIMER_KEY = "timer";
        public static final String DELAY_KEY = "delay";
        public static final String RECIPE_KEY = "recipe";
        public static final double EFFICIENCY = 0.8;
        public static final int BASE_DELAY = 10;

        private InWorldItemDigesting() {
        }

        public static void tryDigestSubmergedItem(ItemEntity itemEntity) {
            if (itemEntity.m_32059_() % 10 != 0) {
                return;
            }
            if (!InWorldItemDigesting.isDigestible(itemEntity)) {
                return;
            }
            Level level = itemEntity.m_9236_();
            ItemStack itemStack = itemEntity.m_32055_();
            CompoundTag entityData = itemEntity.getPersistentData();
            CompoundTag digestionData = InWorldItemDigesting.getOrCreateDigestionData(entityData);
            int digestionTimer = digestionData.m_128451_(TIMER_KEY);
            if (level.f_46443_ && digestionTimer > 0) {
                Vec3 pos = itemEntity.m_20182_();
                RandomSource random = level.m_213780_();
                level.m_7106_((ParticleOptions)ModParticleTypes.ACID_BUBBLE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, random.m_188583_() / 100.0, Math.abs(random.m_188583_() / 50.0), random.m_188583_() / 100.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, random.m_188583_() / 100.0, Math.abs(random.m_188583_() / 100.0), random.m_188583_() / 100.0);
                if (random.m_188501_() < 0.4f) {
                    level.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 2.6f + (random.m_188501_() - random.m_188501_()) * 0.8f, false);
                }
                return;
            }
            @Nullable ResourceLocation lastRecipeId = ResourceLocation.m_135820_((String)digestionData.m_128461_(RECIPE_KEY));
            Optional optionalRecipe = ((SimpleRecipeType.ItemStackRecipeType)DigesterBlockEntity.RECIPE_TYPE.get()).getRecipeForIngredient(level, itemStack, lastRecipeId);
            if (optionalRecipe.isEmpty()) {
                return;
            }
            ResourceLocation recipeId = (ResourceLocation)optionalRecipe.get().getFirst();
            DigestingRecipe recipe = (DigestingRecipe)optionalRecipe.get().getSecond();
            if (!recipeId.equals((Object)lastRecipeId)) {
                digestionData.m_128359_(RECIPE_KEY, recipeId.toString());
                RecipeWrapper inventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
                inventory.m_6836_(0, itemStack);
                digestionData.m_128405_(DELAY_KEY, recipe.getCraftingTimeTicks((Container)inventory) / 40);
            }
            if (digestionTimer < 10 + digestionData.m_128451_(DELAY_KEY)) {
                digestionData.m_128405_(TIMER_KEY, digestionTimer + 1);
                entityData.m_128365_(BASE_DATA_KEY, (Tag)digestionData);
            } else {
                if (!level.f_46443_) {
                    InWorldItemDigesting.digestAtPos(itemEntity.m_9236_(), itemEntity.m_20182_(), itemStack, 8, recipe);
                    if (itemStack.m_41619_()) {
                        itemEntity.m_146870_();
                    } else {
                        itemEntity.m_32045_(itemStack);
                    }
                }
                digestionData.m_128405_(TIMER_KEY, 1);
            }
        }

        public static CompoundTag getOrCreateDigestionData(CompoundTag entityData) {
            if (entityData.m_128441_(BASE_DATA_KEY)) {
                return entityData.m_128469_(BASE_DATA_KEY);
            }
            return new CompoundTag();
        }

        public static void digestAtPos(Level level, Vec3 pos, ItemStack inputStack, int maxAmount, DigestingRecipe recipe) {
            int remainder;
            RecipeWrapper inventory = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
            inventory.m_6836_(0, inputStack);
            int amount = Math.min(inputStack.m_41613_(), maxAmount);
            ItemStack outputStack = recipe.m_5874_((Container)inventory, level.m_9598_());
            double fuelValue = Nutrients.getFuelValue(outputStack);
            double craftingCost = (double)recipe.getCraftingCostNutrients((Container)inventory) / fuelValue;
            double totalCount = ((double)(outputStack.m_41613_() * amount) - craftingCost * (double)amount) * 0.8;
            int outputCount = Mth.m_14107_((double)totalCount);
            if (outputCount > 0) {
                InWorldItemDigesting.spawnItems(level, pos, outputStack, outputCount);
            }
            if ((remainder = Mth.m_14165_((double)((totalCount - (double)outputCount) * fuelValue))) > 0) {
                InWorldItemDigesting.spawnItems(level, pos, ((SimpleItem)ModItems.NUTRIENTS.get()).m_7968_(), remainder);
            }
            inputStack.m_41774_(amount);
            level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12321_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }

        private static void spawnItems(Level level, Vec3 pos, ItemStack itemType, int totalCount) {
            int maxStackSize = itemType.m_41741_();
            while (totalCount > 0) {
                int count = Math.min(totalCount, maxStackSize);
                DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)itemType.m_255036_(count), (int)1, (Direction)Direction.UP, (Position)pos);
                totalCount -= count;
            }
        }

        public static boolean isDigestible(ItemEntity itemEntity) {
            if (itemEntity.m_32055_().m_204117_(ModItemTags.CANNOT_BE_DIGESTED_IN_ACID)) {
                return false;
            }
            return itemEntity.isInFluidType((FluidType)ModFluids.ACID_TYPE.get()) || itemEntity.m_9236_().m_8055_(itemEntity.m_20183_()).m_60713_((Block)ModBlocks.ACID_CAULDRON.get());
        }
    }
}

