/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.projectile;

import com.github.elenterius.biomancy.entity.projectile.BaseProjectile;
import com.github.elenterius.biomancy.init.ModDamageSources;
import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;

public class ToothProjectile
extends BaseProjectile
implements ItemSupplier {
    private static final Lazy<ItemStack> ITEM_TO_RENDER = Lazy.of(() -> new ItemStack((ItemLike)ModItems.MOB_FANG.get()));

    public ToothProjectile(EntityType<? extends BaseProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public ToothProjectile(Level world, double x, double y, double z) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntityTypes.TOOTH_PROJECTILE.get()), world, x, y, z);
    }

    @Override
    public float getGravity() {
        return 0.01f;
    }

    protected void m_5790_(EntityHitResult result) {
        boolean success;
        super.m_5790_(result);
        Entity victim = result.m_82443_();
        Entity shooter = this.m_19749_();
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            livingEntity.m_21335_(victim);
        }
        if ((success = victim.m_6469_(ModDamageSources.toothProjectile(this.m_9236_(), this, shooter), this.getDamage())) && victim instanceof LivingEntity && !this.m_9236_().f_46443_) {
            Vec3 vector3d;
            if (this.getKnockback() > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.getKnockback() * 0.6)).m_82556_() > 0.0) {
                victim.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
            if (shooter instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)shooter;
                this.m_19970_(livingEntity, victim);
            }
            if (!this.m_20067_() && victim != shooter && victim instanceof Player && shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
            }
        }
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.f_123759_;
    }

    public ItemStack m_7846_() {
        return (ItemStack)ITEM_TO_RENDER.get();
    }
}

