/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob.fleshblob;

import net.minecraft.util.RandomSource;

public enum TumorFlag {
    TUMOR1,
    TUMOR2,
    TUMOR3,
    TUMOR4,
    TUMOR5,
    TUMOR6,
    TUMOR7;

    private static final String[] BONE_IDS;
    private final int bitPosition = 1 << this.ordinal();

    public static int getMaxNumber() {
        return (int)Math.pow(2.0, TumorFlag.values().length) - 1;
    }

    public static boolean isFlagSet(int value, TumorFlag flag) {
        return (value & flag.bitPosition) != 0;
    }

    public static int setFlag(int value, TumorFlag flag) {
        return value | flag.bitPosition;
    }

    public static int unsetFlag(int value, TumorFlag flag) {
        return value & ~flag.bitPosition;
    }

    public static byte randomFlags(RandomSource random) {
        return (byte)random.m_188503_(128);
    }

    public String getBoneId() {
        return BONE_IDS[this.ordinal()];
    }

    public boolean isNotSet(int flag) {
        return !this.isSet(flag);
    }

    public boolean isSet(int flag) {
        return (flag & this.bitPosition) != 0;
    }

    public int getBitPosition() {
        return this.bitPosition;
    }

    static {
        BONE_IDS = new String[]{"tumor", "tumor2", "tumor3", "tumor4", "tumor5", "tumor6", "tumor7"};
    }
}

