/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.entity.mob;

import com.github.elenterius.biomancy.init.ModEntityTypes;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModLoot;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.mixin.accessor.SheepAccessor;
import com.github.elenterius.biomancy.util.animation.MobAnimations;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FleshSheep
extends Sheep
implements GeoEntity {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FleshSheep(EntityType<? extends Sheep> entityType, Level level) {
        super(entityType, level);
    }

    public void m_29855_(DyeColor dyeColor) {
        super.m_29855_(DyeColor.GRAY);
    }

    public DyeColor m_29874_() {
        return DyeColor.GRAY;
    }

    public void m_5851_(SoundSource soundSource) {
        ItemEntity itemEntity;
        int i;
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, soundSource, 1.0f, 1.0f);
        this.m_29878_(true);
        int count = this.f_19796_.m_216332_(1, 4);
        for (i = 0; i < count; ++i) {
            itemEntity = this.m_20000_((ItemLike)ModItems.FLESH_BITS.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
        count = this.f_19796_.m_216332_(2, 4);
        for (i = 0; i < count; ++i) {
            itemEntity = this.m_20000_((ItemLike)Items.f_42401_, 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    public List<ItemStack> onSheared(@Nullable Player player, ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            int i;
            this.m_29878_(true);
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int count = this.f_19796_.m_216332_(1, 4);
            for (i = 0; i < count; ++i) {
                list.add(new ItemStack((ItemLike)ModItems.FLESH_BITS.get()));
            }
            count = this.f_19796_.m_216332_(2, 4);
            for (i = 0; i < count; ++i) {
                list.add(new ItemStack((ItemLike)Items.f_42401_));
            }
            return list;
        }
        return List.of();
    }

    public ResourceLocation m_7582_() {
        return this.m_29875_() ? this.m_6095_().m_20677_() : ModLoot.Entity.FLESH_SHEEP_UNSHORN;
    }

    @Nullable
    public Sheep m_142606_(ServerLevel level, AgeableMob otherParent) {
        if (otherParent.getClass() != ((Object)((Object)this)).getClass() && this.f_19796_.m_188501_() < 0.15f) {
            return (Sheep)otherParent.m_142606_(level, (AgeableMob)this);
        }
        return (Sheep)((EntityType)ModEntityTypes.FLESH_SHEEP.get()).m_20615_((Level)level);
    }

    public boolean m_7848_(Animal otherAnimal) {
        return super.m_7848_(otherAnimal);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.FLESH_SHEEP_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.FLESH_SHEEP_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.FLESH_SHEEP_DEATH.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{MobAnimations.walkController(this)});
        controllers.add(new AnimationController[]{MobAnimations.babyTransformController(this)});
        controllers.add(new AnimationController[]{Animations.shearedController(this)});
        controllers.add(new AnimationController[]{Animations.grazingController(this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static final class Animations {
        public static final RawAnimation GRAZING_ANIMATION = RawAnimation.begin().thenPlay("grazing");
        public static final RawAnimation SHEARED_ANIMATION = RawAnimation.begin().thenPlay("sheared");

        private Animations() {
        }

        public static <T extends Sheep> AnimationController<T> grazingController(T geoEntity) {
            return new AnimationController(geoEntity, "grazing", state -> {
                if (Animations.getEatAnimationTick((Sheep)state.getAnimatable()) > 0) {
                    return state.setAndContinue(GRAZING_ANIMATION);
                }
                state.resetCurrentAnimation();
                return PlayState.STOP;
            });
        }

        public static <T extends Sheep> AnimationController<T> shearedController(T geoEntity) {
            return new AnimationController(geoEntity, "sheared", state -> {
                if (geoEntity.m_29875_()) {
                    return state.setAndContinue(SHEARED_ANIMATION);
                }
                return PlayState.STOP;
            });
        }

        public static int getEatAnimationTick(Sheep sheep) {
            return ((SheepAccessor)sheep).biomancy$getEatAnimationTick();
        }
    }
}

