/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.datagen.recipes.builder;

import com.github.elenterius.biomancy.BiomancyMod;
import com.github.elenterius.biomancy.datagen.recipes.builder.RecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class WorkbenchRecipeBuilder {
    private WorkbenchRecipeBuilder() {
    }

    public static ShapedBuilder shaped(RecipeCategory category, ItemLike result) {
        return WorkbenchRecipeBuilder.shaped(category, result, 1);
    }

    public static ShapedBuilder shaped(RecipeCategory category, ItemLike result, int count) {
        return new ShapedBuilder(category, result, count);
    }

    public static ShapelessBuilder shapeless(RecipeCategory category, ItemLike result) {
        return WorkbenchRecipeBuilder.shapeless(category, result, 1);
    }

    public static ShapelessBuilder shapeless(RecipeCategory category, ItemLike result, int count) {
        return new ShapelessBuilder(category, result, count);
    }

    public static ShapedBuilder wall(RecipeCategory category, ItemLike result, ItemLike ingredient) {
        return (ShapedBuilder)WorkbenchRecipeBuilder.wall(category, result, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).unlockedBy(ingredient);
    }

    public static ShapedBuilder wall(RecipeCategory category, ItemLike result, Ingredient ingredient) {
        return WorkbenchRecipeBuilder.shaped(category, result, 6).define(Character.valueOf('#'), ingredient).pattern("###").pattern("###");
    }

    public static ShapedBuilder slab(RecipeCategory category, ItemLike result, ItemLike ingredient) {
        return (ShapedBuilder)WorkbenchRecipeBuilder.slab(category, result, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).unlockedBy(ingredient);
    }

    public static ShapedBuilder slab(RecipeCategory category, ItemLike result, Ingredient ingredient) {
        return WorkbenchRecipeBuilder.shaped(category, result, 6).define(Character.valueOf('#'), ingredient).pattern("###");
    }

    public static ShapedBuilder polished(RecipeCategory category, ItemLike result, ItemLike ingredient) {
        return (ShapedBuilder)WorkbenchRecipeBuilder.polished(category, result, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).unlockedBy(ingredient);
    }

    public static ShapedBuilder polished(RecipeCategory category, ItemLike result, Ingredient ingredient) {
        return WorkbenchRecipeBuilder.shaped(category, result, 4).define(Character.valueOf('S'), ingredient).pattern("SS").pattern("SS");
    }

    public static ShapedBuilder stairs(RecipeCategory category, ItemLike result, ItemLike ingredient) {
        return (ShapedBuilder)WorkbenchRecipeBuilder.polished(category, result, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).unlockedBy(ingredient);
    }

    public static ShapedBuilder stairs(RecipeCategory category, ItemLike result, Ingredient ingredient) {
        return WorkbenchRecipeBuilder.shaped(category, result, 4).define(Character.valueOf('#'), ingredient).pattern("#  ").pattern("## ").pattern("###");
    }

    private static String getItemName(ItemLike itemLike) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_());
        return key != null ? key.m_135815_() : "unknown";
    }

    private static String getTagName(TagKey<Item> tag) {
        return tag.f_203868_().m_135815_();
    }

    public static final class ShapedBuilder
    implements RecipeBuilder<ShapedBuilder> {
        private final ShapedRecipeBuilder internalBuilder;

        private ShapedBuilder(RecipeCategory category, ItemLike result, int count) {
            this.internalBuilder = new ShapedRecipeBuilder(category, result, count);
        }

        public ShapedBuilder define(Character pSymbol, TagKey<Item> tag) {
            this.internalBuilder.m_206416_(pSymbol, tag);
            return this;
        }

        public ShapedBuilder define(Character symbol, ItemLike item) {
            this.internalBuilder.m_126127_(symbol, item);
            return this;
        }

        public ShapedBuilder define(Character symbol, Ingredient ingredient) {
            this.internalBuilder.m_126124_(symbol, ingredient);
            return this;
        }

        public ShapedBuilder pattern(String pattern) {
            this.internalBuilder.m_126130_(pattern);
            return this;
        }

        public ShapedBuilder group(@Nullable String groupName) {
            this.internalBuilder.m_126145_(groupName);
            return this;
        }

        public ShapedBuilder showNotification(boolean flag) {
            this.internalBuilder.m_271710_(flag);
            return this;
        }

        @Override
        public ShapedBuilder unlockedBy(String name, CriterionTriggerInstance trigger) {
            this.internalBuilder.m_126132_(name, trigger);
            return this;
        }

        @Override
        public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
            this.save(consumer, BiomancyMod.createRL(WorkbenchRecipeBuilder.getItemName((ItemLike)this.internalBuilder.m_142372_())));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
            this.internalBuilder.m_126140_(consumer, recipeId.m_246208_("crafting/"));
        }
    }

    public static final class ShapelessBuilder
    implements RecipeBuilder<ShapelessBuilder> {
        private final ShapelessRecipeBuilder internalBuilder;

        private ShapelessBuilder(RecipeCategory category, ItemLike result, int count) {
            this.internalBuilder = new ShapelessRecipeBuilder(category, result, count);
        }

        public ShapelessBuilder requires(TagKey<Item> tag) {
            this.internalBuilder.m_206419_(tag);
            return this;
        }

        public ShapelessBuilder requires(ItemLike item) {
            this.internalBuilder.m_126209_(item);
            return this;
        }

        public ShapelessBuilder requires(ItemLike item, int quantity) {
            this.internalBuilder.m_126211_(item, quantity);
            return this;
        }

        public ShapelessBuilder requires(Ingredient ingredient) {
            this.internalBuilder.m_126184_(ingredient);
            return this;
        }

        public ShapelessBuilder requires(Ingredient ingredient, int quantity) {
            this.internalBuilder.m_126186_(ingredient, quantity);
            return this;
        }

        public ShapelessBuilder group(@Nullable String groupName) {
            this.internalBuilder.m_126145_(groupName);
            return this;
        }

        @Override
        public ShapelessBuilder unlockedBy(String name, CriterionTriggerInstance trigger) {
            this.internalBuilder.m_126132_(name, trigger);
            return this;
        }

        @Override
        public void save(Consumer<FinishedRecipe> consumer, @Nullable RecipeCategory category) {
            this.save(consumer, BiomancyMod.createRL(WorkbenchRecipeBuilder.getItemName((ItemLike)this.internalBuilder.m_142372_())));
        }

        public void save(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
            this.internalBuilder.m_126140_(consumer, recipeId.m_246208_("crafting/"));
        }
    }
}

