/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.crafting.recipe.DigestingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.StaticProcessingRecipe;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class StaticDigestingRecipe
extends StaticProcessingRecipe
implements DigestingRecipe {
    private final Ingredient recipeIngredient;
    private final NonNullList<Ingredient> recipeIngredients;
    private final ItemStack recipeResult;

    public StaticDigestingRecipe(ResourceLocation id, ItemStack result, int craftingTimeTicks, int craftingCostNutrients, Ingredient ingredient) {
        super(id, craftingTimeTicks, craftingCostNutrients);
        this.recipeIngredient = ingredient;
        this.recipeIngredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.recipeIngredient});
        this.recipeResult = result;
    }

    public boolean m_5818_(Container inputInventory, Level worldIn) {
        return this.recipeIngredient.test(inputInventory.m_8020_(0));
    }

    public ItemStack m_5874_(Container inputInventory, RegistryAccess registryAccess) {
        return this.recipeResult.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height == 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.recipeResult;
    }

    @Override
    public Ingredient getIngredient() {
        return this.recipeIngredient;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeIngredients;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.DIGESTING_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.DIGESTING_RECIPE_TYPE.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModItems.DIGESTER.get());
    }

    public static class Serializer
    implements RecipeSerializer<StaticDigestingRecipe> {
        public StaticDigestingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            if (ingredient.m_43947_()) {
                throw new JsonParseException("No ingredient found for %s/%s recipe".formatted(ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)this), recipeId));
            }
            ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"processingTime", (int)100);
            int cost = GsonHelper.m_13824_((JsonObject)json, (String)"nutrientsCost", (int)1);
            return new StaticDigestingRecipe(recipeId, resultStack, time, cost, ingredient);
        }

        @Nullable
        public StaticDigestingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack resultStack = buffer.m_130267_();
            int craftingTime = buffer.m_130242_();
            int craftingCost = buffer.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new StaticDigestingRecipe(recipeId, resultStack, craftingTime, craftingCost, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, StaticDigestingRecipe recipe) {
            buffer.m_130055_(recipe.recipeResult);
            buffer.m_130130_(recipe.craftingTimeTicks);
            buffer.m_130130_(recipe.craftingCostNutrients);
            recipe.recipeIngredient.m_43923_(buffer);
        }
    }
}

