/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimpleRecipeType<T extends Recipe<?>>
implements RecipeType<T> {
    private final String identifier;

    public SimpleRecipeType(String identifier) {
        this.identifier = identifier;
    }

    public String getId() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public static class ItemStackRecipeType<R extends Recipe<Container>>
    extends SimpleRecipeType<R> {
        public ItemStackRecipeType(String identifier) {
            super(identifier);
        }

        public Optional<R> getRecipeById(Level level, ResourceLocation id) {
            RecipeManager recipeManager = level.m_7465_();
            return Optional.ofNullable(this.castRecipe((Recipe<Container>)((Recipe)recipeManager.m_44054_((RecipeType)this).get(id))));
        }

        public Optional<R> getRecipeFromContainer(Level level, Container inputInventory) {
            RecipeManager recipeManager = level.m_7465_();
            return recipeManager.m_44015_((RecipeType)this, inputInventory, level);
        }

        @Nullable
        private R castRecipe(@Nullable Recipe<Container> recipe) {
            return (R)recipe;
        }

        private boolean matches(R recipe, ItemStack stack) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }

        public Optional<R> getRecipeForIngredient(Level level, ItemStack stack) {
            RecipeManager recipeManager = level.m_7465_();
            return recipeManager.m_44054_((RecipeType)this).values().stream().filter(recipe -> this.matches(recipe, stack)).findFirst().map(this::castRecipe);
        }

        public Optional<Pair<ResourceLocation, R>> getRecipeForIngredient(Level level, ItemStack stack, @Nullable ResourceLocation lastRecipeId) {
            Recipe recipe;
            RecipeManager recipeManager = level.m_7465_();
            Map map = recipeManager.m_44054_((RecipeType)this);
            if (lastRecipeId != null && (recipe = (Recipe)map.get(lastRecipeId)) != null && this.matches(recipe, stack)) {
                return Optional.of(Pair.of((Object)lastRecipeId, (Object)recipe));
            }
            return map.entrySet().stream().filter(entry -> this.matches((Recipe)entry.getValue(), stack)).findFirst().map(entry -> Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((Recipe)entry.getValue())));
        }
    }
}

