/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting.recipe;

import com.github.elenterius.biomancy.crafting.IngredientStack;
import com.github.elenterius.biomancy.crafting.VariableOutput;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.IdMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class RecipeUtil {
    private RecipeUtil() {
    }

    public static JsonObject writeItemStack(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("id", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            json.addProperty("tag", stack.m_41783_().toString());
        }
        return json;
    }

    public static ItemStack readItemStack(JsonObject json) {
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)"id");
        Item item = CraftingHelper.getItem((String)itemName, (boolean)false);
        if (json.has("tag")) {
            CompoundTag tag = CraftingHelper.getNBT((JsonElement)json.get("tag"));
            CompoundTag tmp = new CompoundTag();
            if (tag.m_128441_("ForgeCaps")) {
                tmp.m_128365_("ForgeCaps", tag.m_128423_("ForgeCaps"));
                tag.m_128473_("ForgeCaps");
            }
            tmp.m_128365_("tag", (Tag)tag);
            tmp.m_128359_("id", itemName);
            tmp.m_128405_("Count", GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
            return ItemStack.m_41712_((CompoundTag)tmp);
        }
        return new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
    }

    public static void writeItem(FriendlyByteBuf buffer, @Nullable Item item) {
        if (item == null || item == Items.f_41852_) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)item);
        }
    }

    @Nullable
    public static Item readItem(FriendlyByteBuf buffer) {
        return !buffer.readBoolean() ? null : (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_);
    }

    public static Ingredient readIngredient(JsonObject json, String memberName) {
        return Ingredient.m_43917_((JsonElement)(GsonHelper.m_13885_((JsonObject)json, (String)memberName) ? GsonHelper.m_13933_((JsonObject)json, (String)memberName) : GsonHelper.m_13930_((JsonObject)json, (String)memberName)));
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < jsonArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
            if (ingredient.m_43947_()) continue;
            list.add((Object)ingredient);
        }
        return list;
    }

    public static List<VariableOutput> readVariableProductionOutputs(JsonArray jsonArray) {
        ArrayList<VariableOutput> list = new ArrayList<VariableOutput>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(VariableOutput.deserialize(jsonArray.get(i).getAsJsonObject()));
        }
        return list;
    }

    public static List<IngredientStack> readIngredientStacks(JsonArray jsonArray) {
        ArrayList<IngredientStack> list = new ArrayList<IngredientStack>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            IngredientStack ingredientStack = IngredientStack.fromJson(jsonArray.get(i).getAsJsonObject());
            if (ingredientStack.ingredient().m_43947_()) continue;
            list.add(ingredientStack);
        }
        return list;
    }

    public static List<Ingredient> flattenIngredientStacks(List<IngredientStack> ingredients) {
        ArrayList<Ingredient> flatIngredients = new ArrayList<Ingredient>();
        for (IngredientStack ingredientStack : ingredients) {
            Ingredient ingredient = ingredientStack.ingredient();
            for (int i = 0; i < ingredientStack.count(); ++i) {
                flatIngredients.add(ingredient);
            }
        }
        return flatIngredients;
    }
}

