/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting;

import com.github.elenterius.biomancy.crafting.ItemCountRange;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class VariableOutput {
    private final Item item;
    @Nullable
    private final CompoundTag tag;
    private final ItemCountRange countRange;

    public VariableOutput(ItemStack stack) {
        this(stack, stack.m_41613_());
    }

    public VariableOutput(ItemStack stack, int count) {
        this((ItemLike)stack.m_41720_(), stack.m_41783_(), new ItemCountRange.ConstantValue(count));
    }

    public VariableOutput(ItemStack stack, int min, int max) {
        this((ItemLike)stack.m_41720_(), stack.m_41783_(), new ItemCountRange.UniformRange(min, max));
    }

    public VariableOutput(ItemStack stack, int n, float p) {
        this((ItemLike)stack.m_41720_(), stack.m_41783_(), new ItemCountRange.BinomialRange(n, p));
    }

    public VariableOutput(ItemLike item) {
        this(item, 1);
    }

    public VariableOutput(ItemLike item, int count) {
        this(item, (ItemCountRange)new ItemCountRange.ConstantValue(count));
    }

    public VariableOutput(ItemLike item, int min, int max) {
        this(item, (ItemCountRange)new ItemCountRange.UniformRange(min, max));
    }

    public VariableOutput(ItemLike item, int n, float p) {
        this(item, (ItemCountRange)new ItemCountRange.BinomialRange(n, p));
    }

    public VariableOutput(ItemStack stack, ItemCountRange countRange) {
        this((ItemLike)stack.m_41720_(), stack.m_41783_(), countRange);
    }

    public VariableOutput(ItemLike item, ItemCountRange countRange) {
        this(item, null, countRange);
    }

    public VariableOutput(ItemLike item, @Nullable CompoundTag tag, ItemCountRange countRange) {
        this.item = item.m_5456_();
        this.tag = tag;
        this.countRange = countRange;
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        if (this.tag != null && !this.tag.m_128456_()) {
            stack.m_41751_(this.tag.m_6426_());
        }
        return stack;
    }

    public ItemStack getItemStack(RandomSource rng) {
        int count = this.getCount(rng);
        if (count < 1) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)this.item);
        if (this.tag != null && !this.tag.m_128456_()) {
            stack.m_41751_(this.tag.m_6426_());
        }
        stack.m_41764_(count);
        return stack;
    }

    public int getCount(RandomSource rng) {
        return this.countRange.getCount(rng);
    }

    public ItemCountRange getCountRange() {
        return this.countRange;
    }

    public JsonObject serialize() {
        JsonObject result = new JsonObject();
        result.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.item)).toString());
        JsonObject obj = new JsonObject();
        ItemCountRange.toJson(obj, this.countRange);
        result.add("countRange", (JsonElement)obj);
        if (this.tag != null && !this.tag.m_128456_()) {
            result.addProperty("nbt", this.tag.m_7916_());
        }
        return result;
    }

    public static VariableOutput deserialize(JsonObject jsonObject) {
        ItemStack stack = ShapedRecipe.m_151274_((JsonObject)jsonObject);
        ItemCountRange countRange = ItemCountRange.fromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"countRange"));
        if (stack.m_41619_()) {
            throw new JsonParseException("Result can't be Empty");
        }
        return new VariableOutput(stack, countRange);
    }

    public static VariableOutput fromNetwork(FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        ItemCountRange range = ItemCountRange.fromNetwork(buffer);
        return new VariableOutput(stack, range);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.getItemStack());
        ItemCountRange.toNetwork(buffer, this.countRange);
    }
}

