/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.crafting;

import com.github.elenterius.biomancy.crafting.recipe.RecipeUtil;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class EssenceIngredient
extends AbstractIngredient {
    private final ItemStack itemStack;
    private final CompoundTag partialTag;
    private final NbtPredicate predicate;

    protected EssenceIngredient(ItemStack itemStack, CompoundTag partialTag) {
        super(Stream.of(new Ingredient.ItemValue(itemStack)));
        this.itemStack = itemStack;
        this.partialTag = partialTag;
        this.predicate = new NbtPredicate(partialTag);
    }

    public static EssenceIngredient of(EntityType<?> entityType) {
        return EssenceIngredient.of(entityType, 1);
    }

    public static EssenceIngredient of(EntityType<?> entityType, int tier) {
        if (tier < 1 || tier > 3) {
            throw new IllegalArgumentException("Cannot create a EssenceIngredient with invalid tier");
        }
        CompoundTag essenceTag = new CompoundTag();
        essenceTag.m_128359_("entity_type", EntityType.m_20613_(entityType).toString());
        CompoundTag partialTag = new CompoundTag();
        partialTag.m_128365_("essence_data", (Tag)essenceTag);
        partialTag.m_128405_("essence_tier", tier);
        ItemStack stack = EssenceItem.fromEntityType(entityType, tier);
        return new EssenceIngredient(stack, partialTag);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.itemStack.m_41720_() == stack.m_41720_() && this.predicate.m_57483_((Tag)stack.getShareTag());
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)).toString());
        json.add("item", (JsonElement)RecipeUtil.writeItemStack(this.itemStack));
        json.addProperty("predicate_tag", this.partialTag.toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<EssenceIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EssenceIngredient parse(JsonObject json) {
            ItemStack stack = RecipeUtil.readItemStack(json.getAsJsonObject("item"));
            CompoundTag tag = CraftingHelper.getNBT((JsonElement)json.get("predicate_tag"));
            return new EssenceIngredient(stack, tag);
        }

        public EssenceIngredient parse(FriendlyByteBuf buffer) {
            ItemStack stack = buffer.m_130267_();
            CompoundTag tag = buffer.m_130260_();
            return new EssenceIngredient(stack, Objects.requireNonNull(tag));
        }

        public void write(FriendlyByteBuf buffer, EssenceIngredient ingredient) {
            buffer.m_130055_(ingredient.itemStack);
            buffer.m_130079_(ingredient.partialTag);
        }
    }
}

