/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.tongue;

import com.github.elenterius.biomancy.block.base.SimpleSyncedBlockEntity;
import com.github.elenterius.biomancy.block.tongue.TongueBlock;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.inventory.ItemHandlerWrapper;
import com.github.elenterius.biomancy.inventory.SingleItemStackHandler;
import com.github.elenterius.biomancy.util.LevelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class TongueBlockEntity
extends SimpleSyncedBlockEntity
implements GeoBlockEntity {
    public static final String INVENTORY_TAG = "Inventory";
    public static final int ITEM_TRANSFER_AMOUNT = 3;
    public static final int DURATION = 24;
    public static final int DELAY = 12;
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("tongue.idle");
    protected static final RawAnimation STRETCH_ANIM = RawAnimation.begin().thenPlay("tongue.stretch");
    private final SingleItemStackHandler inventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int ticks;

    public TongueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TONGUE.get(), pos, state);
        this.inventory = new SingleItemStackHandler(){

            @Override
            public int getSlotLimit(int slot) {
                return 3;
            }

            @Override
            protected void onContentsChanged() {
                TongueBlockEntity.this.m_6596_();
            }
        };
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TongueBlockEntity entity) {
        entity.serverTick((ServerLevel)level, pos, state);
    }

    private void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        ++this.ticks;
        if (this.ticks % 24 == 0 && this.isHoldingItem()) {
            Direction facing = TongueBlock.getFacing(state);
            this.dropItems(level, pos, facing);
            return;
        }
        if (this.ticks % 36 == 0 && !this.isHoldingItem()) {
            Direction facing = TongueBlock.getFacing(state);
            BlockPos relativePos = pos.m_121945_(facing.m_122424_());
            if (level.m_46749_(relativePos)) {
                LevelUtil.getItemHandler(level, relativePos, Direction.DOWN).ifPresent(this::tryToExtractItems);
            }
            if (this.isHoldingItem()) {
                this.ticks = 0;
            }
        }
    }

    private void tryToExtractItems(IItemHandler itemHandler) {
        if (!this.inventory.isEmpty()) {
            return;
        }
        ItemHandlerWrapper handler = new ItemHandlerWrapper(itemHandler);
        ItemStack extractedStack = handler.extractItemAny(3, false);
        if (!extractedStack.m_41619_()) {
            this.inventory.insertItem(0, extractedStack, false);
            this.m_6596_();
            this.syncToClient();
        }
    }

    private void dropItems(ServerLevel level, BlockPos pos, Direction facing) {
        ItemStack stack = this.inventory.extractItem(0, 3, false);
        if (!stack.m_41619_()) {
            double x = (double)pos.m_123341_() + 0.5 - (double)facing.m_122429_() * 0.5 + (double)facing.m_122429_() * 0.6875;
            double y = (double)pos.m_123342_() + 0.0625;
            double z = (double)pos.m_123343_() + 0.5 - (double)facing.m_122431_() * 0.5 + (double)facing.m_122431_() * 0.6875;
            ItemEntity itemEntity = new ItemEntity((Level)level, x, y, z, stack);
            itemEntity.m_32060_();
            itemEntity.m_20334_(0.0, 0.0, 0.0);
            level.m_7967_((Entity)itemEntity);
            this.syncToClient();
        }
    }

    public ItemStack getHeldItem() {
        return this.inventory.getStack();
    }

    public boolean isHoldingItem() {
        return !this.inventory.isEmpty();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
    }

    @Override
    protected void saveForSyncToClient(CompoundTag tag) {
        tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
    }

    public void dropInventoryContents(Level level, BlockPos pos) {
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.inventory.extractItem(this.inventory.getMaxAmount(), false));
    }

    public void giveInventoryContentsTo(Level level, BlockPos pos, Player player) {
        ItemStack stack = this.inventory.extractItem(this.inventory.getMaxAmount(), false);
        if (!stack.m_41619_() && !player.m_36356_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    protected <T extends TongueBlockEntity> PlayState handleAnimationState(AnimationState<T> state) {
        boolean isStopped;
        AnimationController controller = state.getController();
        boolean bl = isStopped = controller.getAnimationState() == AnimationController.State.STOPPED;
        if (((TongueBlockEntity)state.getAnimatable()).isHoldingItem()) {
            controller.setAnimation(STRETCH_ANIM);
            if (!isStopped) {
                return PlayState.CONTINUE;
            }
        }
        if (isStopped) {
            controller.setAnimation(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::handleAnimationState)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

