/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.ownable;

import com.github.elenterius.biomancy.block.base.SimpleContainerBlockEntity;
import com.github.elenterius.biomancy.util.ownable.Ownable;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import com.github.elenterius.biomancy.util.permission.UserType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class OwnableContainerBlockEntity
extends SimpleContainerBlockEntity
implements Ownable,
IRestrictedInteraction {
    public static final int MAX_USERS = 10;
    private final HashMap<UUID, UserType> users = new HashMap(6);
    @Nullable
    private UUID ownerId;

    protected OwnableContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean canPlayerInteract(Player player) {
        return super.canPlayerInteract(player) && this.isActionAllowed(player, Actions.USE_BLOCK);
    }

    @Override
    public UserType getUserType(UUID userId) {
        if (this.isOwner(userId)) {
            return UserType.OWNER;
        }
        return this.users.getOrDefault(userId, UserType.NONE);
    }

    @Override
    public boolean setUserType(UUID userId, UserType userType) {
        if (this.users.size() >= 10 && !this.users.containsKey(userId)) {
            return false;
        }
        this.users.put(userId, userType);
        this.syncToClient();
        this.m_6596_();
        return true;
    }

    @Override
    public void removeUser(UUID userId) {
        if (this.users.containsKey(userId)) {
            this.users.remove(userId);
            this.syncToClient();
            this.m_6596_();
        }
    }

    @Override
    public Optional<UUID> getOptionalOwnerUUID() {
        return Optional.ofNullable(this.ownerId);
    }

    @Override
    public void setOwner(UUID userId) {
        this.ownerId = userId;
        this.syncToClient();
        this.m_6596_();
    }

    @Override
    public boolean hasOwner() {
        return this.ownerId != null;
    }

    @Override
    public boolean isOwner(UUID userId) {
        if (this.ownerId == null) {
            return false;
        }
        return userId.equals(this.ownerId);
    }

    @Override
    public void removeOwner() {
        this.ownerId = null;
        this.syncToClient();
        this.m_6596_();
    }

    protected void syncToClient() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.m_58900_();
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 2);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.saveForSyncToClient(tag);
        return tag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void saveForSyncToClient(CompoundTag tag) {
        if (this.ownerId != null) {
            tag.m_128362_("OwnerUUID", this.ownerId);
        }
        if (!this.users.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (Map.Entry<UUID, UserType> user : this.users.entrySet()) {
                CompoundTag userTag = new CompoundTag();
                userTag.m_128362_("UserUUID", user.getKey());
                user.getValue().serialize(userTag);
                listNBT.add((Object)userTag);
            }
            tag.m_128365_("UserList", (Tag)listNBT);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.ownerId = tag.m_128403_("OwnerUUID") ? tag.m_128342_("OwnerUUID") : null;
        this.users.clear();
        if (tag.m_128441_("UserList")) {
            ListTag nbtList = tag.m_128437_("UserList", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag userTag = nbtList.m_128728_(i);
                UUID userUUID = userTag.m_128342_("UserUUID");
                UserType authority = UserType.deserialize(userTag);
                this.users.put(userUUID, authority);
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.ownerId != null) {
            tag.m_128362_("OwnerUUID", this.ownerId);
        }
        if (!this.users.isEmpty()) {
            ListTag listNBT = new ListTag();
            for (Map.Entry<UUID, UserType> user : this.users.entrySet()) {
                CompoundTag userTag = new CompoundTag();
                userTag.m_128362_("UserUUID", user.getKey());
                user.getValue().serialize(userTag);
                listNBT.add((Object)userTag);
            }
            tag.m_128365_("UserList", (Tag)listNBT);
        }
    }
}

