/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.orifice;

import com.github.elenterius.biomancy.init.ModFluids;
import com.github.elenterius.biomancy.init.ModParticleTypes;
import com.github.elenterius.biomancy.init.ModPlantTypes;
import com.github.elenterius.biomancy.init.ModPotions;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.util.EnhancedIntegerProperty;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class OrificeBlock
extends Block
implements BucketPickup {
    public static final EnhancedIntegerProperty AGE = EnhancedIntegerProperty.wrap(BlockStateProperties.f_61406_);

    public OrificeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE.get(), (Comparable)Integer.valueOf(AGE.getMin())));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE.get()});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_121945_(facing));
        return type == ModPlantTypes.PRIMAL_FLESH;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (random.m_188501_() < 0.33f) {
            BlockPos posBelow;
            int age = AGE.getValue(state);
            if (age < AGE.getMax()) {
                level.m_7731_(pos, AGE.addValue(state, 1), 2);
            } else if (random.m_188501_() < 0.5f && FallingBlock.m_53241_((BlockState)level.m_8055_(posBelow = pos.m_7495_())) && pos.m_123342_() >= level.m_141937_()) {
                level.m_7731_(pos, AGE.setValue(state, AGE.getMin()), 2);
                float x = (float)random.m_216332_(-6, 6) / 16.0f;
                float z = (float)random.m_216332_(-6, 6) / 16.0f;
                ModProjectiles.FALLING_ACID_BLOB.shoot((Level)level, Vec3.m_82539_((Vec3i)pos).m_82520_((double)x, 0.0, (double)z), Vec3.m_82539_((Vec3i)posBelow).m_82520_((double)x, 0.0, (double)z));
            }
        }
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        if (AGE.getValue(state).intValue() == AGE.getMax()) {
            level.m_7731_(pos, AGE.setValue(state, AGE.getMin()), 2);
            return new ItemStack((ItemLike)((ForgeFlowingFluid)ModFluids.ACID.get()).m_6859_());
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_150930_(Items.f_42590_)) {
            return InteractionResult.PASS;
        }
        if (AGE.getValue(state).intValue() == AGE.getMin()) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)((Potion)ModPotions.GASTRIC_JUICE.get()))));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            level.m_7731_(pos, AGE.addValue(state, -1), 2);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public Optional<SoundEvent> m_142298_() {
        return ((ForgeFlowingFluid)ModFluids.ACID.get()).m_142520_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(5) == 0 && AGE.getValue(state).intValue() == AGE.getMax()) {
            Direction direction = Direction.m_235672_((RandomSource)random);
            if (direction == Direction.UP) {
                return;
            }
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = level.m_8055_(neighborPos);
            if (!state.m_60815_() || !neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_())) {
                double x = direction.m_122429_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.6;
                double y = direction.m_122430_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.6;
                double z = direction.m_122431_() == 0 ? random.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.6;
                level.m_7106_((ParticleOptions)ModParticleTypes.DRIPPING_ACID.get(), (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, 0.0, 0.0, 0.0);
            }
        }
    }
}

