/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.mawhopper;

import com.github.elenterius.biomancy.block.mawhopper.MawHopperBlock;
import com.github.elenterius.biomancy.block.property.DirectedConnection;
import com.github.elenterius.biomancy.block.property.VertexType;
import com.github.elenterius.biomancy.util.IntermediaryKeyCache;
import com.github.elenterius.biomancy.util.VoxelShapeUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class MawHopperShapes {
    private static final IntermediaryKeyCache<BlockState, VoxelShape> CACHE = new IntermediaryKeyCache(MawHopperShapes::computeKey);

    private MawHopperShapes() {
    }

    static void computePossibleShapes(List<BlockState> possibleStates) {
        possibleStates.forEach(possibleState -> CACHE.computeIfAbsent((BlockState)possibleState, MawHopperShapes::computeShape));
    }

    private static Integer computeKey(BlockState blockState) {
        return Objects.hash(new Object[]{MawHopperBlock.getConnection(blockState), MawHopperBlock.getVertexType(blockState)});
    }

    private static VoxelShape computeShape(BlockState blockState) {
        DirectedConnection connection = MawHopperBlock.getConnection(blockState);
        VertexType vertexType = MawHopperBlock.getVertexType(blockState);
        return MawHopperShapes.computeVoxelShape(connection, vertexType);
    }

    private static VoxelShape computeVoxelShape(DirectedConnection connection, VertexType vertexType) {
        if (vertexType == VertexType.SOURCE) {
            Direction direction = connection.ingoing;
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 0.0, 13.0, 13.0, 16.0, 16.0, 16.0), VoxelShapeUtil.createXZRotatedTowards(direction, 0.0, 13.0, 0.0, 16.0, 16.0, 3.0), VoxelShapeUtil.createXZRotatedTowards(direction, 13.0, 13.0, 3.0, 16.0, 16.0, 13.0), VoxelShapeUtil.createXZRotatedTowards(direction, 0.0, 13.0, 3.0, 3.0, 16.0, 13.0), VoxelShapeUtil.createXZRotatedTowards(direction, 3.0, 10.0, 3.0, 13.0, 13.0, 13.0), VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 6.0, 5.0, 11.0, 10.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 6.0, 0.0, 6.0, 10.0, 6.0, 10.0)).reduce((a, b) -> Shapes.m_83113_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
        }
        if (connection.isStraight()) {
            Direction direction = connection.ingoing;
            return Stream.of(VoxelShapeUtil.createXZRotatedTowards(direction, 5.0, 12.0, 5.0, 11.0, 16.0, 11.0), VoxelShapeUtil.createXZRotatedTowards(direction, 6.0, 0.0, 6.0, 10.0, 12.0, 10.0)).reduce((a, b) -> Shapes.m_83113_((VoxelShape)a, (VoxelShape)b, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83144_());
        }
        VoxelShape headShape = Shapes.m_83113_((VoxelShape)VoxelShapeUtil.createXZRotatedTowards(connection.ingoing, 5.0, 12.0, 5.0, 11.0, 16.0, 11.0), (VoxelShape)VoxelShapeUtil.createXZRotatedTowards(connection.ingoing, 6.0, 6.0, 6.0, 10.0, 12.0, 10.0), (BooleanOp)BooleanOp.f_82695_);
        VoxelShape tailShape = VoxelShapeUtil.createXZRotatedTowards(connection.outgoing.m_122424_(), 6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
        return Shapes.m_83113_((VoxelShape)headShape, (VoxelShape)tailShape, (BooleanOp)BooleanOp.f_82695_);
    }

    static VoxelShape getShape(BlockState blockState) {
        return CACHE.get(blockState);
    }
}

