/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.fleshkinchest;

import com.github.elenterius.biomancy.block.fleshkinchest.FleshkinChestBlockEntity;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.item.EssenceItem;
import com.github.elenterius.biomancy.styles.TextStyles;
import com.github.elenterius.biomancy.util.ComponentUtil;
import com.github.elenterius.biomancy.util.ownable.OwnableEntityBlock;
import com.github.elenterius.biomancy.util.permission.Actions;
import com.github.elenterius.biomancy.util.permission.IRestrictedInteraction;
import com.github.elenterius.biomancy.util.permission.UserType;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class FleshkinChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
OwnableEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_NORTH_OR_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)13.0, (double)15.0);
    public static final VoxelShape SHAPE_WEST_OR_EAST = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0);
    private final float destroySpeed;

    public FleshkinChestBlock(BlockBehaviour.Properties properties, float destroySpeed) {
        super(properties.m_155954_(-1.0f).m_155956_(1200.0f));
        this.destroySpeed = destroySpeed;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemStack createItemStackForCreativeTab() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41714_((Component)ComponentUtil.literal("[TEST/other_owner] ").m_7220_(stack.m_41786_()));
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("OwnerUUID", Util.f_137441_);
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.FLESHKIN_CHEST.get()), (CompoundTag)tag);
        return stack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FleshkinChestBlockEntity) {
            FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                chest.setCustomName(stack.m_41786_());
            }
            OwnableEntityBlock.setBlockEntityOwner(level, chest, placer, stack);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.FLESHKIN_CHEST.get()).m_155264_(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED))) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return Boolean.TRUE.equals(state.m_61143_((Property)WATERLOGGED)) ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos) && (blockEntity = level.m_7702_(pos)) instanceof FleshkinChestBlockEntity) {
                FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
                if (chest.canPlayerInteract(player)) {
                    ItemStack stack = player.m_21120_(hand);
                    Item item = stack.m_41720_();
                    if (item instanceof EssenceItem) {
                        EssenceItem essenceItem = (EssenceItem)item;
                        if (chest.isActionAllowed(player, Actions.CONFIGURE)) {
                            boolean success = essenceItem.getEntityUUID(stack).map(chest::addUser).orElse(false);
                            if (success) {
                                stack.m_41774_(1);
                                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_EAT.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                                return InteractionResult.SUCCESS;
                            }
                        }
                        level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                        return InteractionResult.CONSUME;
                    }
                    MenuProvider menuProvider = this.m_7246_(state, level, pos);
                    if (menuProvider != null) {
                        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)menuProvider, buffer -> buffer.m_130064_(pos));
                        return InteractionResult.SUCCESS;
                    }
                } else if (level.f_46441_.m_188501_() < 0.6f) {
                    chest.attack((Direction)state.m_61143_((Property)FACING), (LivingEntity)player);
                    level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_CHEST_BITE_ATTACK.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                } else {
                    int particleCount = level.f_46441_.m_216339_(1, 3);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, particleCount, 0.5, 0.25, 0.5, 0.0);
                    level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.FLESHKIN_NO.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof FleshkinChestBlockEntity) {
            FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
            chest.dropContainerContents(level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        IRestrictedInteraction interaction;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IRestrictedInteraction && (interaction = (IRestrictedInteraction)blockEntity).isActionAllowed(player, Actions.DESTROY_BLOCK)) {
            int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
            return player.getDigSpeed(state, pos) / this.destroySpeed / (float)i;
        }
        return 0.0f;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FleshkinChestBlockEntity) {
            FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
            chest.m_187476_(stack);
        }
        return stack;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FleshkinChestBlockEntity) {
            FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
            return ItemHandlerHelper.calcRedstoneFromInventory(chest.getInventory());
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NORTH_OR_SOUTH;
            case Direction.WEST, Direction.EAST -> SHAPE_WEST_OR_EAST;
            default -> Shapes.m_83144_();
        };
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        OwnableEntityBlock.appendUserListToTooltip(stack, tooltip);
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        CompoundTag tag = BlockItem.m_186336_((ItemStack)stack);
        if (tag != null) {
            tooltip.add(ComponentUtil.emptyLine());
            if (this.isAuthorized(Minecraft.m_91087_().f_91074_.m_20148_(), tag)) {
                CompoundTag inventoryTag = tag.m_128469_("Inventory");
                if (!inventoryTag.m_128456_() && inventoryTag.m_128425_("Items", 9)) {
                    int size = inventoryTag.m_128441_("Size") ? inventoryTag.m_128451_("Size") : 42;
                    NonNullList itemList = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
                    ContainerHelper.m_18980_((CompoundTag)inventoryTag, (NonNullList)itemList);
                    int count = 0;
                    int totalCount = 0;
                    for (ItemStack storedStack : itemList) {
                        if (storedStack.m_41619_()) continue;
                        ++totalCount;
                        if (count >= 5) continue;
                        ++count;
                        MutableComponent textComponent = storedStack.m_41786_().m_6881_();
                        textComponent.m_130946_(" x").m_130946_(String.valueOf(storedStack.m_41613_())).m_130940_(ChatFormatting.GRAY);
                        tooltip.add((Component)textComponent);
                    }
                    if (totalCount - count > 0) {
                        tooltip.add((Component)ComponentUtil.translatable("container.shulkerBox.more", totalCount - count).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                    }
                    tooltip.add(ComponentUtil.emptyLine());
                    tooltip.add((Component)ComponentUtil.literal(String.format("%d/%d ", totalCount, 42)).m_7220_((Component)ComponentUtil.translatable("tooltip.biomancy.slots")).m_130940_(ChatFormatting.GRAY));
                }
            } else {
                tooltip.add((Component)ComponentUtil.literal("Who are you? I don't like you!").m_130948_(TextStyles.PRIMORDIAL_RUNES_GRAY));
            }
        }
    }

    private boolean isAuthorized(UUID uuid, CompoundTag tag) {
        if (tag.m_128403_("OwnerUUID") && tag.m_128342_("OwnerUUID").equals(uuid)) {
            return true;
        }
        if (tag.m_128441_("UserList")) {
            ListTag nbtList = tag.m_128437_("UserList", 10);
            for (int i = 0; i < nbtList.size(); ++i) {
                CompoundTag userTag = nbtList.m_128728_(i);
                UUID userUUID = userTag.m_128342_("UserUUID");
                UserType authority = UserType.deserialize(userTag);
                if (!userUUID.equals(uuid) || !authority.isUserLevel()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FleshkinChestBlockEntity) {
            FleshkinChestBlockEntity chest = (FleshkinChestBlockEntity)blockEntity;
            chest.recheckOpen();
        }
    }
}

