/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.decomposer;

import com.github.elenterius.biomancy.api.nutrients.FuelHandler;
import com.github.elenterius.biomancy.api.nutrients.FuelHandlerImpl;
import com.github.elenterius.biomancy.block.base.MachineBlock;
import com.github.elenterius.biomancy.block.base.MachineBlockEntity;
import com.github.elenterius.biomancy.block.decomposer.DecomposerStateData;
import com.github.elenterius.biomancy.client.util.ClientLoopingSoundHelper;
import com.github.elenterius.biomancy.crafting.VariableOutput;
import com.github.elenterius.biomancy.crafting.recipe.DecomposingRecipe;
import com.github.elenterius.biomancy.crafting.recipe.SimpleRecipeType;
import com.github.elenterius.biomancy.init.ModBlockEntities;
import com.github.elenterius.biomancy.init.ModCapabilities;
import com.github.elenterius.biomancy.init.ModRecipes;
import com.github.elenterius.biomancy.init.ModSoundEvents;
import com.github.elenterius.biomancy.inventory.InventoryHandler;
import com.github.elenterius.biomancy.inventory.InventoryHandlers;
import com.github.elenterius.biomancy.inventory.ItemHandlerUtil;
import com.github.elenterius.biomancy.menu.DecomposerMenu;
import com.github.elenterius.biomancy.styles.TextComponentUtil;
import com.github.elenterius.biomancy.util.ILoopingSoundHelper;
import com.github.elenterius.biomancy.util.SoundUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DecomposerBlockEntity
extends MachineBlockEntity<DecomposingRecipe, DecomposerStateData>
implements MenuProvider,
GeoBlockEntity {
    public static final int FUEL_SLOTS = 1;
    public static final int INPUT_SLOTS = 1;
    public static final int OUTPUT_SLOTS = 6;
    public static final int MAX_FUEL = 1000;
    public static final RegistryObject<SimpleRecipeType.ItemStackRecipeType<DecomposingRecipe>> RECIPE_TYPE = ModRecipes.DECOMPOSING_RECIPE_TYPE;
    protected static final RawAnimation WORKING_ANIM = RawAnimation.begin().thenLoop("decomposer.working");
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("decomposer.idle");
    private final DecomposerStateData stateData;
    private final FuelHandlerImpl fuelHandler;
    private final InventoryHandler<?> fuelInventory;
    private final InventoryHandler<?> inputInventory;
    private final InventoryHandler<?> outputInventory;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private ILoopingSoundHelper loopingSoundHelper = ILoopingSoundHelper.NULL;
    @Nullable
    private DecomposerRecipeResult computedRecipeResult;
    private LazyOptional<IFluidHandler> optionalFluidConsumer;

    public DecomposerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.DECOMPOSER.get(), pos, state);
        this.inputInventory = InventoryHandlers.standard(1, () -> this.onInventoryChanged());
        this.outputInventory = InventoryHandlers.denyInput(6, () -> this.onInventoryChanged());
        this.fuelInventory = InventoryHandlers.filterFuel(1, () -> this.onInventoryChanged());
        this.fuelHandler = FuelHandlerImpl.createNutrientFuelHandler(1000, () -> this.onInventoryChanged());
        this.stateData = new DecomposerStateData(this.fuelHandler);
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    public void onLoad() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper = new ClientLoopingSoundHelper();
        }
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return TextComponentUtil.getTranslationText("container", "decomposer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return DecomposerMenu.createServerMenu(containerId, playerInventory, this);
    }

    @Override
    public DecomposerStateData getStateData() {
        return this.stateData;
    }

    @Override
    public InventoryHandler<?> getInputInventory() {
        return this.inputInventory;
    }

    public InventoryHandler<?> getFuelInventory() {
        return this.fuelInventory;
    }

    public InventoryHandler<?> getOutputInventory() {
        return this.outputInventory;
    }

    @Override
    protected FuelHandler getFuelHandler() {
        return this.fuelHandler;
    }

    @Override
    public ItemStack getStackInFuelSlot() {
        return this.fuelInventory.getStackInSlot(0);
    }

    @Override
    public void setStackInFuelSlot(ItemStack stack) {
        this.fuelInventory.setStackInSlot(0, stack);
    }

    @Override
    protected boolean doesRecipeResultFitIntoOutputInv(DecomposingRecipe craftingGoal, ItemStack ignored) {
        DecomposerRecipeResult precomputedResult = this.getComputedRecipeResult(craftingGoal);
        return ItemHandlerUtil.doAllItemsFit(this.outputInventory.getRaw(), precomputedResult.items);
    }

    DecomposerRecipeResult getComputedRecipeResult(DecomposingRecipe craftingGoal) {
        if (this.computedRecipeResult == null || !this.computedRecipeResult.recipeId.equals((Object)craftingGoal.m_6423_())) {
            return DecomposerRecipeResult.computeRecipeResult(craftingGoal, this.f_58857_.f_46441_.m_188502_());
        }
        return this.computedRecipeResult;
    }

    @Override
    @Nullable
    protected DecomposingRecipe resolveRecipeFromInput(Level level) {
        return ((SimpleRecipeType.ItemStackRecipeType)RECIPE_TYPE.get()).getRecipeFromContainer(level, (Container)this.inputInventory.getRecipeWrapper()).orElse(null);
    }

    @Override
    protected boolean doesRecipeMatchInput(DecomposingRecipe recipeToTest, Level level) {
        return recipeToTest.m_5818_((Container)this.inputInventory.getRecipeWrapper(), level);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.stateData.serialize(tag);
        if (this.computedRecipeResult != null) {
            tag.m_128365_("ComputedRecipeResult", (Tag)this.computedRecipeResult.serialize());
        }
        tag.m_128365_("Fuel", (Tag)this.fuelHandler.serializeNBT());
        tag.m_128365_("FuelSlots", (Tag)this.fuelInventory.serializeNBT());
        tag.m_128365_("InputSlots", (Tag)this.inputInventory.serializeNBT());
        tag.m_128365_("OutputSlots", (Tag)this.outputInventory.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.stateData.deserialize(tag);
        if (this.f_58857_ != null && tag.m_128441_("ComputedRecipeResult")) {
            this.computedRecipeResult = DecomposerRecipeResult.deserialize(tag.m_128469_("ComputedRecipeResult"), this.f_58857_.m_7465_());
        }
        this.fuelHandler.deserializeNBT(tag.m_128469_("Fuel"));
        this.fuelInventory.deserializeNBT(tag.m_128469_("FuelSlots"));
        this.inputInventory.deserializeNBT(tag.m_128469_("InputSlots"));
        this.outputInventory.deserializeNBT(tag.m_128469_("OutputSlots"));
    }

    @Override
    public void dropAllInvContents(Level level, BlockPos pos) {
        ItemHandlerUtil.dropContents(level, pos, this.fuelInventory);
        ItemHandlerUtil.dropContents(level, pos, this.inputInventory);
        ItemHandlerUtil.dropContents(level, pos, this.outputInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.f_58859_) {
            return super.getCapability(cap, side);
        }
        if (cap == ModCapabilities.ITEM_HANDLER) {
            if (side == null || side == Direction.DOWN) {
                return this.outputInventory.getLazyOptional().cast();
            }
            if (side == Direction.UP) {
                return this.inputInventory.getLazyOptional().cast();
            }
            return this.fuelInventory.getLazyOptional().cast();
        }
        if (cap == ModCapabilities.FLUID_HANDLER) {
            return this.optionalFluidConsumer.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fuelInventory.invalidate();
        this.inputInventory.invalidate();
        this.outputInventory.invalidate();
        this.optionalFluidConsumer.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.fuelInventory.revive();
        this.inputInventory.revive();
        this.outputInventory.revive();
        this.optionalFluidConsumer = LazyOptional.of(this.fuelHandler::getFluidConsumer);
    }

    @Override
    protected boolean craftRecipe(DecomposingRecipe recipeToCraft, Level level) {
        DecomposerRecipeResult precomputedResult = this.getComputedRecipeResult(recipeToCraft);
        if (!ItemHandlerUtil.doAllItemsFit(this.outputInventory.getRaw(), precomputedResult.items)) {
            return false;
        }
        this.inputInventory.extractItem(0, recipeToCraft.getIngredientQuantity().count(), false);
        for (ItemStack stack : precomputedResult.items) {
            ItemHandlerUtil.insertItem(this.outputInventory.getRaw(), stack);
        }
        SoundUtil.broadcastBlockSound((ServerLevel)level, this.m_58899_(), ModSoundEvents.DECOMPOSER_CRAFTING_COMPLETED);
        this.m_6596_();
        return true;
    }

    private <T extends DecomposerBlockEntity> void onSoundKeyframe(SoundKeyframeEvent<T> event) {
        if (event.getKeyframeData().getSound().equals("eat") && this.f_58857_ != null && !this.m_58901_()) {
            SoundUtil.clientPlayBlockSound(this.f_58857_, this.m_58899_(), ModSoundEvents.DECOMPOSER_EAT);
        }
    }

    private <T extends DecomposerBlockEntity> PlayState handleAnimationState(AnimationState<T> event) {
        Boolean isCrafting = (Boolean)((DecomposerBlockEntity)event.getAnimatable()).m_58900_().m_61143_((Property)MachineBlock.CRAFTING);
        if (Boolean.TRUE.equals(isCrafting)) {
            event.getController().setAnimation(WORKING_ANIM);
            this.loopingSoundHelper.startLoop(this, (SoundEvent)ModSoundEvents.DECOMPOSER_CRAFTING.get(), 0.65f);
        } else {
            event.getController().setAnimation(IDLE_ANIM);
            this.loopingSoundHelper.stopLoop();
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 10, this::handleAnimationState);
        controller.setSoundKeyframeHandler(this::onSoundKeyframe);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7651_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.loopingSoundHelper.clear();
        }
        super.m_7651_();
    }

    record DecomposerRecipeResult(ResourceLocation recipeId, int seed, List<ItemStack> items) {
        @Nullable
        public static DecomposerRecipeResult deserialize(CompoundTag tag, RecipeManager recipeManager) {
            String id = tag.m_128461_("recipeId");
            ResourceLocation recipeId = ResourceLocation.m_135820_((String)id);
            if (recipeId == null) {
                return null;
            }
            Recipe recipe = (Recipe)recipeManager.m_44054_((RecipeType)RECIPE_TYPE.get()).get(recipeId);
            if (recipe instanceof DecomposingRecipe) {
                DecomposingRecipe decomposingRecipe = (DecomposingRecipe)recipe;
                return DecomposerRecipeResult.computeRecipeResult(decomposingRecipe, tag.m_128451_("seed"));
            }
            return null;
        }

        public static DecomposerRecipeResult computeRecipeResult(DecomposingRecipe recipe, int seed) {
            RandomSource random = RandomSource.m_216335_((long)seed);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (VariableOutput output : recipe.getOutputs()) {
                ItemStack stack = output.getItemStack(random);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
            return new DecomposerRecipeResult(recipe.m_6423_(), seed, items);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("recipeId", this.recipeId().toString());
            tag.m_128405_("seed", this.seed);
            return tag;
        }
    }
}

