/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.block.bloom;

import com.github.elenterius.biomancy.block.base.WaterloggedFacingBlock;
import com.github.elenterius.biomancy.block.bloom.BloomShapes;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.ModPlantTypes;
import com.github.elenterius.biomancy.init.ModProjectiles;
import com.github.elenterius.biomancy.util.EnhancedIntegerProperty;
import com.github.elenterius.biomancy.util.VectorUtil;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BloomBlock
extends WaterloggedFacingBlock
implements IPlantable {
    public static final EnhancedIntegerProperty AGE = EnhancedIntegerProperty.wrap(BlockStateProperties.f_61409_);
    protected static final int AIM_DISTANCE = 8;

    public BloomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE.get(), (Comparable)Integer.valueOf(AGE.getMin())));
        BloomShapes.computePossibleShapes((List<BlockState>)this.f_49792_.m_61056_());
    }

    public static int getAge(BlockState state) {
        return AGE.getValue(state);
    }

    public static int getStage(BlockState state) {
        return BloomBlock.getStageFromAge(AGE.getValue(state));
    }

    public static int getStageFromAge(int age) {
        int[] stages = new int[]{0, 0, 1, 1, 2, 2, 3, 4};
        age = Mth.m_14045_((int)age, (int)0, (int)7);
        return stages[age];
    }

    private static int getGrowthSpeed(ServerLevel level, BlockPos pos) {
        int veins = PrimordialEcosystem.countMalignantVeinsAroundPos(level, pos);
        int maxVeins = 26;
        return Math.max(maxVeins - veins, 0) + 1;
    }

    public static int getLightEmission(BlockState state) {
        int age = BloomBlock.getAge(state);
        if (age < 6) {
            return 0;
        }
        if (age < 7) {
            return 10;
        }
        return 12;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE.get()});
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos, Direction direction) {
        boolean isWaterlogged = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    public boolean hasUnobstructedAim(BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasUnobstructedAim(level, pos, pos.m_5484_(direction, 8));
    }

    public boolean hasUnobstructedAim(BlockGetter level, BlockPos origin, BlockPos target) {
        return level.m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)origin), Vec3.m_82512_((Vec3i)target), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        Direction direction = BloomBlock.getFacing(state);
        BlockPos relativePos = pos.m_121945_(direction);
        BlockState relativeState = level.m_8055_(relativePos);
        if (relativeState.m_280296_() || !relativeState.m_60812_((BlockGetter)level, relativePos).m_83281_()) {
            return;
        }
        int age = AGE.getValue(state);
        if (age < AGE.getMax()) {
            int growthSpeed = age < AGE.getMax() - 1 ? BloomBlock.getGrowthSpeed(level, pos) : 1;
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(growthSpeed) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, AGE.addValue(state, 1), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_7731_(pos, AGE.setValue(state, AGE.getMin()), 2);
            int range = 6;
            Vec3i plane = VectorUtil.axisAlignedPlane3i(direction);
            int offsetX = plane.m_123341_() * random.m_216332_(-range, range);
            int offsetY = plane.m_123342_() * random.m_216332_(-range, range);
            int offsetZ = plane.m_123343_() * random.m_216332_(-range, range);
            BlockPos target = pos.m_5484_(direction, 8).m_7918_(offsetX, offsetY, offsetZ);
            ModProjectiles.BLOOMBERRY.shoot((Level)level, Vec3.m_82512_((Vec3i)pos), Vec3.m_82512_((Vec3i)target));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int age = AGE.getValue(state);
        if (age > 5 && player.m_21120_(hand).m_41619_()) {
            if (!level.f_46443_) {
                int count = 1 + (age > 6 ? level.f_46441_.m_188503_(2) : 0);
                BloomBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.BLOOMBERRY.get(), count));
                player.m_6469_(level.m_269111_().m_269555_(), 1.0f);
                level.m_5594_(null, pos, SoundEvents.f_144088_, SoundSource.BLOCKS, 1.0f, 0.5f + level.f_46441_.m_188501_() * 0.4f);
                BlockState blockState = AGE.setValue(state, AGE.getMin());
                level.m_7731_(pos, blockState, 2);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return ModPlantTypes.PRIMAL_FLESH;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean mayPlaceOn(BlockGetter level, BlockPos pos, BlockState state, Direction facing) {
        return state.canSustainPlant(level, pos, facing, (IPlantable)this);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return this.mayPlaceOn((BlockGetter)level, blockPos, level.m_8055_(blockPos), direction);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BloomShapes.getBoundingShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.f_60443_ ? BloomShapes.getCollisionShape(state) : Shapes.m_83040_();
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }
}

