/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute;

import com.github.elenterius.biomancy.api.tribute.MobEffectTribute;
import com.github.elenterius.biomancy.api.tribute.SimpleTribute;
import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.init.ModItems;
import com.github.elenterius.biomancy.init.tags.ModItemTags;
import com.github.elenterius.biomancy.util.SaturatedMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class Tributes {
    private static final Map<Item, Tribute> TRIBUTES = new HashMap<Item, Tribute>();
    private static final List<FuzzyTribute> FUZZY_TRIBUTES = new ArrayList<FuzzyTribute>();
    public static final Tribute WRONG_ITEM = SimpleTribute.builder().successModifier(-99).diseaseModifier(5).hostileModifier(20).build();
    public static final Tribute RAW_MEAT_TAG = Tributes.registerFuzzy(stack -> stack.m_204117_(ModItemTags.RAW_MEATS), SimpleTribute.builder().biomass(20).successModifier(16).diseaseModifier(5).hostileModifier(-5).build());
    public static final Tribute COOKED_MEAT_TAG = Tributes.registerFuzzy(stack -> stack.m_204117_(ModItemTags.COOKED_MEATS), SimpleTribute.builder().successModifier(-999).hostileModifier(1).build());
    public static final Tribute BONE_TAG = Tributes.registerFuzzy(stack -> stack.m_204117_(Tags.Items.BONES), SimpleTribute.builder().successModifier(3).diseaseModifier(-5).build());
    public static final Tribute FANG_TAG = Tributes.registerFuzzy(stack -> stack.m_204117_(ModItemTags.FANGS), SimpleTribute.builder().successModifier(8).hostileModifier(5).build());
    public static final Tribute CLAW_TAG = Tributes.registerFuzzy(stack -> stack.m_204117_(ModItemTags.CLAWS), SimpleTribute.builder().successModifier(8).hostileModifier(5).build());

    private Tributes() {
    }

    public static Tribute register(Item item, Tribute tribute) {
        TRIBUTES.put(item, tribute);
        return tribute;
    }

    public static Tribute registerFuzzy(Predicate<ItemStack> predicate, Tribute tribute) {
        FUZZY_TRIBUTES.add(new FuzzyTribute(predicate, tribute));
        return tribute;
    }

    public static Tribute getTribute(ItemStack stack) {
        Tribute mobEffectTribute = MobEffectTribute.from(stack);
        Tribute tribute = Tributes.findExistingTribute(stack);
        if (mobEffectTribute.isEmpty() && tribute.isEmpty()) {
            return WRONG_ITEM;
        }
        return Tributes.combineTributes(tribute, mobEffectTribute);
    }

    private static Tribute findExistingTribute(ItemStack stack) {
        if (stack.m_41619_()) {
            return Tribute.EMPTY;
        }
        Tribute foundTribute = TRIBUTES.get(stack.m_41720_());
        if (foundTribute != null) {
            return foundTribute;
        }
        for (FuzzyTribute fuzzyTribute : FUZZY_TRIBUTES) {
            if (!fuzzyTribute.predicate().test(stack)) continue;
            return fuzzyTribute.tribute();
        }
        return Tribute.EMPTY;
    }

    public static Tribute combineTributes(Tribute a, Tribute b) {
        return new SimpleTribute(SaturatedMath.add(a.biomass(), b.biomass()), SaturatedMath.add(a.lifeEnergy(), b.lifeEnergy()), SaturatedMath.add(a.successModifier(), b.successModifier()), SaturatedMath.add(a.diseaseModifier(), b.diseaseModifier()), SaturatedMath.add(a.hostileModifier(), b.hostileModifier()), SaturatedMath.add(a.anomalyModifier(), b.anomalyModifier()));
    }

    static {
        Tributes.register((Item)ModItems.CREATOR_MIX.get(), SimpleTribute.builder().biomass(20).lifeEnergy(20).successModifier(19).diseaseModifier(6).hostileModifier(-12).build());
        Tributes.register((Item)ModItems.PRIMORDIAL_CORE.get(), SimpleTribute.builder().biomass(80).successModifier(64).anomalyModifier(100).diseaseModifier(50).build());
        Tributes.register((Item)ModItems.LIVING_FLESH.get(), SimpleTribute.builder().biomass(10).lifeEnergy(10).successModifier(40).anomalyModifier(55).build());
        Tributes.register((Item)ModItems.BLOOMBERRY.get(), SimpleTribute.builder().successModifier(10).lifeEnergy(20).anomalyModifier(20).build());
        Tributes.register(Items.f_42436_, SimpleTribute.builder().successModifier(10).hostileModifier(-100).build());
        Tributes.register(Items.f_42437_, SimpleTribute.builder().lifeEnergy(15).successModifier(40).hostileModifier(-200).build());
        Tributes.register(Items.f_42502_, SimpleTribute.builder().hostileModifier(-80).diseaseModifier(10).build());
        Tributes.register(Items.f_42455_, SimpleTribute.builder().hostileModifier(-2).diseaseModifier(-4).build());
        Tributes.register(Items.f_42787_, SimpleTribute.builder().successModifier(2).hostileModifier(-10).diseaseModifier(-2).build());
        Tributes.register((Item)ModItems.HEALING_ADDITIVE.get(), SimpleTribute.builder().lifeEnergy(55).successModifier(1).diseaseModifier(-5).hostileModifier(-10).build());
        Tributes.register((Item)ModItems.REGENERATIVE_FLUID.get(), SimpleTribute.builder().lifeEnergy(5).hostileModifier(-1).build());
        Tributes.register((Item)ModItems.WITHERING_OOZE.get(), SimpleTribute.builder().biomass(-5).successModifier(-1).diseaseModifier(1).build());
        Tributes.register((Item)ModItems.DECAYING_ADDITIVE.get(), SimpleTribute.builder().biomass(-20).successModifier(-5).diseaseModifier(5).build());
        Tributes.register((Item)ModItems.ORGANIC_COMPOUND.get(), SimpleTribute.builder().successModifier(10).build());
        Tributes.register((Item)ModItems.EXOTIC_COMPOUND.get(), SimpleTribute.builder().successModifier(5).anomalyModifier(20).build());
        Tributes.register((Item)ModItems.GENETIC_COMPOUND.get(), SimpleTribute.builder().successModifier(1).diseaseModifier(-10).build());
        Tributes.register((Item)ModItems.FRENZY_SERUM.get(), SimpleTribute.builder().hostileModifier(1000).anomalyModifier(10).build());
        Tributes.register((Item)ModItems.ABSORPTION_BOOST.get(), SimpleTribute.builder().lifeEnergy(60).build());
        Tributes.register((Item)ModItems.REJUVENATION_SERUM.get(), SimpleTribute.builder().lifeEnergy(60).build());
        Tributes.register((Item)ModItems.CLEANSING_SERUM.get(), SimpleTribute.builder().lifeEnergy(-20).diseaseModifier(-120).build());
        Tributes.register(Items.f_42583_, SimpleTribute.builder().biomass(10).successModifier(-10).diseaseModifier(20).build());
        Tributes.register((Item)ModItems.MOB_SINEW.get(), SimpleTribute.builder().biomass(5).successModifier(2).hostileModifier(-2).build());
        Tributes.register((Item)ModItems.FLESH_BITS.get(), SimpleTribute.builder().biomass(5).successModifier(2).hostileModifier(-2).build());
        Tributes.register(Items.f_42648_, SimpleTribute.builder().successModifier(1000).hostileModifier(-50).anomalyModifier(50).build());
        Tributes.register(Items.f_42591_, SimpleTribute.builder().successModifier(10).diseaseModifier(10).hostileModifier(-5).build());
        Tributes.register(Items.f_42592_, SimpleTribute.builder().successModifier(-10).hostileModifier(-10).build());
        Tributes.register((Item)ModItems.TOXIN_GLAND.get(), SimpleTribute.builder().successModifier(-5).diseaseModifier(50).build());
        Tributes.register((Item)ModItems.VOLATILE_GLAND.get(), SimpleTribute.builder().successModifier(-5).diseaseModifier(20).build());
        Tributes.register((Item)ModItems.GENERIC_MOB_GLAND.get(), SimpleTribute.builder().diseaseModifier(-5).hostileModifier(-20).build());
        Tributes.register(Items.f_42500_, SimpleTribute.builder().successModifier(3).diseaseModifier(-10).build());
        Tributes.register(Items.f_42499_, SimpleTribute.builder().successModifier(1).diseaseModifier(-1).build());
        Tributes.register((Item)ModItems.MOB_MARROW.get(), SimpleTribute.builder().successModifier(5).diseaseModifier(-20).hostileModifier(-10).build());
        Tributes.register((Item)ModItems.WITHERED_MOB_MARROW.get(), SimpleTribute.builder().successModifier(-30).diseaseModifier(-40).build());
        Tributes.register((Item)ModItems.MOB_FANG.get(), SimpleTribute.builder().successModifier(8).hostileModifier(5).build());
        Tributes.register((Item)ModItems.MOB_CLAW.get(), SimpleTribute.builder().successModifier(8).hostileModifier(5).build());
        Tributes.register(Items.f_42584_, SimpleTribute.builder().hostileModifier(50).anomalyModifier(50).build());
        Tributes.register(Items.f_42686_, SimpleTribute.builder().lifeEnergy(15000).hostileModifier(100).diseaseModifier(100).build());
        Tributes.register(Items.f_42747_, SimpleTribute.builder().lifeEnergy(2500).successModifier(100).hostileModifier(-500).build());
        Tributes.register((Item)ModItems.ELASTIC_FIBERS.get(), SimpleTribute.builder().diseaseModifier(1).anomalyModifier(1).build());
        Tributes.register((Item)ModItems.TOUGH_FIBERS.get(), SimpleTribute.builder().diseaseModifier(1).anomalyModifier(1).build());
    }

    record FuzzyTribute(Predicate<ItemStack> predicate, Tribute tribute) {
    }
}

