/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.api.tribute;

import com.github.elenterius.biomancy.api.tribute.Tribute;
import com.github.elenterius.biomancy.init.tags.ModMobEffectTags;
import com.github.elenterius.biomancy.mixin.accessor.SuspiciousStewItemAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record MobEffectTribute(int lifeEnergy, int successModifier, int diseaseModifier, int hostileModifier, int anomalyModifier) implements Tribute
{
    static Tribute from(ItemStack stack) {
        boolean isFoodItem;
        boolean isPotionItem = stack.m_41720_() instanceof PotionItem;
        boolean isSuspiciousStewItem = stack.m_41720_() instanceof SuspiciousStewItem;
        FoodProperties food = stack.getFoodProperties(null);
        boolean bl = isFoodItem = food != null && !food.m_38749_().isEmpty();
        if (!(isPotionItem || isSuspiciousStewItem || isFoodItem)) {
            return Tribute.EMPTY;
        }
        Builder builder = new Builder();
        if (isPotionItem) {
            List effectInstances = PotionUtils.m_43547_((ItemStack)stack);
            for (MobEffectInstance effectInstance2 : effectInstances) {
                builder.addEffect(effectInstance2);
            }
        }
        if (isSuspiciousStewItem) {
            SuspiciousStewItemAccessor.biomancy$ListPotionEffects(stack, effectInstance -> builder.addEffect((MobEffectInstance)effectInstance, 0.35f));
        }
        if (isFoodItem) {
            for (Pair pair : food.m_38749_()) {
                MobEffectInstance effectInstance2;
                effectInstance2 = (MobEffectInstance)pair.getFirst();
                float chance = ((Float)pair.getSecond()).floatValue();
                builder.addEffect(effectInstance2, chance * 0.25f);
            }
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int biomass() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.lifeEnergy == 0 && this.successModifier == 0 && this.diseaseModifier == 0 && this.hostileModifier == 0 && this.anomalyModifier == 0;
    }

    public static class Builder {
        public static final int BASE_POTION_DURATION = 900;
        private float lifeEnergy = 0.0f;
        private float diseaseModifier = 0.0f;
        private float successModifier = 0.0f;
        private float hostileModifier = 0.0f;
        private float anomalyModifier = 0.0f;

        private Builder() {
        }

        public Builder addEffect(MobEffectInstance instance) {
            this.addEffect(instance, 1.0f);
            return this;
        }

        public Builder addEffect(MobEffectInstance instance, float multiplier) {
            this.addEffect(instance.m_19544_(), instance.m_19564_(), instance.m_19557_(), multiplier);
            return this;
        }

        public Builder addEffect(MobEffect effect) {
            this.addEffect(effect, 0, 900, 1.0f);
            return this;
        }

        public Builder addEffect(MobEffect effect, int amplifier, int duration, float multiplier) {
            if (ModMobEffectTags.isCradleLifeEnergySource(effect)) {
                this.lifeEnergy += this.calculateEffectModifier(effect.m_8093_(), amplifier, duration, 60.0f) * multiplier;
            }
            if (ModMobEffectTags.isCradleDiseaseSource(effect)) {
                this.diseaseModifier += this.calculateEffectModifier(effect.m_8093_(), amplifier, duration, 15.0f) * multiplier;
            }
            if (ModMobEffectTags.isCradleSuccessSource(effect)) {
                this.successModifier += this.calculateEffectModifier(effect.m_8093_(), amplifier, duration, 50.0f) * multiplier;
            }
            if (ModMobEffectTags.isCradleHostilitySource(effect)) {
                this.hostileModifier += this.calculateEffectModifier(effect.m_8093_(), amplifier, duration, 15.0f) * multiplier;
            }
            if (ModMobEffectTags.isCradleAnomalySource(effect)) {
                this.anomalyModifier += this.calculateEffectModifier(effect.m_8093_(), amplifier, duration, 50.0f) * multiplier;
            }
            return this;
        }

        private float calculateEffectModifier(boolean isInstantEffect, int amplifier, int duration, float baseAmount) {
            if (isInstantEffect) {
                return ((float)amplifier + 1.0f) * baseAmount;
            }
            if (duration == -1) {
                return 1000000.0f;
            }
            float durationPct = (float)duration / 900.0f;
            return durationPct * baseAmount + ((float)amplifier + (float)amplifier * durationPct) * baseAmount;
        }

        public MobEffectTribute build() {
            return new MobEffectTribute(Math.round(this.lifeEnergy), Math.round(this.successModifier), Math.round(this.diseaseModifier), Math.round(this.hostileModifier), Math.round(this.anomalyModifier));
        }
    }
}

