/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.kyanite.deeperdarker.content.blocks.BloomingStemBlock;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BloomingStemFeature
extends Feature<NoneFeatureConfiguration> {
    private final List<Direction> DIRECTIONS = Arrays.stream(Direction.values()).filter(direction -> direction.m_122411_() > 0).toList();
    private final List<Direction> history = new ArrayList<Direction>(Stream.generate(() -> Direction.UP).limit(5L).toList());

    public BloomingStemFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        RandomSource random = pContext.m_225041_();
        if (!level.m_8055_(origin.m_7495_()).m_60713_((Block)DDBlocks.BLOOMING_SCULK_STONE.get())) {
            return false;
        }
        if (!level.m_8055_(origin.m_7494_()).m_60795_()) {
            return false;
        }
        int branches = random.m_216332_(1, 2);
        int length = random.m_216332_(6, 20);
        double probability = (double)branches / (double)length;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
        Direction direction = Direction.UP;
        Direction nextDirection = Direction.UP;
        for (int i = 0; i < length && level.m_8055_((BlockPos)blockPos).m_60795_() && level.m_8055_(blockPos.m_121945_(nextDirection)).m_60795_(); ++i) {
            this.history.set(i % 5, direction);
            Direction branchDirection = null;
            if (i > 6 && direction == Direction.UP && random.m_188500_() < probability) {
                BlockPos.MutableBlockPos branchBlockPos = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                branchDirection = Direction.values()[random.m_216332_(2, 5)];
                branchBlockPos.m_122173_(branchDirection);
                level.m_7731_((BlockPos)branchBlockPos, this.stemPlacement(branchDirection, branchDirection.m_122424_(), null), 3);
                probability /= 2.0;
            }
            level.m_7731_((BlockPos)blockPos, this.stemPlacement(direction, nextDirection, branchDirection), 3);
            direction = nextDirection;
            nextDirection = nextDirection.m_122434_().m_122479_() ? Direction.UP : this.randomDirection(random);
            blockPos.m_122173_(direction);
        }
        level.m_7731_((BlockPos)blockPos, this.stemPlacement(direction, direction.m_122424_(), null), 3);
        return true;
    }

    private Direction randomDirection(RandomSource random) {
        ArrayList<Direction> list = new ArrayList<Direction>(this.DIRECTIONS);
        for (Direction d : this.history) {
            list.remove(d);
            list.remove(d.m_122424_());
        }
        int dir = 0;
        float chance = 1.0f - 0.125f * (float)list.size();
        float f = random.m_188501_();
        while (chance < f) {
            chance += 0.125f;
            ++dir;
        }
        list.add(0, Direction.UP);
        return (Direction)list.get(dir);
    }

    private BlockState stemPlacement(Direction direction, Direction nextDirection, Direction branchDirection) {
        BlockState stem = (BlockState)((BlockState)((BlockState)((Block)DDBlocks.BLOOMING_STEM.get()).m_49966_().m_61124_((Property)BloomingStemBlock.DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55154_.get(direction.m_122424_()), (Comparable)Boolean.valueOf(true))).m_61124_((Property)PipeBlock.f_55154_.get(nextDirection), (Comparable)Boolean.valueOf(true));
        if (branchDirection == null) {
            return stem;
        }
        return (BlockState)stem.m_61124_((Property)PipeBlock.f_55154_.get(branchDirection), (Comparable)Boolean.valueOf(true));
    }
}

