/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.util;

import z1gned.goetyrevelation.util.MathUtils;

public interface Easing {
    public static final Easing IN_SINE = x -> (float)(1.0 - MathUtils.cos((float)((double)x * Math.PI / 2.0)));
    public static final Easing OUT_SINE = x -> (float)MathUtils.sin((float)((double)x * Math.PI / 2.0));
    public static final Easing IN_OUT_SINE = x -> (float)(-(MathUtils.cos((float)(Math.PI * (double)x)) - 1.0) / 2.0);
    public static final Easing IN_QUAD = x -> x * x;
    public static final Easing OUT_QUAD = x -> 1.0f - (1.0f - x) * (1.0f - x);
    public static final Easing IN_OUT_QUAD = x -> (float)((double)x < 0.5 ? (double)(2.0f * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
    public static final Easing IN_CUBIC = x -> x * x * x;
    public static final Easing OUT_CUBIC = x -> (float)(1.0 - Math.pow(1.0f - x, 3.0));
    public static final Easing INVERSE_OUT_CUBIC = x -> (float)Math.pow(1.0f - x, 3.0);
    public static final Easing IN_OUT_CUBIC = x -> (float)((double)x < 0.5 ? (double)(4.0f * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
    public static final Easing IN_QUART = x -> x * x * x * x;
    public static final Easing OUT_QUART = x -> (float)(1.0 - Math.pow(1.0f - x, 4.0));
    public static final Easing IN_OUT_QUART = x -> (float)((double)x < 0.5 ? (double)(8.0f * x * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
    public static final Easing IN_QUINT = x -> x * x * x * x * x;
    public static final Easing OUT_QUINT = x -> (float)(1.0 - Math.pow(1.0f - x, 5.0));
    public static final Easing IN_OUT_QUINT = x -> (float)((double)x < 0.5 ? (double)(16.0f * x * x * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
    public static final Easing IN_EXPO = x -> (float)(x == 0.0f ? 0.0 : Math.pow(2.0, 10.0f * x - 10.0f));
    public static final Easing OUT_EXPO = x -> (float)(x == 1.0f ? 1.0 : 1.0 - Math.pow(2.0, -10.0f * x));
    public static final Easing IN_OUT_EXPO = x -> (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0)));
    public static final Easing IN_CIRC = x -> (float)(1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));
    public static final Easing OUT_CIRC = x -> (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
    public static final Easing IN_OUT_CIRC = x -> (float)((double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0);
    public static final Easing IN_BACK = x -> {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return c3 * x * x * x - c1 * x * x;
    };
    public static final Easing OUT_BACK = x -> {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(x - 1.0f, 3.0) + (double)c1 * Math.pow(x - 1.0f, 2.0));
    };
    public static final Easing IN_OUT_BACK = x -> {
        float c1 = 1.70158f;
        float c2 = c1 * 1.525f;
        return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * (double)((c2 + 1.0f) * 2.0f * x - c2) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * (double)((c2 + 1.0f) * (x * 2.0f - 2.0f) + c2) + 2.0) / 2.0);
    };
    public static final Easing IN_ELASTIC = x -> {
        float c4 = 2.0943952f;
        return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * MathUtils.sin((float)(((double)(x * 10.0f) - 10.75) * (double)c4)));
    };
    public static final Easing OUT_ELASTIC = x -> {
        float c4 = 2.0943952f;
        return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * MathUtils.sin((float)(((double)(x * 10.0f) - 0.75) * (double)c4)) + 1.0);
    };
    public static final Easing IN_OUT_ELASTIC = x -> {
        float c5 = 1.3962634f;
        double v = MathUtils.sin((float)(((double)(20.0f * x) - 11.125) * (double)c5));
        return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * v) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * v / 2.0 + 1.0));
    };
    public static final Easing OUT_BOUNCE = x -> {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x < 1.0f / d1) {
            return n1 * x * x;
        }
        if (x < 2.0f / d1) {
            return n1 * (x -= (float)(1.5 / (double)d1)) * x + 0.75f;
        }
        if ((double)x < 2.5 / (double)d1) {
            return n1 * (x -= (float)(2.25 / (double)d1)) * x + 0.9375f;
        }
        return n1 * (x -= (float)(2.625 / (double)d1)) * x + 0.984375f;
    };
    public static final Easing IN_BOUNCE = x -> 1.0f - OUT_BOUNCE.calculate(1.0f - x);
    public static final Easing IN_OUT_BOUNCE = x -> (double)x < 0.5 ? (1.0f - OUT_BOUNCE.calculate(1.0f - 2.0f * x)) / 2.0f : (1.0f + OUT_BOUNCE.calculate(2.0f * x - 1.0f)) / 2.0f;
    public static final Easing QUADRATIC = x -> x * x - x;

    public float calculate(float var1);

    default public float interpolate(float f, float from, float to) {
        return from + this.calculate(f) * (to - from);
    }
}

