/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.mixin;

import com.Polarice3.Goety.common.entities.hostile.servants.ObsidianMonolith;
import com.Polarice3.Goety.common.entities.projectiles.NetherMeteor;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import z1gned.goetyrevelation.config.ModConfig;
import z1gned.goetyrevelation.util.ATAHelper;
import z1gned.goetyrevelation.util.PlayerAbilityHelper;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerAbilityHelper {
    @Unique
    private static final EntityDataAccessor<Float> SPIN = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Unique
    private static final EntityDataAccessor<Integer> INVUL = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> METEOR = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Integer> METEORING = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private ObsidianMonolith obsidianMonolith;

    protected PlayerMixin(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(SPIN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(INVUL, (Object)0);
        this.f_19804_.m_135372_(METEOR, (Object)0);
        this.f_19804_.m_135372_(METEORING, (Object)0);
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readNbt(CompoundTag p_36215_, CallbackInfo ci) {
        this.setMeteor(p_36215_.m_128451_("Meteor"));
        this.setMeteoring(p_36215_.m_128451_("Meteoring"));
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void writeNbt(CompoundTag p_36265_, CallbackInfo ci) {
        p_36265_.m_128405_("Meteor", this.getMeteor());
        p_36265_.m_128405_("Meteoring", this.getMeteoring());
    }

    @Inject(at={@At(value="RETURN")}, method={"isInvulnerableTo"}, cancellable=true)
    private void invul(DamageSource p_36249_, CallbackInfoReturnable<Boolean> cir) {
        if (!p_36249_.m_276093_(DamageTypes.f_268724_) && this.getInvulTick() > 0 && ((Boolean)ModConfig.PLAYER_INVULNERABLE.get()).booleanValue()) {
            cir.setReturnValue((Object)true);
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268415_) && this.getMeteoring() > 0) {
            cir.setReturnValue((Object)true);
        }
        if (p_36249_.m_269533_(DamageTypeTags.f_268745_) && ATAHelper.hasHalo(this)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"aiStep"})
    private void spinTick(CallbackInfo ci) {
        if (this.getInvulTick() > 0) {
            this.setInvulTick(this.getInvulTick() - 1);
        }
        if (this.m_9236_().f_46443_ && this.m_6084_()) {
            if (this.getSpin() < 3.14f) {
                this.setSpin(this.getSpin() + 0.01f);
            } else {
                this.setSpin(-3.14f);
            }
        }
        if (this.m_6084_()) {
            if (ATAHelper.hasHalo(this)) {
                if (this.getMeteor() > 0) {
                    this.setMeteor(this.getMeteor() - 1);
                }
                if (this.getMeteoring() > 0) {
                    this.setMeteoring(this.getMeteoring() - 1);
                }
                if (this.m_9236_().m_46472_() == Level.f_46429_ && this.f_19797_ % 25 == 0) {
                    this.m_5634_(0.8f);
                }
            }
            if (this.getMeteoring() > 0) {
                ServerLevel serverLevel;
                if (this.f_19797_ % 20 == 0) {
                    BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.m_20208_(0.2), this.m_20186_(), this.m_20262_(0.2));
                    while ((double)blockPos.m_123342_() < this.m_20186_() + 64.0 && !this.m_9236_().m_8055_((BlockPos)blockPos).m_60804_((BlockGetter)this.m_9236_(), (BlockPos)blockPos)) {
                        blockPos.m_122173_(Direction.UP);
                    }
                    if ((double)blockPos.m_123342_() > this.m_20186_() + 32.0) {
                        NetherMeteor fireball = this.getNetherMeteor();
                        fireball.setDangerous(false);
                        fireball.m_6034_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                        this.m_9236_().m_7967_((Entity)fireball);
                    }
                }
                if (!this.m_9236_().f_46443_ && !(serverLevel = (ServerLevel)this.m_9236_()).m_46470_()) {
                    serverLevel.m_8606_(0, 6000, true, true);
                }
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDeathSound"}, cancellable=true)
    private void deathSound(CallbackInfoReturnable<SoundEvent> cir) {
        if (ATAHelper.hasHalo(this)) {
            cir.setReturnValue((Object)((SoundEvent)ModSounds.APOSTLE_DEATH.get()));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getHurtSound"}, cancellable=true)
    private void hurtSound(DamageSource p_36310_, CallbackInfoReturnable<SoundEvent> cir) {
        if (ATAHelper.hasHalo(this)) {
            cir.setReturnValue((Object)((SoundEvent)ModSounds.APOSTLE_HURT.get()));
        }
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"), index=1, method={"hurt"})
    private float modifyTokenDamage(float p_21017_) {
        if (this.getInvulTick() > 0 && !((Boolean)ModConfig.PLAYER_INVULNERABLE.get()).booleanValue()) {
            p_21017_ *= 0.2f;
        }
        return ATAHelper.hasHalo(this) && this.m_9236_().m_46472_() == Level.f_46429_ ? p_21017_ / 2.0f : p_21017_;
    }

    @Override
    public float getSpin() {
        return ((Float)this.f_19804_.m_135370_(SPIN)).floatValue();
    }

    @Override
    public void setSpin(float spin) {
        this.f_19804_.m_135381_(SPIN, (Object)Float.valueOf(spin));
    }

    @Override
    public int getInvulTick() {
        return (Integer)this.f_19804_.m_135370_(INVUL);
    }

    @Override
    public void setInvulTick(int tick) {
        this.f_19804_.m_135381_(INVUL, (Object)tick);
    }

    @Override
    public int getMeteor() {
        return (Integer)this.f_19804_.m_135370_(METEOR);
    }

    @Override
    public void setMeteor(int tick) {
        this.f_19804_.m_135381_(METEOR, (Object)tick);
    }

    @Override
    public int getMeteoring() {
        return (Integer)this.f_19804_.m_135370_(METEORING);
    }

    @Override
    public void setMeteoring(int tick) {
        this.f_19804_.m_135381_(METEORING, (Object)tick);
    }

    @Override
    public ObsidianMonolith getMonolith() {
        return this.obsidianMonolith;
    }

    @Override
    public void setMonolith(ObsidianMonolith obsidianMonolith) {
        this.obsidianMonolith = obsidianMonolith;
    }

    @Unique
    @NotNull
    private NetherMeteor getNetherMeteor() {
        int range = this.m_21223_() < this.m_21233_() / 2.0f ? 450 : 900;
        int trueRange = this.m_21223_() < this.m_21223_() / 4.0f ? range / 2 : range;
        RandomSource random = this.m_9236_().f_46441_;
        double d = random.m_188499_() ? 1.0 : -1.0;
        double e = random.m_188499_() ? 1.0 : -1.0;
        double d2 = (double)random.m_188503_(trueRange) * d;
        double d3 = -900.0;
        double d4 = (double)random.m_188503_(trueRange) * e;
        return new NetherMeteor(this.m_9236_(), (LivingEntity)this, d2, d3, d4);
    }
}

