/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.mixin;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.entities.util.SummonCircle;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import z1gned.goetyrevelation.config.ModConfig;
import z1gned.goetyrevelation.entitiy.ModEntityType;
import z1gned.goetyrevelation.entitiy.WitherServant;
import z1gned.goetyrevelation.util.ATAHelper;
import z1gned.goetyrevelation.util.ApollyonAbilityHelper;
import z1gned.goetyrevelation.util.PlayerAbilityHelper;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int allTitlesApostle_1_20_1$ambientSoundTime;

    @Shadow
    protected abstract float m_6121_();

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    public abstract float m_21223_();

    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(at={@At(value="RETURN")}, method={"checkTotemDeathProtection"}, cancellable=true)
    private void protect(DamageSource p_21263_, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity living = (LivingEntity)this;
        if (living instanceof Player && ATAHelper.hasHalo((LivingEntity)(player = (Player)living)) && ((PlayerAbilityHelper)player).getMeteor() <= 0) {
            player.m_21153_(player.m_21233_() / 2.0f);
            ((PlayerAbilityHelper)player).setMeteor(36000);
            ((PlayerAbilityHelper)player).setMeteoring(6000);
            ((PlayerAbilityHelper)player).setInvulTick(400);
            this.allTitlesApostle_1_20_1$spawnWitherServant(player);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"tick"})
    private void getTarget(CallbackInfo ci) {
        Mob mob;
        LivingEntity target;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Mob && (target = (mob = (Mob)livingEntity).m_5448_()) != null && mob.m_6084_() && target instanceof Player) {
            Player player = (Player)target;
            Owned owned = (Owned)mob.m_9236_().m_45963_(Owned.class, TargetingConditions.f_26872_, (LivingEntity)mob, 0.0, 0.0, 0.0, new AABB(mob.m_20183_()).m_82400_(mob.m_21133_(Attributes.f_22277_)));
            if (owned != null && owned.getTrueOwner() == player && !owned.m_21224_()) {
                mob.m_6710_((LivingEntity)owned);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canStandOnFluid"}, cancellable=true)
    private void walkOnLava(FluidState p_204042_, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && ATAHelper.hasHalo((LivingEntity)(player = (Player)livingEntity))) {
            cir.setReturnValue((Object)(p_204042_.m_192917_((Fluid)Fluids.f_76195_) && !player.m_6047_() ? 1 : 0));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"baseTick"})
    private void ambientSound(CallbackInfo ci) {
        Player player;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player && ATAHelper.hasHalo((LivingEntity)(player = (Player)livingEntity)) && player.m_6084_() && player.m_217043_().m_188503_(1000) < this.allTitlesApostle_1_20_1$ambientSoundTime++) {
            this.allTitlesApostle_1_20_1$resetAmbientSoundTime();
            if (((Boolean)ModConfig.ENABLE_PLAYER_AMBIENT.get()).booleanValue()) {
                player.m_5496_((SoundEvent)ModSounds.APOSTLE_AMBIENT.get(), this.m_6121_(), this.m_6121_());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playHurtSound"})
    private void hurtSound(DamageSource p_21160_, CallbackInfo ci) {
        this.allTitlesApostle_1_20_1$resetAmbientSoundTime();
    }

    @Inject(at={@At(value="HEAD")}, method={"getMaxHealth"}, cancellable=true)
    private void setMaxHealth(CallbackInfoReturnable<Float> cir) {
        Apostle apostle;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Apostle && ((ApollyonAbilityHelper)(apostle = (Apostle)livingEntity)).allTitlesApostle_1_20_1$isApollyon()) {
            cir.setReturnValue((Object)Float.valueOf((float)(1.0 * (Double)ModConfig.APOLLYON_HEALTH.get())));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    private void burn(DamageSource p_21016_, float p_21017_, CallbackInfoReturnable<Boolean> cir) {
        if (p_21016_.m_7639_() == null) {
            return;
        }
        Entity entity = p_21016_.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.m_6673_(p_21016_) && ATAHelper.hasHalo((LivingEntity)player)) {
                this.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BURN_HEX.get(), 100));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    private void canHurt(DamageSource p_21016_, float p_21017_, CallbackInfoReturnable<Boolean> cir) {
        Apostle apostle;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Apostle && (apostle = (Apostle)livingEntity).isInNether() && ((ApollyonAbilityHelper)apostle).allTitlesApostle_1_20_1$isApollyon() && ((ApollyonAbilityHelper)apostle).allTitlesApostle_1_20_1$getHitCooldown() > 0) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"actuallyHurt"})
    private void setCooldown(DamageSource p_21240_, float p_21241_, CallbackInfo ci) {
        Apostle apostle;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Apostle && (apostle = (Apostle)livingEntity).isInNether() && ((ApollyonAbilityHelper)apostle).allTitlesApostle_1_20_1$isApollyon()) {
            ((ApollyonAbilityHelper)apostle).allTitlesApostle_1_20_1$setHitCooldown(30);
        }
    }

    @ModifyVariable(at=@At(value="STORE"), method={"actuallyHurt"}, argsOnly=true)
    private float setHealthValue(float p_21154_) {
        Apostle apostle;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Apostle && ((ApollyonAbilityHelper)(apostle = (Apostle)livingEntity)).allTitlesApostle_1_20_1$isApollyon()) {
            return Math.min(p_21154_, (float)(1.0 * (Double)ModConfig.APOLLYON_HURT_LIMIT.get()));
        }
        return p_21154_;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;onLivingDamage(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/damagesource/DamageSource;F)F"), method={"actuallyHurt"})
    private float setHealthValue(LivingEntity entity, DamageSource src, float amount) {
        Apostle apostle;
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Apostle && ((ApollyonAbilityHelper)(apostle = (Apostle)livingEntity)).allTitlesApostle_1_20_1$isApollyon()) {
            return Math.min(ForgeHooks.onLivingDamage((LivingEntity)entity, (DamageSource)src, (float)amount), (float)(1.0 * (Double)ModConfig.APOLLYON_HURT_LIMIT.get()));
        }
        return ForgeHooks.onLivingDamage((LivingEntity)entity, (DamageSource)src, (float)amount);
    }

    @Unique
    private void allTitlesApostle_1_20_1$spawnWitherServant(Player player) {
        Level level = player.m_9236_();
        WitherServant witherBoss = new WitherServant((EntityType<? extends WitherServant>)((EntityType)ModEntityType.WITHER_SERVANT.get()), player.m_9236_());
        witherBoss.setTrueOwner((LivingEntity)player);
        witherBoss.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(player.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
        SummonCircle summonCircle = new SummonCircle(level, player.m_20183_().m_7918_(0, 2, 0), (Entity)witherBoss, false, true, (LivingEntity)player);
        level.m_7967_((Entity)summonCircle);
    }

    @Unique
    public int allTitlesApostle_1_20_1$getAmbientSoundInterval() {
        return 440;
    }

    @Unique
    private void allTitlesApostle_1_20_1$resetAmbientSoundTime() {
        this.allTitlesApostle_1_20_1$ambientSoundTime = -this.allTitlesApostle_1_20_1$getAmbientSoundInterval();
    }
}

