/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.mixin;

import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.hostile.servants.Damned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.common.magic.spells.necromancy.HauntedSkullSpell;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import z1gned.goetyrevelation.util.ATAHelper;

@Mixin(value={HauntedSkullSpell.class})
public abstract class HauntedSkullSpellMixin
extends SummonSpell {
    @Unique
    ItemStack stack;

    @Inject(at={@At(value="HEAD")}, method={"SpellResult"}, cancellable=true, remap=false)
    private void createDamned(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat, CallbackInfo ci) {
        this.stack = staff;
        if (ATAHelper.hasHalo(caster) && staff.m_150930_((Item)ModItems.NETHER_STAFF.get())) {
            ci.cancel();
            this.commonResult(worldIn, caster);
            int potency = spellStat.getPotency();
            int duration = spellStat.getDuration();
            int burning = spellStat.getBurning();
            double radius = spellStat.getRadius();
            if (WandUtil.enchantedFocus((LivingEntity)caster)) {
                potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
                duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster) + 1;
                burning = WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.BURNING.get()), (LivingEntity)caster);
                radius = WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster);
            }
            if (!this.isShifting(caster)) {
                int i = 1;
                if (this.rightStaff(staff)) {
                    i = 3;
                }
                for (int i1 = 0; i1 < i; ++i1) {
                    BlockPos blockpos = caster.m_20183_().m_7918_(-2 + caster.m_217043_().m_188503_(5), 1, -2 + caster.m_217043_().m_188503_(5));
                    Damned summonedentity = new Damned((EntityType)ModEntityType.DAMNED.get(), (Level)worldIn);
                    summonedentity.setTrueOwner(caster);
                    summonedentity.m_20035_(blockpos, 0.0f, 0.0f);
                    summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                    summonedentity.setLimitedLife(MathHelper.minutesToTicks((int)1) * duration);
                    if (potency > 0) {
                        int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
                        summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost));
                    }
                    this.setTarget(caster, (Mob)summonedentity);
                    worldIn.m_7967_((Entity)summonedentity);
                    this.summonAdvancement(caster, (LivingEntity)summonedentity);
                }
                worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"commonResultHit"}, cancellable=true, remap=false)
    private void result(ServerLevel worldIn, LivingEntity caster, CallbackInfo ci) {
        if (ATAHelper.hasHalo(caster) && this.stack.m_150930_((Item)ModItems.NETHER_STAFF.get())) {
            ci.cancel();
            if (this.isShifting(caster)) {
                for (Entity entity : worldIn.m_8583_()) {
                    if (!(entity instanceof Damned)) continue;
                    this.teleportServants(caster, entity);
                }
                for (int i = 0; i < caster.m_9236_().f_46441_.m_188503_(35) + 10; ++i) {
                    worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11862_, this.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }
}

