/*
 * Decompiled with CFR 0.152.
 */
package z1gned.goetyrevelation.client.shader.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import z1gned.goetyrevelation.client.event.NetherStarShaders;
import z1gned.goetyrevelation.client.uniform.ATAUniform;
import z1gned.goetyrevelation.client.uniform.UniformType;
import z1gned.goetyrevelation.client.util.NetherStarTextures;

@OnlyIn(value=Dist.CLIENT)
public class NetherStarShaderInstance
extends ShaderInstance {
    private final List<Runnable> applyCallbacks = new LinkedList<Runnable>();

    protected NetherStarShaderInstance(ResourceProvider resourceProvider, ResourceLocation shaderLocation, VertexFormat format) throws IOException {
        super(resourceProvider, shaderLocation, format);
    }

    public static NetherStarShaderInstance create(ResourceProvider resourceProvider, ResourceLocation loc, VertexFormat format) {
        try {
            return new NetherStarShaderInstance(resourceProvider, loc, format);
        }
        catch (IOException var4) {
            throw new RuntimeException("Failed to initialize shader.", var4);
        }
    }

    private static float[] parseFloats(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        float[] values = new float[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_13888_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception var8) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)var8);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }

    private static int[] parseInts(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        int[] values = new int[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_13897_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception var8) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)var8);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }

    private static double[] parseDoubles(int count, JsonArray jsonValues) throws ChainedJsonException {
        int i = 0;
        double[] values = new double[Math.max(count, 16)];
        for (JsonElement jsonValue : jsonValues) {
            try {
                values[i++] = GsonHelper.m_144769_((JsonElement)jsonValue, (String)"value");
            }
            catch (Exception var8) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)var8);
                chainedjsonexception.m_135908_("values[" + i + "]");
                throw chainedjsonexception;
            }
        }
        if (count > 1 && jsonValues.size() == 1) {
            Arrays.fill(values, 1, values.length, values[0]);
        }
        return Arrays.copyOfRange(values, 0, count);
    }

    public void onApply(Runnable callback) {
        this.applyCallbacks.add(callback);
    }

    public void m_173363_() {
        for (Runnable callback : this.applyCallbacks) {
            callback.run();
        }
        super.m_173363_();
    }

    @Nullable
    public ATAUniform getUniform(@NotNull String name) {
        return (ATAUniform)super.m_173348_(name);
    }

    public void m_173354_(@NotNull JsonElement json) throws ChainedJsonException {
        JsonObject obj = GsonHelper.m_13918_((JsonElement)json, (String)"uniform");
        String name = GsonHelper.m_13906_((JsonObject)obj, (String)"name");
        String typeStr = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
        UniformType type = UniformType.parse(typeStr);
        if (type == null) {
            throw new ChainedJsonException("Invalid type '%s'. See UniformType enum. All vanilla types supported.".formatted(typeStr));
        }
        int count = GsonHelper.m_13927_((JsonObject)obj, (String)"count");
        block0 : switch (type) {
            case FLOAT: {
                switch (count) {
                    case 2: {
                        type = UniformType.VEC2;
                        break;
                    }
                    case 3: {
                        type = UniformType.VEC3;
                        break;
                    }
                    case 4: {
                        type = UniformType.VEC4;
                    }
                }
                break;
            }
            case INT: {
                switch (count) {
                    case 2: {
                        type = UniformType.I_VEC2;
                        break;
                    }
                    case 3: {
                        type = UniformType.I_VEC3;
                        break;
                    }
                    case 4: {
                        type = UniformType.I_VEC4;
                    }
                }
                break;
            }
            case U_INT: {
                switch (count) {
                    case 2: {
                        type = UniformType.U_VEC2;
                        break block0;
                    }
                    case 3: {
                        type = UniformType.U_VEC3;
                        break block0;
                    }
                    case 4: {
                        type = UniformType.U_VEC4;
                    }
                }
            }
        }
        ATAUniform uniform = ATAUniform.makeUniform(name, type, count, (Shader)this);
        JsonArray jsonValues = GsonHelper.m_13933_((JsonObject)obj, (String)"values");
        if (jsonValues.size() != count && jsonValues.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + count + ", found " + jsonValues.size() + ")");
        }
        switch (type.getCarrier()) {
            case INT: 
            case U_INT: {
                uniform.glUniformI(NetherStarShaderInstance.parseInts(count, jsonValues));
                break;
            }
            case FLOAT: 
            case MATRIX: {
                uniform.glUniformF(false, NetherStarShaderInstance.parseFloats(count, jsonValues));
                break;
            }
            case DOUBLE: 
            case D_MATRIX: {
                uniform.glUniformD(false, NetherStarShaderInstance.parseDoubles(count, jsonValues));
            }
        }
        this.f_173331_.add(uniform);
    }

    public void setSampler(int index, ResourceLocation texture) {
        TextureAtlasSprite atlasSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        super.m_173350_("CosmicSampler" + index, (Object)Minecraft.m_91087_().m_91097_().m_118506_(atlasSprite.m_247685_()).m_117963_());
        NetherStarShaders.COSMIC_UVS[index * 4] = atlasSprite.m_118409_();
        NetherStarShaders.COSMIC_UVS[index * 4 + 1] = atlasSprite.m_118411_();
        NetherStarShaders.COSMIC_UVS[index * 4 + 2] = atlasSprite.m_118410_();
        NetherStarShaders.COSMIC_UVS[index * 4 + 3] = atlasSprite.m_118412_();
    }

    public void setCosmicIcon() {
        block12: for (int i = 0; i < 10; ++i) {
            this.setSampler(i, NetherStarTextures.rl(i));
            float[] uvs = new float[]{NetherStarShaders.COSMIC_UVS[i * 4], NetherStarShaders.COSMIC_UVS[i * 4 + 1], NetherStarShaders.COSMIC_UVS[i * 4 + 2], NetherStarShaders.COSMIC_UVS[i * 4 + 3]};
            RenderSystem.applyModelViewMatrix();
            switch (i) {
                case 0: {
                    if (NetherStarShaders.cosmicUVs != null) {
                        NetherStarShaders.cosmicUVs.m_5941_(uvs);
                    }
                }
                case 1: {
                    if (NetherStarShaders.cosmicUVs1 != null) {
                        NetherStarShaders.cosmicUVs1.m_5941_(uvs);
                    }
                }
                case 2: {
                    if (NetherStarShaders.cosmicUVs2 != null) {
                        NetherStarShaders.cosmicUVs2.m_5941_(uvs);
                    }
                }
                case 3: {
                    if (NetherStarShaders.cosmicUVs3 != null) {
                        NetherStarShaders.cosmicUVs3.m_5941_(uvs);
                    }
                }
                case 4: {
                    if (NetherStarShaders.cosmicUVs4 != null) {
                        NetherStarShaders.cosmicUVs4.m_5941_(uvs);
                    }
                }
                case 5: {
                    if (NetherStarShaders.cosmicUVs5 != null) {
                        NetherStarShaders.cosmicUVs5.m_5941_(uvs);
                    }
                }
                case 6: {
                    if (NetherStarShaders.cosmicUVs6 != null) {
                        NetherStarShaders.cosmicUVs6.m_5941_(uvs);
                    }
                }
                case 7: {
                    if (NetherStarShaders.cosmicUVs7 != null) {
                        NetherStarShaders.cosmicUVs7.m_5941_(uvs);
                    }
                }
                case 8: {
                    if (NetherStarShaders.cosmicUVs8 != null) {
                        NetherStarShaders.cosmicUVs8.m_5941_(uvs);
                    }
                }
                case 9: {
                    if (NetherStarShaders.cosmicUVs9 == null) continue block12;
                    NetherStarShaders.cosmicUVs9.m_5941_(uvs);
                }
            }
        }
    }
}

