/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.teampotato.ruok.config.RuOK;

public class Render {
    private static final HashSet<EntityType<?>> blackListCache = new HashSet();
    private static final HashSet<EntityType<?>> whiteListCache = new HashSet();
    private static int maxRenderedEntities;
    private static double[] closestDistances;
    private static Entity[] closestEntities;

    private static void initializeArrays() {
        maxRenderedEntities = RuOK.get().maxEntityEntities;
        closestDistances = new double[maxRenderedEntities];
        closestEntities = new Entity[maxRenderedEntities];
        Arrays.fill(closestDistances, Double.MAX_VALUE);
        Arrays.fill(closestEntities, null);
    }

    private static void initMobList() {
        Optional entityTypeOpt;
        List<String> blackConfig = RuOK.get().blackListedEntities;
        List<String> whiteConfig = RuOK.get().whiteListedEntities;
        for (String bc : blackConfig) {
            entityTypeOpt = EntityType.m_20632_((String)bc);
            entityTypeOpt.ifPresent(blackListCache::add);
        }
        for (String wc : whiteConfig) {
            entityTypeOpt = EntityType.m_20632_((String)wc);
            entityTypeOpt.ifPresent(whiteListCache::add);
        }
    }

    public static void reloadList() {
        blackListCache.clear();
        whiteListCache.clear();
        Render.initMobList();
    }

    public static boolean isBlacklisted(@NotNull Entity entity) {
        return blackListCache.contains(entity.m_6095_());
    }

    public static boolean isWhitelisted(@NotNull Entity entity) {
        return whiteListCache.contains(entity.m_6095_());
    }

    @NotNull
    public static Optional<Pair<Component, String>> getTotalCountForDisplay(@NotNull ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        int total = stack.m_41613_();
        String itemName = stack.m_41786_().getString();
        String displayText = Render.getColorForCount(total) + itemName + "x" + total;
        return !RuOK.get().isAlwaysShowItemCount && total <= stack.m_41741_() ? Optional.of(Pair.of((Object)Component.m_130674_((String)itemName), (Object)itemName)) : Optional.of(Pair.of((Object)Component.m_130674_((String)displayText), (Object)displayText));
    }

    private static String getColorForCount(int count) {
        if (count == 64) {
            return "\u00a7c";
        }
        if (count > 32) {
            return "\u00a76";
        }
        if (count > 16) {
            return "\u00a72";
        }
        return "\u00a7a";
    }

    public static void reloadRenderEntity() {
        maxRenderedEntities = RuOK.get().maxEntityEntities;
        Render.initializeArrays();
    }

    public static void entityCull(Entity entity, CallbackInfo ci) {
        if (!RuOK.get().onCull) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            double distanceToPlayer = entity.m_20280_((Entity)mc.f_91074_);
            if (Render.isWhitelisted(entity)) {
                return;
            }
            if (Render.isBossEntity(entity)) {
                return;
            }
            if (Render.isBlacklisted(entity)) {
                ci.cancel();
                return;
            }
            boolean inClosestEntities = Render.updateClosestEntities(entity, distanceToPlayer);
            if (distanceToPlayer > (double)(RuOK.get().entitiesDistance * RuOK.get().entitiesDistance) || !inClosestEntities) {
                ci.cancel();
            }
        }
    }

    private static boolean updateClosestEntities(Entity entity, double distanceToPlayer) {
        int i;
        int farthestIndex = -1;
        double maxDistance = -1.0;
        for (i = 0; i < maxRenderedEntities; ++i) {
            if (closestEntities[i] == null || closestEntities[i].m_6084_()) continue;
            Render.closestEntities[i] = null;
            Render.closestDistances[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < maxRenderedEntities; ++i) {
            if (closestEntities[i] == entity) {
                Render.closestDistances[i] = distanceToPlayer;
                return true;
            }
            if (closestEntities[i] != null && !(closestDistances[i] > maxDistance)) continue;
            farthestIndex = i;
            maxDistance = closestDistances[i];
        }
        if (farthestIndex != -1 && (closestEntities[farthestIndex] == null || distanceToPlayer < maxDistance)) {
            Render.closestEntities[farthestIndex] = entity;
            Render.closestDistances[farthestIndex] = distanceToPlayer;
            return true;
        }
        return false;
    }

    private static boolean isBossEntity(@NotNull Entity entity) {
        return entity instanceof Ghast || entity instanceof EnderDragon;
    }

    static {
        Render.initMobList();
        Render.initializeArrays();
    }
}

