/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEnchantments;
import vectorwing.farmersdelight.common.item.KnifeItem;

public class StainedKnifeItem
extends KnifeItem {
    private static final String CHARGE_TAG = "Charge";
    private static final String HEATED_TAG = "Heated";
    private static final int MAX_CHARGE = 64;

    public StainedKnifeItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().f_46443_) {
            CompoundTag tag = stack.m_41784_();
            int charge = tag.m_128451_(CHARGE_TAG);
            boolean isHeated = tag.m_128471_(HEATED_TAG);
            int lifeGraspLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)DDEnchantments.LIFE_GRASP.get()), (ItemStack)stack);
            if (isHeated) {
                target.m_20254_(7);
                this.spitExperiencePoint(target, attacker, 3 + lifeGraspLevel);
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    target.m_6469_(attacker.m_269291_().m_269075_(player), 2.0f);
                }
                if (--charge <= 0) {
                    charge = 0;
                    isHeated = false;
                }
            } else if ((charge += 1 + lifeGraspLevel) >= 64) {
                charge = 64;
                isHeated = true;
                attacker.m_7292_(new MobEffectInstance((MobEffect)DDEffects.RAVENOUS_RUSH.get(), 160, 0));
            }
            tag.m_128405_(CHARGE_TAG, charge);
            tag.m_128379_(HEATED_TAG, isHeated);
            stack.m_41751_(tag);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void spitExperiencePoint(LivingEntity target, LivingEntity attacker, int exp) {
        Level level = attacker.m_9236_();
        ExperienceOrb xpOrb = new ExperienceOrb(level, target.m_20185_(), target.m_20186_() + 0.5, target.m_20189_(), exp);
        xpOrb.m_20334_((level.m_213780_().m_188500_() - 0.5) * 0.5, level.m_213780_().m_188500_() * 0.5, (level.m_213780_().m_188500_() - 0.5) * 0.5);
        level.m_7967_((Entity)xpOrb);
    }

    public boolean m_142522_(ItemStack stack) {
        return super.m_142522_(stack);
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(HEATED_TAG)) {
            int charge = tag.m_128451_(CHARGE_TAG);
            return Math.round(13.0f * (float)charge / 64.0f);
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(HEATED_TAG)) {
            return 13634442;
        }
        return super.m_142159_(stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_(HEATED_TAG)) {
            tooltip.add((Component)Component.m_237115_((String)"dungeonsdelight.tooltip.heat_charge").m_130946_(" " + stack.m_41784_().m_128451_(CHARGE_TAG) + " / 64").m_130938_(formatStyle -> formatStyle.m_178520_(13634442)));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"dungeonsdelight.tooltip.heat_charge").m_130946_(" " + stack.m_41784_().m_128451_(CHARGE_TAG) + " / 64").m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

