/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.monster_yam;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamAnimations;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntity;
import org.joml.Vector3f;

public class MonsterYamEntityModel<T extends MonsterYamEntity>
extends HierarchicalModel<T> {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();
    public static final ModelLayerLocation LAYER_LOC = new ModelLayerLocation(new ResourceLocation("dungeonsdelight", "monster_yam"), "main");
    private final ModelPart root;
    private final ModelPart center;
    private final ModelPart flower;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart lower;

    public MonsterYamEntityModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.center = this.root.m_171324_("center");
        this.flower = this.center.m_171324_("flower");
        this.leftarm = this.center.m_171324_("leftarm");
        this.leftarm.m_171324_("forearm");
        this.rightarm = this.center.m_171324_("rightarm");
        this.rightarm.m_171324_("forearm2");
        this.rightarm.m_171324_("forearm3");
        this.center.m_171324_("flower");
        this.lower = this.root.m_171324_("lower");
        this.lower.m_171324_("rightleg");
        this.lower.m_171324_("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition center = root.m_171599_("center", CubeListBuilder.m_171558_().m_171514_(46, 40).m_171488_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(46, 15).m_171488_(-5.0f, -8.0f, -5.0f, 10.0f, 8.0f, 10.0f, new CubeDeformation(0.5f)).m_171514_(0, 25).m_171488_(-7.0f, -18.0f, -7.0f, 14.0f, 11.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-7.0f, -18.0f, -7.0f, 14.0f, 11.0f, 14.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)0.0f));
        PartDefinition leftarm = center.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171488_(1.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(56, 0).m_171488_(1.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)7.0f, (float)-14.0f, (float)0.5f));
        leftarm.m_171599_("forearm", CubeListBuilder.m_171558_().m_171514_(50, 58).m_171488_(-1.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(32, 53).m_171488_(-1.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)0.5f));
        PartDefinition rightarm = center.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(66, 0).m_171480_().m_171488_(-3.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(56, 0).m_171480_().m_171488_(-3.0f, 18.0f, -1.5f, 2.0f, 12.0f, 3.0f, new CubeDeformation(0.2f)).m_171555_(false), PartPose.m_171419_((float)-7.0f, (float)-14.0f, (float)0.5f));
        rightarm.m_171599_("forearm2", CubeListBuilder.m_171558_().m_171514_(50, 58).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)0.5f));
        rightarm.m_171599_("forearm3", CubeListBuilder.m_171558_().m_171514_(32, 53).m_171480_().m_171488_(-3.0f, -2.0f, -3.0f, 4.0f, 20.0f, 5.0f, new CubeDeformation(0.2f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)0.5f));
        PartDefinition flower = center.m_171599_("flower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)-0.2929f));
        flower.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(-7.2929f, -25.0f, 0.2929f, 16.0f, 25.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-0.7071f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        flower.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171480_().m_171488_(-8.7071f, -25.0f, 0.2929f, 16.0f, 25.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)-0.7071f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)-0.5f));
        lower.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(0, 75).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(68, 58).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.2f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)0.0f));
        lower.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(0, 75).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(68, 58).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)2.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(MonsterYamEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(MonsterYamAnimations.walking, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.flower.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.flower.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    protected void m_267799_(AnimationDefinition definition, float limbSwing, float limbSwingAmount, float maxAnimationSpeed, float scaleFactor) {
        long i = (long)(limbSwing * 50.0f * maxAnimationSpeed);
        float f = Math.min(limbSwingAmount * scaleFactor, 1.0f);
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)definition, (long)i, (float)f, (Vector3f)ANIMATION_VECTOR_CACHE);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

