/*
 * Decompiled with CFR 0.152.
 */
package lykrast.bookwyrms.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lykrast.bookwyrms.BookWyrms;
import lykrast.bookwyrms.config.ConfigValues;
import lykrast.bookwyrms.registry.BWEntities;
import lykrast.bookwyrms.registry.BWItems;
import lykrast.bookwyrms.registry.BWSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class BookWyrmEntity
extends Animal {
    public static final int GREY = 0;
    public static final int RED = 1;
    public static final int ORANGE = 2;
    public static final int GREEN = 3;
    public static final int BLUE = 4;
    public static final int TEAL = 5;
    public static final int PURPLE = 6;
    private static final EntityDataAccessor<Byte> DATA = SynchedEntityData.m_135353_(BookWyrmEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int DIGESTING_MASK = 128;
    private static final int TREASURE_MASK = 64;
    private static final int TYPE_MASK = 63;
    private int enchLevel;
    private int digestSpeed;
    private double indigestChance;
    private int digested;
    private int toDigest;
    private int digestTimer;
    private int mutagenColor = -1;
    private int mutagenStat = -1;
    private static final TagKey<?>[] POOLS = new TagKey[]{null, ItemTags.create((ResourceLocation)BookWyrms.rl("pool_red")), ItemTags.create((ResourceLocation)BookWyrms.rl("pool_orange")), ItemTags.create((ResourceLocation)BookWyrms.rl("pool_green")), ItemTags.create((ResourceLocation)BookWyrms.rl("pool_blue")), ItemTags.create((ResourceLocation)BookWyrms.rl("pool_teal")), ItemTags.create((ResourceLocation)BookWyrms.rl("pool_purple"))};
    private static final ResourceLocation[] LOOT_TABLES = new ResourceLocation[]{BookWyrms.rl("entities/book_wyrm_grey"), BookWyrms.rl("entities/book_wyrm_red"), BookWyrms.rl("entities/book_wyrm_orange"), BookWyrms.rl("entities/book_wyrm_green"), BookWyrms.rl("entities/book_wyrm_blue"), BookWyrms.rl("entities/book_wyrm_teal"), BookWyrms.rl("entities/book_wyrm_purple")};

    public BookWyrmEntity(EntityType<? extends BookWyrmEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42517_, Items.f_42690_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_6162_() && (stack.m_150930_(Items.f_42690_) || stack.m_150930_((Item)BWItems.chadBolus.get()))) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.SUCCESS;
            }
            this.toDigest += BookWyrmEntity.getBookValue(stack);
            if (this.digestTimer <= 0) {
                this.digestTimer = this.digestSpeed;
            }
            this.setDigesting(true);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_ && this.isDigesting()) {
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (!this.m_9236_().f_46443_ && this.toDigest > 0) {
            --this.digestTimer;
            if (this.digestTimer <= 0) {
                ++this.digested;
                --this.toDigest;
                this.digestTimer = this.digestSpeed;
                if (this.digested >= this.enchLevel) {
                    this.digested -= this.enchLevel;
                    this.makeBook();
                }
                if (this.toDigest <= 0) {
                    this.setDigesting(false);
                }
            }
        }
    }

    private void makeBook() {
        ItemStack stack;
        if (this.f_19796_.m_188500_() < this.indigestChance) {
            stack = new ItemStack((ItemLike)BWItems.chadBolus.get(), this.f_19796_.m_216332_(1, this.enchLevel));
            this.m_5496_((SoundEvent)BWSounds.wyrmIndigestion.get(), 1.0f, 1.0f);
        } else {
            List<EnchantmentInstance> ench = BookWyrmEntity.selectEnchantments(this.f_19796_, ConfigValues.DISABLE_COLOR ? null : POOLS[this.getWyrmType()], this.enchLevel, this.isTreasure());
            if (ench.isEmpty()) {
                stack = new ItemStack((ItemLike)BWItems.chadBolusSus.get(), this.enchLevel);
                this.m_5496_((SoundEvent)BWSounds.wyrmIndigestion.get(), 1.0f, 1.0f);
            } else {
                stack = new ItemStack((ItemLike)Items.f_42690_);
                for (EnchantmentInstance e : ench) {
                    EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)e);
                }
                this.m_5496_((SoundEvent)BWSounds.wyrmBook.get(), 1.0f, 1.0f);
            }
        }
        this.m_19983_(stack);
        this.m_146850_(GameEvent.f_157810_);
    }

    private static List<EnchantmentInstance> selectEnchantments(RandomSource rand, @Nullable TagKey<Item> testers, int enchantability, boolean treasure) {
        ArrayList list = Lists.newArrayList();
        List<EnchantmentInstance> enchants = BookWyrmEntity.getValidEnchantments(BookWyrmEntity.getTestersFromTag(testers), enchantability, treasure);
        if (enchants.isEmpty() && testers != null && ConfigValues.FALLBACK) {
            enchants = BookWyrmEntity.getValidEnchantments(BookWyrmEntity.getTestersFromTag(null), enchantability, treasure);
        }
        if (!enchants.isEmpty()) {
            EnchantmentInstance added = WeightedRandom.m_216822_((RandomSource)rand, enchants).orElse(null);
            if (added == null) {
                return list;
            }
            list.add(added);
            int remaining = enchantability - added.f_44947_.m_6183_(added.f_44948_);
            while (rand.m_188503_(50) <= enchantability) {
                BookWyrmEntity.filterCompatibleEnchantments(enchants, added, remaining);
                if (enchants.isEmpty()) break;
                added = WeightedRandom.m_216822_((RandomSource)rand, enchants).orElse(null);
                if (added == null) {
                    return list;
                }
                list.add(added);
                remaining -= added.f_44947_.m_6183_(added.f_44948_);
                enchantability /= 2;
            }
        }
        return list;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> list, EnchantmentInstance ench, int cap) {
        Iterator<EnchantmentInstance> iterator = list.iterator();
        while (iterator.hasNext()) {
            EnchantmentInstance next = iterator.next();
            if (next.f_44947_.m_6183_(next.f_44948_) <= cap && ench.f_44947_.m_44695_(next.f_44947_)) continue;
            iterator.remove();
        }
    }

    private static List<EnchantmentInstance> getValidEnchantments(List<ItemStack> testers, int enchatability, boolean treasure) {
        ArrayList list = Lists.newArrayList();
        block0: for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            if (!ench.isAllowedOnBooks() || !treasure && ench.m_6591_() || !ench.m_6592_() && (!treasure || !ConfigValues.ALLOW_UNDISCOVERABLE) || !BookWyrmEntity.compatibleTesters(ench, testers)) continue;
            for (int i = ench.m_6586_(); i > ench.m_44702_() - 1; --i) {
                if (enchatability < ench.m_6183_(i) || enchatability > ench.m_6175_(i) && !ConfigValues.IGNORE_MAX) continue;
                list.add(new EnchantmentInstance(ench, i));
                continue block0;
            }
        }
        return list;
    }

    private static boolean compatibleTesters(Enchantment ench, List<ItemStack> testers) {
        if (testers.isEmpty()) {
            return true;
        }
        for (ItemStack stack : testers) {
            if (!ench.canApplyAtEnchantingTable(stack)) continue;
            return true;
        }
        return false;
    }

    private static List<ItemStack> getTestersFromTag(@Nullable TagKey<Item> tag) {
        ArrayList list = Lists.newArrayList();
        if (tag == null) {
            return list;
        }
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(tag)) {
            list.add(new ItemStack((ItemLike)item));
        }
        return list;
    }

    public static int getBookValue(ItemStack stack) {
        if (stack.m_150930_((Item)BWItems.chadBolus.get())) {
            return 1;
        }
        int total = 0;
        for (Map.Entry e : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            total += ((Enchantment)e.getKey()).m_6183_(((Integer)e.getValue()).intValue());
        }
        return total;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        BookWyrmEntity child = (BookWyrmEntity)((EntityType)BWEntities.bookWyrm.get()).m_20615_((Level)world);
        BookWyrmEntity.mixGenes(this, mate instanceof BookWyrmEntity ? (BookWyrmEntity)mate : this, child, this.f_19796_);
        return child;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData group, @Nullable CompoundTag compound) {
        BookWyrmEntity.wildGenes(this, world.m_213780_());
        return super.m_6518_(world, difficulty, spawnType, group, compound);
    }

    public static void wildGenes(BookWyrmEntity wyrm, RandomSource rand) {
        if (rand.m_188499_()) {
            wyrm.setWyrmType(0);
        } else {
            wyrm.setWyrmType(rand.m_216332_(1, 6));
        }
        wyrm.setTreasure(rand.m_188503_(100) == 0);
        wyrm.enchLevel = rand.m_188503_(3) == 0 ? ConfigValues.WILDRARE_LEVEL_BASE + rand.m_216332_(0, ConfigValues.WILDRARE_LEVEL_INC) + rand.m_216332_(0, ConfigValues.WILDRARE_LEVEL_INC) : ConfigValues.WILD_LEVEL_BASE + rand.m_216332_(0, ConfigValues.WILD_LEVEL_INC) + rand.m_216332_(0, ConfigValues.WILD_LEVEL_INC);
        wyrm.digestSpeed = rand.m_188503_(3) == 0 ? ConfigValues.WILDRARE_SPEED_BASE + rand.m_216332_(0, ConfigValues.WILDRARE_SPEED_INC) + rand.m_216332_(0, ConfigValues.WILDRARE_SPEED_INC) : ConfigValues.WILD_SPEED_BASE + rand.m_216332_(0, ConfigValues.WILD_SPEED_INC) + rand.m_216332_(0, ConfigValues.WILD_SPEED_INC);
        wyrm.indigestChance = rand.m_188503_(3) == 0 ? ConfigValues.WILDRARE_INDIGEST_BASE + rand.m_188500_() * ConfigValues.WILDRARE_INDIGEST_INC + rand.m_188500_() * ConfigValues.WILDRARE_INDIGEST_INC : ConfigValues.WILD_INDIGEST_BASE + rand.m_188500_() * ConfigValues.WILD_INDIGEST_INC + rand.m_188500_() * ConfigValues.WILD_INDIGEST_INC;
        wyrm.clampGenes();
    }

    public static void mixGenes(BookWyrmEntity a, BookWyrmEntity b, BookWyrmEntity child, RandomSource rand) {
        if (a.hasMutagenColor() || b.hasMutagenColor()) {
            BookWyrmEntity donor = !b.hasMutagenColor() ? a : (!a.hasMutagenColor() ? b : (rand.m_188499_() ? a : b));
            child.setWyrmType(donor.getMutagenColor());
            donor.clearMutagenColor();
        } else {
            int chartType = a.getWyrmType();
            if (chartType == 0) {
                chartType = b.getWyrmType();
            } else if (b.getWyrmType() != 0 && rand.m_188499_()) {
                chartType = b.getWyrmType();
            }
            child.setWyrmType(BookWyrmEntity.offspringWyrmType(chartType, rand));
        }
        int treasureChance = 100;
        if (a.isTreasure() || b.isTreasure()) {
            treasureChance = a.isTreasure() && b.isTreasure() ? 10 : 20;
        }
        child.setTreasure(rand.m_188503_(treasureChance) == 0);
        if (a.getMutagenStat() == 6 || b.getMutagenStat() == 6) {
            BookWyrmEntity donor = b.getMutagenStat() != 6 ? a : (a.getMutagenStat() != 6 ? b : (rand.m_188499_() ? a : b));
            child.copyGenes(donor);
            donor.clearMutagenStat();
        } else {
            int min = Math.min(a.enchLevel, b.enchLevel);
            int max = Math.max(a.enchLevel, b.enchLevel);
            child.enchLevel = min == ConfigValues.MAX_LEVEL && max == ConfigValues.MAX_LEVEL ? ConfigValues.MAX_LEVEL : rand.m_216332_(min, max) + rand.m_216332_(0, ConfigValues.VARIANCE_LEVEL * 2) - ConfigValues.VARIANCE_LEVEL;
            min = Math.min(a.digestSpeed, b.digestSpeed);
            max = Math.max(a.digestSpeed, b.digestSpeed);
            child.digestSpeed = min == ConfigValues.MIN_SPEED && max == ConfigValues.MIN_SPEED ? ConfigValues.MIN_SPEED : rand.m_216332_(min, max) + rand.m_216332_(0, ConfigValues.VARIANCE_SPEED * 2) - ConfigValues.VARIANCE_SPEED;
            double min2 = Math.min(a.indigestChance, b.indigestChance);
            double max2 = Math.max(a.indigestChance, b.indigestChance);
            child.indigestChance = min2 - ConfigValues.MIN_INDIGEST < 0.01 && max2 - ConfigValues.MIN_INDIGEST < 0.01 ? ConfigValues.MIN_INDIGEST : (ConfigValues.MAX_INDIGEST - min2 < 0.01 && ConfigValues.MAX_INDIGEST - max2 < 0.01 ? ConfigValues.MAX_INDIGEST : min2 + rand.m_188500_() * (max2 - min2) + rand.m_188500_() * ConfigValues.VARIANCE_INDIGEST * 2.0 - ConfigValues.VARIANCE_INDIGEST);
        }
        if (a.hasMutagenStat() && child.mutateStats(a.getMutagenStat())) {
            a.clearMutagenStat();
        }
        if (b.hasMutagenStat() && child.mutateStats(b.getMutagenStat())) {
            b.clearMutagenStat();
        }
        child.clampGenes();
    }

    private void copyGenes(BookWyrmEntity donor) {
        this.enchLevel = donor.enchLevel;
        this.digestSpeed = donor.digestSpeed;
        this.indigestChance = donor.indigestChance;
    }

    private void clampGenes() {
        this.enchLevel = Mth.m_14045_((int)this.enchLevel, (int)ConfigValues.MIN_LEVEL, (int)ConfigValues.MAX_LEVEL);
        this.digestSpeed = Mth.m_14045_((int)this.digestSpeed, (int)ConfigValues.MIN_SPEED, (int)ConfigValues.MAX_SPEED);
        this.indigestChance = Mth.m_14008_((double)this.indigestChance, (double)ConfigValues.MIN_INDIGEST, (double)ConfigValues.MAX_INDIGEST);
    }

    private boolean mutateStats(int mutagen) {
        switch (mutagen) {
            case 0: {
                this.enchLevel += ConfigValues.MUTAGEN_LEVEL;
                return true;
            }
            case 1: {
                this.enchLevel -= ConfigValues.MUTAGEN_LEVEL;
                return true;
            }
            case 2: {
                this.digestSpeed -= ConfigValues.MUTAGEN_SPEED;
                return true;
            }
            case 3: {
                this.digestSpeed += ConfigValues.MUTAGEN_SPEED;
                return true;
            }
            case 4: {
                this.indigestChance -= ConfigValues.MUTAGEN_INDIGEST;
                return true;
            }
            case 5: {
                this.indigestChance += ConfigValues.MUTAGEN_INDIGEST;
                return true;
            }
        }
        return false;
    }

    public static int offspringWyrmType(int type, RandomSource rand) {
        if (rand.m_188499_()) {
            return type;
        }
        if (type == 0) {
            return rand.m_216332_(1, 6);
        }
        if (rand.m_188503_(5) < 2) {
            return 0;
        }
        if (type == 6) {
            return rand.m_216332_(1, 5);
        }
        if (rand.m_188503_(6) == 0) {
            return 6;
        }
        if (type == 4 || type == 5) {
            int i = rand.m_216332_(1, 4);
            if (i >= type) {
                ++i;
            }
            return i;
        }
        switch (type) {
            case 1: {
                return rand.m_188499_() ? 2 : 4;
            }
            case 2: {
                return rand.m_188499_() ? 1 : 4;
            }
            case 3: {
                return rand.m_188499_() ? 4 : 5;
            }
        }
        return type;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42517_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)BWSounds.wyrmIdle.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)BWSounds.wyrmHurt.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)BWSounds.wyrmDeath.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public int getEnchantingLevel() {
        return this.enchLevel;
    }

    public int getDigestingSpeed() {
        return this.digestSpeed;
    }

    public double getIndigestionChance() {
        return this.indigestChance;
    }

    public int getDigestedLevels() {
        return this.digested;
    }

    public int getLevelsToDigest() {
        return this.toDigest;
    }

    public int getMutagenColor() {
        return this.mutagenColor;
    }

    public boolean hasMutagenColor() {
        return this.mutagenColor >= 0;
    }

    public void setMutagenColor(int color) {
        this.mutagenColor = color;
    }

    public void clearMutagenColor() {
        this.mutagenColor = -1;
    }

    public int getMutagenStat() {
        return this.mutagenStat;
    }

    public boolean hasMutagenStat() {
        return this.mutagenStat >= 0;
    }

    public void setMutagenStat(int stat) {
        this.mutagenStat = stat;
    }

    public void clearMutagenStat() {
        this.mutagenStat = -1;
    }

    public int getWyrmType() {
        return Mth.m_14045_((int)((Byte)this.f_19804_.m_135370_(DATA) & 0x3F), (int)0, (int)6);
    }

    public void setWyrmType(int type) {
        byte b = (Byte)this.f_19804_.m_135370_(DATA);
        this.f_19804_.m_135381_(DATA, (Object)((byte)(b & 0xFFFFFFC0 | type & 0x3F)));
    }

    public boolean isDigesting() {
        return ((Byte)this.f_19804_.m_135370_(DATA) & 0x80) > 0;
    }

    public void setDigesting(boolean digest) {
        byte b = (byte)((Byte)this.f_19804_.m_135370_(DATA) & 0xFFFFFF7F);
        if (digest) {
            b = (byte)(b | 0x80);
        }
        this.f_19804_.m_135381_(DATA, (Object)b);
    }

    public boolean isTreasure() {
        return ((Byte)this.f_19804_.m_135370_(DATA) & 0x40) > 0;
    }

    public void setTreasure(boolean treasure) {
        byte b = (byte)((Byte)this.f_19804_.m_135370_(DATA) & 0xFFFFFFBF);
        if (treasure) {
            b = (byte)(b | 0x40);
        }
        this.f_19804_.m_135381_(DATA, (Object)b);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setWyrmType(compound.m_128451_("WyrmType"));
        this.setTreasure(compound.m_128471_("Treasure"));
        this.enchLevel = compound.m_128451_("BWLevel");
        this.digestSpeed = compound.m_128451_("BWSpeed");
        this.indigestChance = compound.m_128459_("BWIndigestion");
        this.digested = compound.m_128451_("Digested");
        this.toDigest = compound.m_128451_("ToDigest");
        this.digestTimer = compound.m_128451_("DigestTimer");
        this.setDigesting(this.toDigest > 0);
        if (compound.m_128441_("MutagenC")) {
            this.mutagenColor = compound.m_128451_("MutagenC");
        }
        if (compound.m_128441_("MutagenS")) {
            this.mutagenStat = compound.m_128451_("MutagenS");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("WyrmType", this.getWyrmType());
        compound.m_128379_("Treasure", this.isTreasure());
        compound.m_128405_("BWLevel", this.enchLevel);
        compound.m_128405_("BWSpeed", this.digestSpeed);
        compound.m_128347_("BWIndigestion", this.indigestChance);
        compound.m_128405_("Digested", this.digested);
        compound.m_128405_("ToDigest", this.toDigest);
        compound.m_128405_("DigestTimer", this.digestTimer);
        if (this.mutagenColor >= 0) {
            compound.m_128405_("MutagenC", this.mutagenColor);
        }
        if (this.mutagenStat >= 0) {
            compound.m_128405_("MutagenS", this.mutagenStat);
        }
    }

    protected ResourceLocation m_7582_() {
        return LOOT_TABLES[this.getWyrmType()];
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA, (Object)0);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

