/*
 * Decompiled with CFR 0.152.
 */
package lykrast.bookwyrms.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final ForgeConfigSpec.BooleanValue allowUndiscoverable;
    public final ForgeConfigSpec.BooleanValue disableSusWarning;
    public final ForgeConfigSpec.BooleanValue disableColoredPools;
    public final ForgeConfigSpec.BooleanValue fallbackOnGlobal;
    public final ForgeConfigSpec.BooleanValue ignoreMaxCost;
    public final ForgeConfigSpec.IntValue enchLvlMin;
    public final ForgeConfigSpec.IntValue enchLvlMax;
    public final ForgeConfigSpec.IntValue digestSpeedMin;
    public final ForgeConfigSpec.IntValue digestSpeedMax;
    public final ForgeConfigSpec.DoubleValue indigestMin;
    public final ForgeConfigSpec.DoubleValue indigestMax;
    public final ForgeConfigSpec.IntValue enchLvlWildMin;
    public final ForgeConfigSpec.IntValue enchLvlWildMax;
    public final ForgeConfigSpec.IntValue enchLvlWildRareMin;
    public final ForgeConfigSpec.IntValue enchLvlWildRareMax;
    public final ForgeConfigSpec.IntValue digestSpeedWildMin;
    public final ForgeConfigSpec.IntValue digestSpeedWildMax;
    public final ForgeConfigSpec.IntValue digestSpeedWildRareMin;
    public final ForgeConfigSpec.IntValue digestSpeedWildRareMax;
    public final ForgeConfigSpec.DoubleValue indigestWildMin;
    public final ForgeConfigSpec.DoubleValue indigestWildMax;
    public final ForgeConfigSpec.DoubleValue indigestWildRareMin;
    public final ForgeConfigSpec.DoubleValue indigestWildRareMax;
    public final ForgeConfigSpec.IntValue enchLvlBreedVariance;
    public final ForgeConfigSpec.IntValue digestBreedVariance;
    public final ForgeConfigSpec.DoubleValue indigestBreedVariance;
    public final ForgeConfigSpec.IntValue enchLvlMutagen;
    public final ForgeConfigSpec.IntValue digestMutagen;
    public final ForgeConfigSpec.DoubleValue indigestMutagen;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Book recycling config");
        builder.push("enchanting");
        this.allowUndiscoverable = this.boolval(builder, "allowUndiscoverable", false, "Allow gold-eyed wyrms to also produce undiscoverable treasure enchants (in vanilla it's just Soul Speed and Swift Sneak)");
        this.disableSusWarning = this.boolval(builder, "disableSusWarning", false, "Makes the warning on Suspicious Chad Bolus less intrusive and don't tell people to report it to the modpack", "It appears when a given color and enchantment level have zero valid enchantments, which shouldn't happen in vanilla but may happen with configured values or unlucky mod compat", "For example I know it happens if the Alex's Mobs Straddleboard is the only item in the purple pool and the level is below 12");
        this.disableColoredPools = this.boolval(builder, "disableColoredPools", false, "Makes all Book Wyrms have all enchantments in their pool, making color purely cosmetic", "Same behavior as emptying all the pool tags");
        this.fallbackOnGlobal = this.boolval(builder, "fallbackOnGlobal", false, "Fall back on the global/gray enchantment pool if a colored wyrm has no matching enchantment (and would make suspicious bolus)");
        this.ignoreMaxCost = this.boolval(builder, "ignoreMaxCost", false, "Ignore upper level caps on enchantments, allowing wyrms to always make enchantments if they clear the lower cap", "For example Feather Falling IV has level range 23-29, meaning a lvl 30+ wyrm can never get it, enabling this would treat it as 23-9999999999 basically");
        builder.pop();
        builder.comment("Wyrm stats config");
        builder.push("genes");
        builder.comment("Absolute caps for the wyrm genes");
        builder.push("caps");
        this.enchLvlMin = this.intval(builder, "enchLvlMin", 3, 1, Short.MAX_VALUE, "Minimum enchanting level a wyrm can have", "Very low values can allow getting massive quantities of Sharpness/Efficiency/Power I");
        this.enchLvlMax = this.intval(builder, "enchLvlMax", 50, 1, Short.MAX_VALUE, "Maximum enchanting level a wyrm can have", "Very high values will result in no enchantments being available (unless Apotheosis or you enable ignoreMaxCost)");
        this.digestSpeedMin = this.intval(builder, "digestSpeedMin", 1, 1, Short.MAX_VALUE, "Fastest digesting speed (in ticks per level) a wyrm can have");
        this.digestSpeedMax = this.intval(builder, "digestSpeedMax", 600, 1, Short.MAX_VALUE, "Slowest digesting speed (in ticks per level) a wyrm can have");
        this.indigestMin = this.doubleval(builder, "indigestMin", 0.0, 0.0, 1.0, "Lowest indigestion chance (0 = 0%, 1 = 100%) a wyrm can have");
        this.indigestMax = this.doubleval(builder, "indigestMax", 1.0, 0.0, 1.0, "Highest indigestion chance (0 = 0%, 1 = 100%) a wyrm can have");
        builder.pop();
        builder.comment("Genes wild wyrms can have");
        builder.push("wild");
        this.enchLvlWildMin = this.intval(builder, "enchLvlWildMin", 3, 1, Short.MAX_VALUE, "Minimum enchanting level for wild wyrms");
        this.enchLvlWildMax = this.intval(builder, "enchLvlWildMax", 7, 1, Short.MAX_VALUE, "Maximum enchanting level for wild wyrms");
        this.enchLvlWildRareMin = this.intval(builder, "enchLvlWildRareMin", 8, 1, Short.MAX_VALUE, "Minimum enchanting level for rare wild wyrms (1/3 chance)");
        this.enchLvlWildRareMax = this.intval(builder, "enchLvlWildRareMax", 12, 1, Short.MAX_VALUE, "Maximum enchanting level for rare wild wyrms (1/3 chance)");
        this.digestSpeedWildMin = this.intval(builder, "digestSpeedWildMin", 200, 1, Short.MAX_VALUE, "Fastest digesting speed for wild wyrms");
        this.digestSpeedWildMax = this.intval(builder, "digestSpeedWildMax", 300, 1, Short.MAX_VALUE, "Slowest digesting speed for wild wyrms");
        this.digestSpeedWildRareMin = this.intval(builder, "digestSpeedWildRareMin", 140, 1, Short.MAX_VALUE, "Fastest digesting speed for rare wild wyrms (1/3 chance)");
        this.digestSpeedWildRareMax = this.intval(builder, "digestSpeedWildRareMax", 200, 1, Short.MAX_VALUE, "Slowest digesting speed for rare wild wyrms (1/3 chance)");
        this.indigestWildMin = this.doubleval(builder, "indigestWildMin", 0.01, 0.0, 1.0, "Lowest indigestion chance for wild wyrms");
        this.indigestWildMax = this.doubleval(builder, "indigestWildMax", 0.09, 0.0, 1.0, "Highest indigestion chance for wild wyrms");
        this.indigestWildRareMin = this.doubleval(builder, "indigestWildRareMin", 0.5, 0.0, 1.0, "Lowest indigestion chance for rare wild wyrms (1/3 chance)", "Yes by default the rare wild for indigestion have a very high chance");
        this.indigestWildRareMax = this.doubleval(builder, "indigestWildRareMax", 0.7, 0.0, 1.0, "Highest indigestion chance for rare wild wyrms (1/3 chance)", "Yes by default the rare wild for indigestion have a very high chance");
        builder.pop();
        builder.comment("How do genes vary with breeding");
        builder.push("breeding");
        this.enchLvlBreedVariance = this.intval(builder, "enchLvlBreedVariance", 3, 0, Short.MAX_VALUE, "Maximum amount enchanting level can deviate for offsprings (up and down)");
        this.digestBreedVariance = this.intval(builder, "digestBreedVariance", 20, 0, Short.MAX_VALUE, "Maximum amount digesting speed can deviate for offsprings (up and down)");
        this.indigestBreedVariance = this.doubleval(builder, "indigestBreedVariance", 0.03, 0.0, 1.0, "Maximum amount indigestion chance can deviate for offsprings (up and down)");
        builder.pop();
        builder.comment("How much do stat wyrmutagen changes stats");
        builder.push("mutagen");
        this.enchLvlMutagen = this.intval(builder, "enchLvlMutagen", 8, 0, Short.MAX_VALUE, "How much does Level Up/Down Wyrmutagen changes enchanting level for the next offspring");
        this.digestMutagen = this.intval(builder, "digestMutagen", 60, 0, Short.MAX_VALUE, "How much does Speed Up/Down Wyrmutagen changes digesting speed for the next offspring");
        this.indigestMutagen = this.doubleval(builder, "indigestMutagen", 0.1, 0.0, 1.0, "How much does Digestion Up/Down Wyrmutagen changes indigestion chance for the next offspring");
        builder.pop();
        builder.pop();
    }

    private ForgeConfigSpec.IntValue intval(ForgeConfigSpec.Builder builder, String name, int def, int min, int max, String ... comments) {
        return builder.translation(name).comment(comments).defineInRange(name, def, min, max);
    }

    private ForgeConfigSpec.DoubleValue doubleval(ForgeConfigSpec.Builder builder, String name, double def, double min, double max, String ... comments) {
        return builder.translation(name).comment(comments).defineInRange(name, def, min, max);
    }

    private ForgeConfigSpec.BooleanValue boolval(ForgeConfigSpec.Builder builder, String name, boolean def, String ... comments) {
        return builder.translation(name).comment(comments).define(name, def);
    }
}

