/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.patreon.wings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.shadowsoffire.placebo.patreon.PatreonUtils;
import dev.shadowsoffire.placebo.patreon.WingsManager;
import dev.shadowsoffire.placebo.patreon.wings.IWingModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;

public class Wing
extends EntityModel<AbstractClientPlayer>
implements IWingModel {
    public static Wing INSTANCE;
    private final ModelPart bb_main;
    private final ModelPart cube_r1;
    private final ModelPart cube_r2;

    public Wing(ModelPart baked) {
        this.bb_main = baked.m_171324_("bb_main");
        this.cube_r1 = this.bb_main.m_171324_("cube_r1");
        this.cube_r2 = this.bb_main.m_171324_("cube_r2");
    }

    public void setupAnim(AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bb_main.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buf, int packedLightIn, AbstractClientPlayer player, float partialTicks, ResourceLocation texture, PlayerModel<AbstractClientPlayer> model) {
        if (player.m_20145_()) {
            return;
        }
        PatreonUtils.WingType type = WingsManager.getType(player.m_20148_());
        stack.m_85837_(0.0, 0.0, 0.065);
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ArmorItem) {
            stack.m_85837_(0.0, 0.0, 0.075);
        }
        stack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        float rotationTime = (float)(player.f_19797_ % 40) + partialTicks;
        this.setRotationAngle(this.cube_r1, 0.0f, 0.52365f + 0.17455f * (float)Math.sin(type.flapSpeed * Math.PI * (double)rotationTime / 20.0), 0.0f);
        this.setRotationAngle(this.cube_r2, 0.0f, -(0.52365f + 0.17455f * (float)Math.sin(type.flapSpeed * Math.PI * (double)rotationTime / 20.0)), 0.0f);
        this.m_7695_(stack, buf.m_6299_(RenderType.m_110473_((ResourceLocation)texture)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bb_main", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171597_("bb_main").m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, -8.0f, 0.0f, 16.0f, 16.0f, 0.0f, CubeDeformation.f_171458_.m_171469_(0.001f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        partdefinition.m_171597_("bb_main").m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, -8.0f, 0.0f, 16.0f, 16.0f, 0.0f, CubeDeformation.f_171458_.m_171469_(0.001f)), PartPose.m_171423_((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

