/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.structure;

import com.legacy.structure_gel.api.structure.IColoredBoundingBox;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public record StructureInfo(ResourceLocation dimension, BoundingBox fullBounds, List<PieceInfo> pieces) {
    public StructureInfo(ResourceLocation dimension, StructureStart start) {
        this(dimension, start.m_73601_(), PieceInfo.toPieceInfos(start.m_73602_()));
    }

    public record PieceInfo(BoundingBox bounds, int color) {
        private static List<PieceInfo> toPieceInfos(List<StructurePiece> pieces) {
            return pieces.stream().map(piece -> {
                int color;
                BoundingBox bounds = piece.m_73547_();
                if (piece instanceof IColoredBoundingBox) {
                    IColoredBoundingBox colored = (IColoredBoundingBox)piece;
                    color = colored.getBoundingBoxColor();
                } else {
                    PoolElementStructurePiece poolPiece;
                    color = piece instanceof PoolElementStructurePiece ? ((poolPiece = (PoolElementStructurePiece)piece).m_209918_().m_210539_() == StructureTemplatePool.Projection.RIGID ? IColoredBoundingBox.GREEN : IColoredBoundingBox.BLUE) : IColoredBoundingBox.GREEN;
                }
                return new PieceInfo(bounds, color);
            }).collect(Collectors.toList());
        }

        public float[] getColorFloats() {
            int c = this.color;
            float r = (float)(c >> 16 & 0xFF) / 255.0f;
            float g = (float)(c >> 8 & 0xFF) / 255.0f;
            float b = (float)(c & 0xFF) / 255.0f;
            return new float[]{r, g, b};
        }
    }
}

