/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FillTool
extends BuildingToolMode.ForCorners {
    public FillTool(String name, int modelIndex, boolean resetPosesAfterAction) {
        super(name, modelIndex, resetPosesAfterAction);
    }

    @Override
    protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
        if (level.f_46443_) {
            return;
        }
        WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
        if (!pallete.m_146337_()) {
            boolean retainState = BuildingToolItem.getProperty(stack, ToolModeProperty.RETAIN_STATE).value();
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.FILL_SHAPE);
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
            BlockState clickedState = level.m_8055_(clickedPos);
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            RandomSource rand = level.f_46441_;
            BoundingBox bounds = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
            BlockPos minCorner = new BlockPos(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_());
            BlockPos maxCorner = new BlockPos(bounds.m_162399_(), bounds.m_162400_(), bounds.m_162401_());
            int xSpan = bounds.m_71056_();
            int ySpan = bounds.m_71057_();
            int zSpan = bounds.m_71058_();
            double dx = (double)(xSpan - 1) / 2.0;
            double dy = (double)(ySpan - 1) / 2.0;
            double dz = (double)(zSpan - 1) / 2.0;
            Vec3 centerPos = Vec3.m_82528_((Vec3i)bounds.m_162394_());
            int total = this.forPosesWithin((Vec3i)minCorner, (Vec3i)maxCorner, pos -> {
                Optional opState;
                if (shape.isInside(centerPos.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())), dx, dy, dz) && (double)rand.m_188501_() < integrity && (opState = pallete.m_216829_(level.f_46441_)).isPresent()) {
                    BlockState state = (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_();
                    if (replace.shouldReplace(level, clickedState, (BlockPos)pos)) {
                        BlockState toPlace = retainState ? state : state.m_60734_().m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, state.m_60734_().m_5456_().m_7968_(), new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, true)));
                        return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates(toPlace, oldState) : toPlace, action);
                    }
                }
                return false;
            });
            ActionHistory.get(player).add(level, action);
            FillTool.sendPlaceMessage(player, replace, total, pallete);
        } else {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.missing_state", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
        }
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String shift = SGText.keybindString(options.f_92090_);
        String middleClick = SGText.keybindString(options.f_92097_);
        String rightClick = SGText.keybindString(options.f_92095_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{middleClick, Component.m_237110_((String)"item.structure_gel.building_tool.mode.select_corners", (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.FILL_SHAPE);
        properties.add(ToolModeProperty.RETAIN_STATE);
        properties.add(ToolModeProperty.REPLACE);
    }

    @Override
    public boolean hasBlockPalette() {
        return true;
    }
}

